/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap.json;

import java.util.UUID;

public class Application {
    public final String EXEWIN = "ExeWindows";
    public final String EXEUNIX = "ExeUnix";
    public final String WEB = "Web";
    public final String WEBSTART = "WebStart";
    public final String WEBDIRECT = "WebDirect";
    public String authentification;
    public String name;
    public String iconUrl;
    public String shortName;
    public String type;
    public String url;
    public String comment;
    public boolean authByCert;
    public boolean authByLogin;
    public boolean noAuth;
    public UUID id;

    public Application() {
        this.id = UUID.randomUUID();
    }

    public Application(String authentification, String name, String iconUrl, String comment, String shortName, String type, String url) {
        this.authentification = authentification;
        this.name = name;
        this.iconUrl = iconUrl;
        this.shortName = shortName;
        this.type = type;
        this.url = url;
    }

    public String getAuthentification() {
        return this.authentification;
    }

    public void setAuthentification(String authentification) {
        this.authentification = authentification;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isExeWin() {
        if (this.type == null) {
            return false;
        }
        return this.type.compareTo(this.EXEWIN) == 0;
    }

    public boolean isExeUnix() {
        if (this.type == null) {
            return false;
        }
        return this.type.compareTo(this.EXEUNIX) == 0;
    }

    public boolean isWebStart() {
        if (this.type == null) {
            return false;
        }
        return this.type.compareTo(this.WEBSTART) == 0;
    }

    public boolean isWeb() {
        if (this.type == null) {
            return false;
        }
        return this.type.compareTo(this.WEB) == 0;
    }

    public boolean isWebDirect() {
        if (this.type == null) {
            return false;
        }
        return this.type.compareTo(this.WEBDIRECT) == 0;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public boolean requireCert() {
        return this.authentification.equalsIgnoreCase("certificat") || this.authentification.equalsIgnoreCase("login+certificat");
    }

    public boolean requireLogin() {
        return this.authentification.equalsIgnoreCase("login") || this.authentification.equalsIgnoreCase("login+certificat");
    }

    public boolean withoutAuth() {
        return this.authentification.equalsIgnoreCase("none");
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Application && ((Application)obj).getName() != null && ((Application)obj).getName().equals(this.getName());
    }
}

