/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap.contrib;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URI;
import java.util.Hashtable;
import org.cocktail.trv.zap.contrib.StringCtrl;

public class SystemCtrl {
    public static final int SYSTEM_MAC_OS = 3;
    private static Hashtable sysEnvDico;
    private static int systemId;
    int SYSTEM_WIN_NT = 2;

    public static int systemId() {
        if (systemId == -1) {
            systemId = !SystemCtrl.osName().startsWith("Windows 9") && !SystemCtrl.osName().startsWith("Windows ME") ? (SystemCtrl.osName().startsWith("Windows") ? 2 : (SystemCtrl.osName().startsWith("Mac OS") ? 3 : 0)) : 1;
        }
        return systemId;
    }

    public static Hashtable javaEnv() {
        return System.getProperties();
    }

    public static Hashtable systemEnv() {
        if (sysEnvDico == null) {
            sysEnvDico = new Hashtable();
            try {
                sysEnvDico = SystemCtrl.stringToDico(SystemCtrl.execCommand(SystemCtrl.getSystemEnvCommand()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sysEnvDico;
    }

    private static String commandForCommand(String command) {
        if (SystemCtrl.systemId() == 1) {
            return "command /C " + command;
        }
        return SystemCtrl.systemId() == 2 ? "cmd /Y /C " + command : command;
    }

    public static String execCommand(String command) throws IOException {
        String line;
        StringBuffer result = new StringBuffer();
        Process proc = Runtime.getRuntime().exec(SystemCtrl.commandForCommand(command));
        BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        while ((line = reader.readLine()) != null) {
            result.append(line);
            result.append("\n");
        }
        return result.toString();
    }

    public static String systemVariable(String variable) {
        return (String)SystemCtrl.systemEnv().get(variable);
    }

    private static Hashtable stringToDico(String lines) {
        Hashtable<String, String> dico = new Hashtable<String, String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new StringReader(lines));
            while ((line = reader.readLine()) != null) {
                int i2 = line.indexOf("=");
                if (i2 <= 0) continue;
                String key = line.substring(0, i2);
                String value = line.substring(i2 + 1);
                dico.put(key, value);
            }
        }
        catch (Exception var7) {
            var7.printStackTrace();
        }
        return dico;
    }

    private static String getSystemEnvCommand() {
        return SystemCtrl.systemId() != 1 && SystemCtrl.systemId() != 2 ? "env" : "set";
    }

    public static String osName() {
        return System.getProperty("os.name");
    }

    public static String osVersion() {
        return System.getProperty("os.version");
    }

    public static String userName() {
        return System.getProperty("user.name");
    }

    public static String systemTempDir() {
        String tmp = System.getProperty("java.io.tmpdir");
        if (tmp == null) {
            tmp = SystemCtrl.systemVariable("TMP");
        }
        if (tmp == null) {
            tmp = SystemCtrl.systemVariable("TEMP");
        }
        if (tmp != null) {
            return tmp;
        }
        if (SystemCtrl.systemId() != 1 && SystemCtrl.systemId() != 2) {
            tmp = "/tmp";
            if (SystemCtrl.testTempDir(tmp)) {
                return tmp;
            }
            tmp = "/var/tmp";
            if (SystemCtrl.testTempDir(tmp)) {
                return tmp;
            }
        } else {
            if (SystemCtrl.testTempDir("C:\\Temp")) {
                return "C:\\Temp";
            }
            tmp = SystemCtrl.systemVariable("windir");
            if (tmp == null) {
                tmp = SystemCtrl.systemVariable("SystemRoot");
            }
            if (tmp == null) {
                tmp = "C:\\Windows\\";
            }
            if (SystemCtrl.testTempDir(tmp = SystemCtrl.normalizePath(tmp) + "Temp")) {
                return tmp;
            }
            tmp = "C:\\WINNT\\Temp";
            if (SystemCtrl.testTempDir(tmp)) {
                return tmp;
            }
        }
        return null;
    }

    public static String tempDir() {
        return StringCtrl.replace(SystemCtrl.systemTempDir(), "\\", "/");
    }

    private static String normalizePath(String path) {
        File f2 = new File(path);
        if (f2.isDirectory() && !path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return path;
    }

    private static boolean testTempDir(String path) {
        File f2 = new File(path);
        if (f2.exists()) {
            path = SystemCtrl.normalizePath(f2.getAbsolutePath()) + "tmp_SystemCtrl_testTempDir";
            try {
                f2 = new File(path);
                if (f2.exists()) {
                    f2.delete();
                }
                BufferedWriter w2 = new BufferedWriter(new FileWriter(path));
                w2.write("This is a test file.");
                w2.close();
                f2.delete();
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static String openFile(String filePath) {
        return filePath.indexOf(":/") > 1 ? SystemCtrl.openFileInBrowser(filePath) : SystemCtrl.openFileInSystem(filePath);
    }

    public static String openFileInSystem(String path) {
        String result = null;
        try {
            File f2 = new File(path);
            if (!f2.exists()) {
                result = "Fichier n'existe pas :\n" + path;
            } else {
                path = f2.getAbsolutePath();
                if (SystemCtrl.systemId() != 1 && SystemCtrl.systemId() != 2) {
                    if (SystemCtrl.systemId() == 3) {
                        SystemCtrl.execCommand("open " + path);
                    } else {
                        if (!(path = StringCtrl.replace(path, "\\", "/")).startsWith("/")) {
                            path = "/" + path;
                        }
                        path = "file://" + path;
                        result = SystemCtrl.openFileInBrowser(path);
                    }
                } else {
                    SystemCtrl.execCommand("start " + path);
                }
            }
        }
        catch (Throwable var3) {
            result = SystemCtrl.getExceptionMessage(var3);
        }
        return result;
    }

    public static String openFileInBrowser(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
            return null;
        }
        catch (Exception var2) {
            return SystemCtrl.getExceptionMessage(var2);
        }
    }

    private static String getExceptionMessage(Throwable ex) {
        String message = ex.getClass().getName();
        if (ex.getMessage() != null) {
            message = message + " : " + ex.getMessage();
        }
        return message;
    }

    static {
        systemId = -1;
    }
}

