/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap.contrib;

import java.util.StringTokenizer;
import java.util.Vector;

public class StringCtrl {
    private static final String emptyString = "";

    public static boolean like(String chain, String pattern) {
        boolean compareExact = true;
        if (chain != null && pattern != null) {
            StringTokenizer st = new StringTokenizer(pattern, "*?", true);
            while (st.hasMoreTokens()) {
                String part = st.nextToken();
                if (part.equals("*")) {
                    compareExact = false;
                    continue;
                }
                if (part.equals("?")) {
                    compareExact = true;
                    if (chain.length() == 0) {
                        return false;
                    }
                    chain = chain.substring(1);
                    continue;
                }
                if (compareExact) {
                    if (!chain.startsWith(part)) {
                        return false;
                    }
                    chain = chain.substring(part.length());
                } else {
                    if (chain.indexOf(part) == -1) {
                        return false;
                    }
                    chain = chain.substring(chain.indexOf(part) + part.length());
                }
                compareExact = true;
            }
            return chain.length() == 0 || !compareExact;
        }
        return false;
    }

    public static boolean containsIgnoreCase(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        int length = searchStr.length();
        if (length == 0) {
            return true;
        }
        for (int i2 = str.length() - length; i2 >= 0; --i2) {
            if (!str.regionMatches(true, i2, searchStr, 0, length)) continue;
            return true;
        }
        return false;
    }

    public static String replace(String s2, String what, String byWhat) {
        int i2;
        StringBuffer sb = new StringBuffer();
        if (byWhat == null) {
            byWhat = emptyString;
        }
        do {
            if ((i2 = s2.indexOf(what)) < 0) continue;
            sb.append(s2, 0, i2);
            sb.append(byWhat);
            s2 = s2.substring(i2 + what.length());
        } while (i2 != -1);
        sb.append(s2);
        return sb.toString();
    }

    public static boolean isEmpty(String s2) {
        if (s2 == null) {
            return true;
        }
        return (s2 = s2.trim()).length() == 0 || s2.equals("*nil*");
    }

    public static Vector toVector(String strings, String separator) {
        return StringCtrl.toVector(strings, separator, true);
    }

    public static Vector toVector(String strings, String separator, boolean ignoreEmptyString) {
        Vector<String> v2 = new Vector<String>();
        if (strings != null) {
            while (true) {
                boolean omitString;
                int idx;
                if ((idx = strings.indexOf(separator)) < 0) {
                    boolean bl = omitString = ignoreEmptyString && (strings == null || strings.trim().length() == 0);
                    if (omitString) break;
                    v2.addElement(strings);
                    break;
                }
                String s2 = strings.substring(0, idx);
                strings = strings.substring(idx + separator.length());
                omitString = ignoreEmptyString && (s2 == null || s2.trim().length() == 0);
                if (omitString) continue;
                v2.addElement(s2);
            }
        }
        return v2;
    }

    public static String normalize(String s2) {
        return StringCtrl.normalize(s2, null);
    }

    public static String normalize(String s2, String valueIfEmpty) {
        if (StringCtrl.isEmpty(s2)) {
            return valueIfEmpty != null ? valueIfEmpty : emptyString;
        }
        return s2.trim();
    }

    public static String toBasicString(String s2, String acceptChars, char charToReplace) {
        if (s2 != null && s2.length() != 0) {
            StringBuffer newStr = new StringBuffer();
            for (int i2 = 0; i2 < s2.length(); ++i2) {
                if (StringCtrl.isAcceptChar(s2.charAt(i2), acceptChars)) {
                    newStr.append(s2.charAt(i2));
                    continue;
                }
                newStr.append(charToReplace);
            }
            return newStr.toString();
        }
        return s2;
    }

    public static boolean isAcceptChar(char c2, String acceptChars) {
        boolean rep = StringCtrl.isBasicLetter(c2);
        if (!rep) {
            rep = StringCtrl.isBasicDigit(c2);
        }
        if (!rep && acceptChars != null) {
            for (int i2 = 0; i2 < acceptChars.length(); ++i2) {
                if (c2 != acceptChars.charAt(i2)) continue;
                return true;
            }
        }
        return rep;
    }

    public static String toBasicString(String aString) {
        return StringCtrl.toBasicString(aString, StringCtrl.defaultAcceptChars(), '_');
    }

    public static boolean isBasicLetter(char c2) {
        int numVal = Character.getNumericValue(c2);
        return Character.getNumericValue('a') <= numVal && numVal <= Character.getNumericValue('z') || Character.getNumericValue('A') <= numVal && numVal <= Character.getNumericValue('Z');
    }

    public static boolean isBasicDigit(char c2) {
        int numVal = Character.getNumericValue(c2);
        return Character.getNumericValue('0') <= numVal && numVal <= Character.getNumericValue('9');
    }

    public static boolean isAcceptChar(char c2) {
        return StringCtrl.isAcceptChar(c2, StringCtrl.defaultAcceptChars());
    }

    public static String defaultAcceptChars() {
        return "._-";
    }

    public static boolean isAcceptBasicString(String aString) {
        for (int i2 = 0; i2 < aString.length(); ++i2) {
            if (StringCtrl.isAcceptChar(aString.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static String get0Int(int number, int digits) {
        String s2 = String.valueOf(number);
        return StringCtrl.extendWithChars(s2, "0", digits, true);
    }

    public static String extendWithChars(String s2, String addChars, int length, boolean inFront) {
        while (s2.length() < length) {
            s2 = inFront ? addChars + s2 : s2 + addChars;
        }
        return s2;
    }
}

