/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.hc.client5.http.cookie.Cookie;
import org.cocktail.trv.zap.Constants;
import org.cocktail.trv.zap.Dock;
import org.cocktail.trv.zap.JnlpManipulator;
import org.cocktail.trv.zap.Messages;
import org.cocktail.trv.zap.contrib.StringCtrl;
import org.cocktail.trv.zap.contrib.SystemCtrl;
import org.cocktail.trv.zap.json.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class Launcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(Launcher.class);
    private static final String JAVAWS = "javaws";
    private static final Set<String> APPS_SECURISEES = new LinkedHashSet<String>(Arrays.asList("Mangue", "Abricot", "Amande", "ConnecteurCocktail", "Corossol", "JefyCopilote", "Kaki", "Kiwi", "Papaye", "Pie", "Sapics", "Situations", "gfc-Marches", "gfc-Missions", "gfc-Recettes", "gfc-Situations", "grh-Paye", "grh-Retour-Paye", "Bibasse", "GroupeScol", "JefyAdmin", "SuperPlan", "Maracuja", "gfc-Admin", "gfc-Compta"));

    public static Long start(Application appli, Cookie cookie) throws IOException {
        HashMap<String, Object> table;
        Long ticket = Launcher.createTicket();
        if (ticket != null) {
            table = new HashMap<String, Object>();
            table.put("ticket", ticket);
            table.put("url", appli.getUrl());
            if (cookie != null) {
                table.put("cookie", cookie);
            }
        } else {
            return null;
        }
        Dock.ticketStore.add(table);
        if (appli.isWebStart()) {
            return Launcher.launchWebStart(appli, ticket);
        }
        if (appli.isWebDirect()) {
            return Launcher.launchWebDirect(appli, cookie.toString());
        }
        if (appli.isWeb()) {
            return Launcher.launchWeb(appli, ticket);
        }
        LOGGER.info("Application de type inconnu :" + appli.getType());
        return null;
    }

    private static Long launchWebStart(Application appli, Long ticket) throws IOException {
        String jnlpTemp = Launcher.modifyJnlp(appli, appli.getUrl(), ticket);
        LOGGER.info("javaws " + jnlpTemp);
        File f2 = new File(jnlpTemp);
        if (StringCtrl.containsIgnoreCase(SystemCtrl.osName(), "windows") || StringCtrl.containsIgnoreCase(SystemCtrl.osName(), "linux")) {
            if (f2.canRead()) {
                Desktop.getDesktop().open(new File(jnlpTemp));
            } else {
                JOptionPane.showMessageDialog(null, Messages.getString("error.appWithoutSSO"), Messages.getString("error.casError"), 0);
                Runtime.getRuntime().exec("javaws " + appli.getUrl());
            }
        } else if (f2.canRead()) {
            SystemCtrl.openFileInSystem(jnlpTemp);
        } else {
            JOptionPane.showMessageDialog(null, Messages.getString("error.appWithoutSSO"), Messages.getString("error.casError"), 0);
            SystemCtrl.openFileInSystem(jnlpTemp);
        }
        return ticket;
    }

    private static Long launchWeb(Application appli, Long ticket) {
        String hostname = Launcher.getHostName();
        if (appli.withoutAuth()) {
            try {
                Desktop.getDesktop().browse(new URI(appli.getUrl()));
            }
            catch (IOException | URISyntaxException e2) {
                LOGGER.error(e2.getMessage(), e2);
            }
            LOGGER.info(appli.getUrl());
        } else {
            SystemCtrl.openFileInBrowser("http://" + hostname + ":" + Constants.SERVER_PORT + "/" + ticket);
            LOGGER.info("URL de callback: http://" + hostname + ":" + Constants.SERVER_PORT + "/" + ticket);
        }
        return ticket;
    }

    private static Long launchWebDirect(Application appli, String cookie) {
        try {
            if (appli.withoutAuth()) {
                LOGGER.info("launchWebDirect");
                LOGGER.info(appli.getUrl());
                Desktop.getDesktop().browse(new URI(appli.getUrl()));
            } else {
                LOGGER.info(appli.getUrl() + "/wa/sso?" + cookie);
                Desktop.getDesktop().browse(new URI(appli.getUrl() + "/wa/sso?" + cookie));
            }
        }
        catch (IOException | URISyntaxException e2) {
            LOGGER.error(e2.getMessage(), e2);
        }
        return 1L;
    }

    private static Long createTicket() {
        boolean present;
        Random rand = new Random();
        long ticket = 0L;
        while (present = Dock.isTicketValid(ticket = rand.nextLong()) != null) {
        }
        if (ticket < 0L) {
            ticket = ticket / 10L * -1L;
        }
        return ticket;
    }

    private static String modifyJnlp(Application application, String url, Long ticket) {
        LOGGER.info("modifying Jnlp...");
        Random r2 = new Random();
        int i2 = r2.nextInt();
        if (i2 < 0) {
            i2 *= -1;
        }
        String jnlpExtension = Launcher.computeJnlpExtension();
        String temp = Constants.getInstance().valueForKey("TEMP_DIR") + "/" + i2 + jnlpExtension;
        try {
            JnlpManipulator manipulator = new JnlpManipulator(url);
            if (APPS_SECURISEES.contains(manipulator.getAppTitle())) {
                manipulator.addApplicationDescArguments("-LRAppDockPort", String.valueOf(Dock.getInstance().getHttpServer().getListeningPort()));
            } else {
                manipulator.addApplicationDescArguments("-LRAppDockPort", Constants.SERVER_PORT);
            }
            manipulator.addApplicationDescArguments("-LRAppDockTicket", ticket.toString());
            manipulator.addApplicationDescArguments("-LRAppDockAppUUID", application.getId().toString());
            StringWriter sw = new StringWriter();
            File tempFile = new File(temp);
            try (FileOutputStream data = new FileOutputStream(tempFile);){
                manipulator.createJnlpDocumentForZap(data);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2.getMessage(), e2);
            }
            catch (TransformerException e3) {
                throw new RuntimeException(e3.getMessage(), e3);
            }
        }
        catch (IOException | RuntimeException | ParserConfigurationException | XPathExpressionException | SAXException e4) {
            JOptionPane.showMessageDialog(null, Messages.getString("error.unableToLaunchApp2") + e4.getMessage(), Messages.getString("error"), 0);
            LOGGER.error(e4.getMessage(), e4);
        }
        return temp;
    }

    private static String computeJnlpExtension() {
        return Boolean.valueOf(Constants.getInstance().valueForKey("USE_JNLPX")) != false ? ".jnlpx" : ".jnlp";
    }

    private static String getJnlpContent(String url) throws IOException {
        String line;
        InputStream is = null;
        String s2 = "";
        is = new URL(url).openStream();
        BufferedReader d2 = new BufferedReader(new InputStreamReader(is));
        while ((line = d2.readLine()) != null) {
            s2 = s2.concat(line);
        }
        is.close();
        return s2;
    }

    public static String getHostName() {
        InetAddress addr_local = null;
        try {
            addr_local = InetAddress.getLocalHost();
            LOGGER.trace("Adresse locale : " + addr_local);
            LOGGER.trace("Hostname : " + addr_local.getHostName());
            LOGGER.trace("CanonicalHostname : " + addr_local.getCanonicalHostName());
            return addr_local.getCanonicalHostName();
        }
        catch (UnknownHostException e2) {
            LOGGER.trace("pas d'adresse trouvee");
            return null;
        }
    }
}

