/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.cocktail.trv.zap.misc.Utils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.SAXException;

public class JnlpManipulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JnlpManipulator.class);
    final Map<String, String> applicationDescArguments = new HashMap<String, String>();
    private final org.w3c.dom.Document document;
    private final TreeWalker walker;
    private final String appTitle;
    NamedNodeMap jnlpAttributes;
    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    DocumentBuilder builder = this.factory.newDocumentBuilder();
    String jnlpString;

    public JnlpManipulator(String url) throws ParserConfigurationException, SAXException, IOException, DOMException, XPathExpressionException {
        this.jnlpString = Utils.getAsString(new URL(url));
        this.document = this.builder.parse(url);
        DocumentTraversal traversal = (DocumentTraversal)((Object)this.document);
        this.walker = traversal.createTreeWalker(this.document.getDocumentElement(), -1, null, true);
        this.walker.getRoot();
        Node jnlp = this.document.getElementsByTagName("jnlp").item(0);
        this.jnlpAttributes = jnlp.getAttributes();
        XPath xPath = XPathFactory.newInstance().newXPath();
        this.appTitle = ((NodeList)xPath.compile("/jnlp/information/title").evaluate(this.document, XPathConstants.NODESET)).item(0).getTextContent();
    }

    public static String prettyPrintByDom4j(String xmlString, int indent, boolean skipDeclaration) {
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setIndentSize(indent);
            format.setSuppressDeclaration(skipDeclaration);
            format.setEncoding("UTF-8");
            Document document = DocumentHelper.parseText(xmlString);
            StringWriter sw = new StringWriter();
            XMLWriter writer = new XMLWriter(sw, format);
            writer.write(document);
            return sw.toString();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2.getMessage(), e2);
        }
    }

    public String getAppTitle() {
        return this.appTitle;
    }

    public void addApplicationDescArguments(String key, String value) {
        this.applicationDescArguments.put(key, value);
    }

    public void createJnlpDocumentForZap(OutputStream os) throws IOException, XPathExpressionException, TransformerException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        org.w3c.dom.Document clonedDoc = this.builder.newDocument();
        clonedDoc.appendChild(clonedDoc.importNode(this.document.getDocumentElement(), true));
        Node applicationDescNode = ((NodeList)xPath.compile("/jnlp/application-desc").evaluate(clonedDoc, XPathConstants.NODESET)).item(0);
        this.applicationDescArguments.entrySet().stream().forEach(entry -> {
            try {
                Node argNode = ((NodeList)xPath.compile("/jnlp/application-desc/argument[text()='" + (String)entry.getKey() + "']").evaluate(clonedDoc, XPathConstants.NODESET)).item(0);
                NodeList siblings = (NodeList)xPath.evaluate("following-sibling::*", argNode, XPathConstants.NODESET);
                Node argNodeValue = siblings.item(0);
                if (argNodeValue != null) {
                    argNodeValue.getFirstChild().setTextContent((String)entry.getValue());
                }
            }
            catch (XPathExpressionException e2) {
                e2.printStackTrace();
            }
        });
        StringBuilder sb = new StringBuilder(this.jnlpString);
        int debut = this.jnlpString.indexOf("<application-desc");
        int fin = this.jnlpString.indexOf("</application-desc>") + "</application-desc>".length();
        sb.replace(debut, fin, this.transformedApplicationDescArguments(applicationDescNode));
        String newJnlpString = sb.toString();
        LOGGER.debug("JNLP output: " + newJnlpString);
        os.write(newJnlpString.getBytes(Charset.forName("UTF-8")));
    }

    public NamedNodeMap getJnlpAttributes() {
        return this.jnlpAttributes;
    }

    public Map<String, String> getApplicationDescArguments() {
        return this.applicationDescArguments;
    }

    private String transformedApplicationDescArguments(Node applicationDescNode) throws TransformerException {
        return JnlpManipulator.nodeListToString(applicationDescNode);
    }

    private static String nodeListToString(Node node) throws TransformerException {
        DOMSource source = new DOMSource();
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        source.setNode(node);
        transformer.transform(source, result);
        return writer.toString();
    }
}

