/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap.Gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.cocktail.trv.zap.Constants;
import org.cocktail.trv.zap.Dock;
import org.cocktail.trv.zap.Gui.Mouse;
import org.cocktail.trv.zap.Gui.Settings;
import org.cocktail.trv.zap.Messages;
import org.cocktail.trv.zap.contrib.StringCtrl;
import org.cocktail.trv.zap.contrib.SystemCtrl;
import org.cocktail.trv.zap.json.Application;
import org.cocktail.trv.zap.json.Theme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainWin {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainWin.class);
    private JFrame frame = new JFrame();

    public MainWin() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (StringCtrl.containsIgnoreCase(SystemCtrl.osName(), "windows")) {
            Settings.createDefault();
            this.configureUI();
        }
    }

    protected static ImageIcon readImageIcon(String filename) {
        URL url = MainWin.class.getClassLoader().getResource("org/cocktail/trv/zap/Gui/" + filename);
        return new ImageIcon(url);
    }

    private void configureUI() {
        JRadioButton radio = new JRadioButton();
        radio.getUI().uninstallUI(radio);
        JCheckBox checkBox = new JCheckBox();
        checkBox.getUI().uninstallUI(checkBox);
    }

    public void buildInterface(List<Theme> menus, List<Application> buttons) {
        this.frame.setIconImage(MainWin.readImageIcon("icone_zap.png").getImage());
        this.frame.setVisible(false);
        this.frame.validate();
        this.frame.setDefaultCloseOperation(3);
        this.frame.setResizable(false);
        this.frame.setSize(600, 120);
        this.frame.setTitle(Messages.getString("MainWin.title") + Constants.getInstance().valueForKey("VERSION"));
        this.frame.setContentPane(this.buildButtonBar(buttons));
        this.frame.setJMenuBar(this.buildMenuBar(menus));
        this.frame.setVisible(true);
    }

    protected JMenuBar buildMenuBar(List<Theme> applis) {
        JMenuBar menuBar = new JMenuBar();
        JMenu theme = new JMenu(Constants.getInstance().valueForKey("MENU_TITLE"));
        theme.setFont(theme.getFont().deriveFont(1));
        theme.setMnemonic('T');
        for (int i2 = 0; i2 < applis.size(); ++i2) {
            theme.add(this.buildMenuApplication(applis.get(i2).getName(), applis.get(i2).getApplications()));
        }
        menuBar.add(theme);
        Vector<String> affichageItems = new Vector<String>();
        affichageItems.add(Messages.getString("MainWin.refreshAppList"));
        JMenu affichage = this.buildMenu(Messages.getString("MainWin.display"), affichageItems);
        affichage.setMnemonic('A');
        menuBar.add(affichage);
        Vector<String> outilsItems = new Vector<String>();
        outilsItems.add(Messages.getString("MainWin.reinitConfig"));
        outilsItems.add(Messages.getString("MainWin.prefs"));
        JMenu outils = this.buildMenu(Messages.getString("MainWin.tools"), outilsItems);
        outils.setMnemonic('u');
        menuBar.add(outils);
        menuBar.add(Box.createHorizontalGlue());
        JMenu quitter = new JMenu(Messages.getString("MainWin.exit"));
        quitter.setMnemonic('Q');
        quitter.addMouseListener(new Mouse("menu/Quitter"));
        menuBar.add((Component)quitter);
        return menuBar;
    }

    protected JMenu buildMenuApplication(String title, List<Application> items) {
        JMenu menu = new JMenu(title);
        LOGGER.trace(title);
        if (items != null) {
            for (int i2 = 0; i2 < items.size(); ++i2) {
                String itemTitle = items.get(i2).getName();
                if (itemTitle == null) continue;
                LOGGER.trace(itemTitle);
                if (itemTitle.equals("separateur")) {
                    menu.addSeparator();
                    continue;
                }
                menu.add(this.buildItem(itemTitle, "menu/Application/" + title + "/" + itemTitle, Dock.getInstance().getLister().getAppliByName(itemTitle).getIconUrl()));
            }
        }
        return menu;
    }

    protected JMenu buildMenu(String title, Vector items) {
        JMenu menu = new JMenu(title);
        if (items != null) {
            for (int i2 = 0; i2 < items.size(); ++i2) {
                String itemTitle = (String)items.elementAt(i2);
                if (itemTitle == null) continue;
                if (itemTitle.equals("separateur")) {
                    menu.addSeparator();
                    continue;
                }
                menu.add(this.buildItem(itemTitle, "menu/" + title + "/" + itemTitle, null));
            }
        }
        return menu;
    }

    protected JMenuItem buildItem(String title, String action, String iconURL) {
        JMenuItem item = new JMenuItem(title);
        item.addMouseListener(new Mouse(action));
        try {
            if (iconURL != null) {
                Image image = new ImageIcon(new URL(iconURL)).getImage();
                item.setIcon(new ImageIcon(image.getScaledInstance(20, 20, 2)));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return item;
    }

    protected JScrollPane buildButtonBar(List<Application> buttons) {
        Object iconURL = null;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JToolBar tool = new JToolBar();
        tool.setBackground(Color.WHITE);
        tool.setFloatable(false);
        panel.setBackground(Color.WHITE);
        if (buttons.size() == 0) {
            JTextField label = new JTextField(Messages.getString("MainWin.helpBookmark"));
            label.setEditable(false);
            label.setBackground(Color.WHITE);
            panel.add(label);
        } else {
            tool.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            if (buttons != null) {
                for (int i2 = 0; i2 < buttons.size(); ++i2) {
                    Application appli = buttons.get(i2);
                    tool.add(this.buildButton(appli.getShortName(), "button/launch/" + appli.getName(), appli.getIconUrl()));
                    tool.addSeparator();
                }
            }
            panel.add(tool);
        }
        JScrollPane scrollable = new JScrollPane(panel);
        return scrollable;
    }

    protected JButton buildButton(String title, String action, String iconURL) {
        JButton button = new JButton();
        button.setActionCommand(action);
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        button.setText(title);
        button.addMouseListener(new Mouse(action));
        button.setMaximumSize(new Dimension(100, 60));
        try {
            Image image = new ImageIcon(new URL(iconURL)).getImage();
            button.setIcon(new ImageIcon(image.getScaledInstance(20, 20, 2)));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return button;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setFrame(JFrame frame) {
        this.frame = frame;
    }
}

