/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap.Gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.cocktail.trv.zap.Dock;
import org.cocktail.trv.zap.Gui.Favoris;
import org.cocktail.trv.zap.Messages;
import org.cocktail.trv.zap.json.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppliTunningWin
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppliTunningWin.class);
    private final JDialog dialog;
    private final Application appli;
    private final Dock dock = Dock.getInstance();
    private final String applicationName;
    private JLabel labelName;
    private JTextField textFieldName;
    private JLabel labelUrl;
    private JTextField textFieldUrl;
    private JLabel labelIconUrl;
    private JTextField textFieldIconUrl;
    private JButton buttonOK;
    private JButton buttonCancel;

    public AppliTunningWin(String applicationName) {
        this.applicationName = applicationName;
        this.appli = this.dock.getLister().getAppliByName(applicationName);
        this.dialog = new JDialog();
        this.dialog.setTitle(Messages.getString("AppliTunningWin.title") + applicationName);
        this.dialog.setSize(450, 150);
        this.dialog.setResizable(false);
        JPanel p1 = new JPanel(new GridLayout(4, 2, 5, 5));
        if (this.appli == null) {
            JOptionPane.showMessageDialog(this.dialog, Messages.getString("AppliTunningWin.unableToTuneApp"), Messages.getString("error"), 0);
            return;
        }
        this.labelName = new JLabel(Messages.getString("AppliTunningWin.labelName"), 11);
        this.textFieldName = new JTextField(this.appli.getShortName());
        p1.add(this.labelName);
        this.labelName.setLabelFor(this.textFieldName);
        p1.add(this.textFieldName);
        this.labelUrl = new JLabel(Messages.getString("AppliTunningWin.labelUrl"), 11);
        this.textFieldUrl = new JTextField(this.appli.getUrl());
        p1.add(this.labelUrl);
        this.labelUrl.setLabelFor(this.textFieldUrl);
        p1.add(this.textFieldUrl);
        this.labelIconUrl = new JLabel(Messages.getString("AppliTunningWin.labelIconUrl"), 11);
        this.textFieldIconUrl = this.appli.getIconUrl() != null ? new JTextField(this.appli.getIconUrl()) : new JTextField();
        p1.add(this.labelIconUrl);
        this.labelIconUrl.setLabelFor(this.textFieldIconUrl);
        p1.add(this.textFieldIconUrl);
        this.buttonOK = new JButton(Messages.getString("validate"));
        this.buttonOK.setActionCommand("ok");
        this.buttonOK.addActionListener(this);
        p1.add(this.buttonOK);
        this.buttonCancel = new JButton(Messages.getString("cancel"));
        this.buttonCancel.addActionListener(this);
        this.buttonCancel.setActionCommand("cancel");
        p1.add(this.buttonCancel);
        JPanel p2 = new JPanel(new BorderLayout(0, 10));
        p2.add((Component)p1, "Center");
        p2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.dialog.setContentPane(p2);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = this.dialog.getSize();
        this.dialog.setLocation((screen.width - window.width) / 2, (screen.height - window.height) / 2);
        this.dialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getActionCommand().equalsIgnoreCase("ok")) {
            String shortName = this.textFieldName.getText();
            String url = this.textFieldUrl.getText();
            if (shortName.compareTo("") == 0 || url.compareTo("") == 0) {
                JOptionPane.showMessageDialog(null, Messages.getString("AppliTunningWin.nameAndUrlMandatory"), Messages.getString("error"), 0);
            } else {
                Optional<Application> fav = this.dock.getLister().getFavoriByName(this.applicationName);
                if (fav.isPresent()) {
                    try {
                        Favoris.getInstance().remove(fav.get());
                    }
                    catch (IOException e1) {
                        LOGGER.error(e1.getMessage(), e1);
                    }
                    Dock.getInstance().repaint();
                }
            }
        }
        this.dialog.setVisible(false);
    }
}

