/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap.CAS;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Scanner;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPSClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTPSClient.class);
    final BasicCookieStore cookieStore = new BasicCookieStore();
    private final CloseableHttpClient client;
    private ClassicRequestBuilder getMethod;
    private ClassicRequestBuilder postMethod;
    public static final String USER_AGENT = HTTPSClient.userAgent();

    public HTTPSClient(URL keystoreURL, String keystorePasswd) throws IOException {
        if (keystoreURL == null) {
            throw new IOException("Impossible de charger le keystore");
        }
        this.client = HttpClients.custom().disableRedirectHandling().disableContentCompression().disableAuthCaching().disableAutomaticRetries().disableConnectionState().setDefaultCookieStore(this.cookieStore).setUserAgent(USER_AGENT).build();
    }

    private static String userAgent() {
        return "Cocktail Zap - " + VersionInfo.getSoftwareInfo("Apache-HttpClient", "org.apache.hc.client5", HTTPSClient.class.getClassLoader().getClass());
    }

    static String convertStreamToString(InputStream is) {
        Scanner s2 = new Scanner(is).useDelimiter("\\A");
        return s2.hasNext() ? s2.next() : "";
    }

    public void getMethod(String url) {
        try {
            this.getMethod = ClassicRequestBuilder.get().setUri(new URI(url));
        }
        catch (URISyntaxException e2) {
            LOGGER.error(e2.getMessage(), e2);
        }
    }

    public void postMethod(String url) {
        try {
            this.postMethod = ClassicRequestBuilder.post().setUri(new URI(url)).setCharset(StandardCharsets.UTF_8);
        }
        catch (URISyntaxException e2) {
            LOGGER.error(e2.getMessage(), e2);
        }
    }

    public void addParametersPost(String key, String value) {
        this.postMethod.addParameter(key, value);
    }

    public void addCookie(Cookie cookie) {
        this.cookieStore.addCookie(cookie);
    }

    public List<Cookie> getCookies() {
        return this.cookieStore.getCookies();
    }

    public CloseableHttpResponse executeGetMethod() throws IOException {
        return this.client.execute(this.getMethod.build());
    }

    public CloseableHttpResponse executePostMethod() throws IOException {
        return this.client.execute(this.postMethod.build());
    }
}

