/*
 * Decompiled with CFR 0.152.
 */
package org.cocktail.trv.zap.CAS;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.ProtocolException;
import org.cocktail.trv.zap.CAS.HTTPSClient;
import org.cocktail.trv.zap.Constants;
import org.cocktail.trv.zap.Ressources.Ressources;
import org.cocktail.trv.zap.contrib.StringCtrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationCAS {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationCAS.class);
    private static AuthenticationCAS auth;
    private static String CAS_LOGIN_URL;
    private static String CAS_VALIDATE_URL;
    private static String CAS_SERVICE_URI;
    private static String CAS_TGC_NAME;
    private final String EREG_SERVICE_TICKET = "window\\.location\\.href=\".*\\?ticket=([\\w-]+)\"";
    private Cookie ticketGrantingCookie;
    private Cookie jSessionId;
    private String serviceTicket;
    private String ticket;

    private AuthenticationCAS() {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
        System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire.header", "debug");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "debug");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.impl.conn", "debug");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.impl.client", "debug");
    }

    public static AuthenticationCAS getInstance(HashMap confTable) throws IOException {
        AuthenticationCAS.loadConf(confTable);
        if (auth == null) {
            auth = new AuthenticationCAS();
        }
        return auth;
    }

    private static void loadConf(HashMap conf) throws IOException {
        if (conf != null) {
            String CAS_SERVICE_URL = (String)conf.get("CAS_SERVICE_URL");
            if (CAS_SERVICE_URL == null) {
                throw new IOException("Le parametre de configuration CAS_SERVICE_URL est indefini.");
            }
            CAS_LOGIN_URL = (String)conf.get("CAS_LOGIN_URL");
            if (CAS_LOGIN_URL == null) {
                CAS_LOGIN_URL = CAS_SERVICE_URL + "/login";
            }
            if ((CAS_VALIDATE_URL = (String)conf.get("CAS_VALIDATE_URL")) == null) {
                CAS_VALIDATE_URL = CAS_SERVICE_URL + "/serviceValidate";
            }
            if (StringCtrl.isEmpty(CAS_SERVICE_URI = (String)conf.get("CAS_SERVICE_URI"))) {
                CAS_SERVICE_URI = "urn:applis-cri:java-sso";
            }
            if (StringCtrl.isEmpty(CAS_TGC_NAME = (String)conf.get("CAS_TGC_NAME"))) {
                CAS_TGC_NAME = "TGC";
            }
        }
    }

    private String appliquerExpReg(String ereg, String texte) {
        Pattern pattern = Pattern.compile(ereg, 40);
        Matcher matcher = pattern.matcher(texte);
        if (matcher.find()) {
            String match = matcher.group(1);
            LOGGER.trace("Got '" + match + "' as a result of '" + ereg + "' pattern.");
            return match;
        }
        return null;
    }

    public String getNetId() throws IOException, ProtocolException {
        return this.getNetId(null, null);
    }

    public String getNetId(String login, String passwd) throws IOException, ProtocolException {
        HTTPSClient https = this.initHttpsClient();
        https.getMethod(CAS_LOGIN_URL + "?service=" + CAS_SERVICE_URI);
        if (this.ticketGrantingCookie != null) {
            LOGGER.trace("Adding cookie to request:" + this.ticketGrantingCookie);
            https.addCookie(this.ticketGrantingCookie);
        }
        LOGGER.trace("Connexion1 :" + CAS_LOGIN_URL + "?service=" + CAS_SERVICE_URI);
        CloseableHttpResponse resp = https.executeGetMethod();
        if (resp != null) {
            String contents = HTTPSClient.convertStreamToString(resp.getEntity().getContent());
            if (https.getCookies().size() != 0) {
                this.jSessionId = https.getCookies().get(0);
                LOGGER.trace("get cookie : " + this.jSessionId.getName());
            } else {
                this.jSessionId = null;
                LOGGER.trace("get cookie : no Cookie");
            }
            resp.close();
            String EREG_LOGIN_TICKET = "name=\"lt\" value=\"([\\w-\\.]+)\"";
            String loginTicket = this.appliquerExpReg(EREG_LOGIN_TICKET, contents);
            LOGGER.trace("login ticket=" + loginTicket);
            String EREG_EXECUTION_TOKEN = "name=\"execution\" value=\"([\\w-=/+]+)\"";
            String executionToken = this.appliquerExpReg(EREG_EXECUTION_TOKEN, contents);
            LOGGER.trace("execution token=" + executionToken);
            if (loginTicket != null || executionToken != null) {
                this.soumettreFormulaireIdentification(loginTicket, executionToken, login, passwd);
            } else {
                this.serviceTicket = this.appliquerExpReg("window\\.location\\.href=\".*\\?ticket=([\\w-]+)\"", contents);
            }
            if (this.ticketGrantingCookie != null) {
                return this.validerService();
            }
        }
        return null;
    }

    private HTTPSClient initHttpsClient() throws IOException {
        ClassLoader cl = Ressources.class.getClassLoader();
        URL keystoreURL = cl.getResource(Constants.getInstance().valueForKey("KEYSTORE"));
        if (keystoreURL == null) {
            throw new IOException("Impossible de charger le keystore");
        }
        return new HTTPSClient(keystoreURL, Constants.getInstance().valueForKey("KEYSTORE_PASSWD"));
    }

    private void soumettreFormulaireIdentification(String loginTicket, String executionToken, String login, String passwd) throws IOException, ProtocolException {
        LOGGER.trace("soumettreFormulaire(loginTicket = '" + loginTicket + "')");
        HTTPSClient https = this.initHttpsClient();
        https.postMethod(CAS_LOGIN_URL + "?service=" + CAS_SERVICE_URI + "&locale=fr");
        if (StringCtrl.normalize(login).length() != 0 && StringCtrl.normalize(passwd).length() != 0) {
            https.addParametersPost("username", login);
            https.addParametersPost("password", passwd);
            if (loginTicket != null) {
                https.addParametersPost("lt", loginTicket);
            }
            if (executionToken != null) {
                https.addParametersPost("execution", executionToken);
            }
            https.addParametersPost("_eventId", "submit");
            https.addParametersPost("submit", "SE CONNECTER");
            if (this.jSessionId != null) {
                https.addCookie(this.jSessionId);
            }
            this.ticket = loginTicket;
            LOGGER.trace("Connexion 2(login password)" + CAS_LOGIN_URL + "?service=" + CAS_SERVICE_URI);
            CloseableHttpResponse resp = https.executePostMethod();
            if (resp != null) {
                String contents = HTTPSClient.convertStreamToString(resp.getEntity().getContent());
                Header hLocation = resp.getHeader("Location");
                if (hLocation == null) {
                    hLocation = resp.getHeader("location");
                }
                LOGGER.trace("location = " + hLocation);
                boolean haveRedirect = false;
                boolean haveSt = false;
                if (hLocation != null) {
                    String lValue = hLocation.getValue();
                    if (this.appliquerExpReg("(" + CAS_SERVICE_URI + ")", lValue) != null) {
                        LOGGER.info("having redirect; getting service ticket");
                        String strSt = this.appliquerExpReg(".*?ticket=(ST.+)", lValue);
                        if (strSt != null && strSt.trim().length() > 0) {
                            this.serviceTicket = strSt;
                            haveRedirect = true;
                            haveSt = true;
                        }
                    }
                }
                resp.close();
                LOGGER.trace("retour2=" + contents);
                String EREG_SUCCESSFUL_AUTH = "(Authentification r&eacute;ussie)";
                if (!haveRedirect && this.appliquerExpReg(EREG_SUCCESSFUL_AUTH, contents) != null) {
                    this.serviceTicket = this.appliquerExpReg(this.EREG_SERVICE_TICKET, contents);
                    haveSt = true;
                }
                if (haveSt) {
                    LOGGER.trace("having service ticket " + this.serviceTicket);
                    List<Cookie> cookies = https.getCookies();
                    LOGGER.trace("cookies.length :" + cookies.size());
                    if (cookies.size() != 0) {
                        for (int i2 = 0; i2 < cookies.size(); ++i2) {
                            if (!cookies.get(i2).getName().startsWith(CAS_TGC_NAME)) continue;
                            this.ticketGrantingCookie = cookies.get(i2);
                            LOGGER.trace("mise \u00e0 jour du cookie: " + cookies.get(i2));
                        }
                    } else {
                        LOGGER.trace("cookie remis a null");
                        this.ticketGrantingCookie = null;
                    }
                }
            }
        }
    }

    private String validerService() throws IOException {
        LOGGER.trace("validerService()");
        HTTPSClient https = this.initHttpsClient();
        https.getMethod(CAS_VALIDATE_URL + "?service=" + CAS_SERVICE_URI + "&ticket=" + this.serviceTicket);
        CloseableHttpResponse resp = https.executeGetMethod();
        if (resp != null) {
            String contents = HTTPSClient.convertStreamToString(resp.getEntity().getContent());
            LOGGER.trace("retour3:" + contents);
            resp.close();
            String EREG_USERNAME = "<cas:authenticationSuccess>.*<cas:user>(.*)</cas:user>.*</cas:authenticationSuccess>";
            return this.appliquerExpReg(EREG_USERNAME, contents);
        }
        return null;
    }

    public void logout() {
        this.ticketGrantingCookie = null;
    }

    public Cookie getCookie() {
        LOGGER.trace("cookie:" + this.ticketGrantingCookie);
        return this.ticketGrantingCookie;
    }
}

