/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.BodySourceGenerator;
import org.burningwave.core.classes.GenericSourceGenerator;
import org.burningwave.core.classes.SourceGenerator;

public class TypeDeclarationSourceGenerator
extends SourceGenerator.Abst {
    private static final long serialVersionUID = -7814557670243517814L;
    private boolean isVarArgs;
    private boolean useFullyQualifiedName;
    private Boolean publicFlag;
    private String name;
    private String simpleName;
    private Collection<GenericSourceGenerator> generics;
    private BodySourceGenerator parameters;

    private TypeDeclarationSourceGenerator(String name, String simpleName) {
        this.name = name;
        this.simpleName = simpleName;
    }

    private TypeDeclarationSourceGenerator(Class<?> clazz) {
        if (!(clazz.isPrimitive() || clazz.isArray() && StaticComponentContainer.Classes.getComponentType(clazz).isPrimitive())) {
            this.name = clazz.getName();
        }
        this.publicFlag = Modifier.isPublic(clazz.getModifiers());
        this.simpleName = clazz.getSimpleName();
    }

    private TypeDeclarationSourceGenerator() {
    }

    public static TypeDeclarationSourceGenerator create(String name, String simpleName) {
        return new TypeDeclarationSourceGenerator(name, simpleName);
    }

    public static TypeDeclarationSourceGenerator create(String simpleName) {
        return new TypeDeclarationSourceGenerator(null, simpleName);
    }

    public static TypeDeclarationSourceGenerator create(Class<?> cls) {
        return new TypeDeclarationSourceGenerator(cls);
    }

    public static TypeDeclarationSourceGenerator create(GenericSourceGenerator ... generics) {
        return new TypeDeclarationSourceGenerator().addGeneric(generics);
    }

    public TypeDeclarationSourceGenerator setAsParameterizable(boolean flag) {
        if (flag) {
            if (this.parameters == null) {
                this.parameters = BodySourceGenerator.create().setDelimiters("(\n", "\n)").setElementPrefix("\t").setBodyElementSeparator(", ");
            }
        } else {
            this.parameters = null;
        }
        return this;
    }

    public TypeDeclarationSourceGenerator setAsVarArgs(boolean flag) {
        this.isVarArgs = flag;
        return this;
    }

    boolean isParameterizable() {
        return this.parameters != null;
    }

    public TypeDeclarationSourceGenerator addParameter(String ... parameters) {
        if (this.parameters == null) {
            this.setAsParameterizable(true);
        }
        this.parameters.addCode(String.join((CharSequence)", ", parameters));
        return this;
    }

    public TypeDeclarationSourceGenerator addParameter(SourceGenerator ... parameters) {
        if (this.parameters == null) {
            this.setAsParameterizable(true);
        }
        for (SourceGenerator parameter : parameters) {
            this.parameters.addElement(parameter);
        }
        return this;
    }

    public TypeDeclarationSourceGenerator setSimpleName(String simpleName) {
        this.simpleName = simpleName;
        return this;
    }

    public TypeDeclarationSourceGenerator useFullyQualifiedName(boolean flag) {
        this.useFullyQualifiedName = flag;
        return this;
    }

    String getName() {
        return this.name;
    }

    String getSimpleName() {
        return this.simpleName;
    }

    public TypeDeclarationSourceGenerator addGeneric(GenericSourceGenerator ... generics) {
        Optional.ofNullable(this.generics).orElseGet(() -> {
            this.generics = new ArrayList<GenericSourceGenerator>();
            return this.generics;
        });
        this.generics.addAll(Arrays.asList(generics));
        return this;
    }

    Collection<TypeDeclarationSourceGenerator> getTypeDeclarations() {
        ArrayList<TypeDeclarationSourceGenerator> types = new ArrayList<TypeDeclarationSourceGenerator>();
        types.add(this);
        Optional.ofNullable(this.generics).ifPresent(generics -> generics.forEach(generic -> types.addAll(generic.getTypeDeclarations())));
        Optional.ofNullable(this.parameters).ifPresent(parameters -> types.addAll(parameters.getTypeDeclarations()));
        return types;
    }

    Boolean isPublic() {
        return this.publicFlag;
    }

    boolean useFullyQualifiedName() {
        return this.useFullyQualifiedName;
    }

    private String getParametersCode() {
        if (this.parameters != null && this.parameters.isEmpty()) {
            this.parameters.setDelimiters("(", ")");
        }
        return Optional.ofNullable(this.parameters).map(BodySourceGenerator::make).orElseGet(() -> "");
    }

    boolean isArray() {
        return this.name != null && this.name.contains("[") || this.simpleName != null && this.simpleName.contains("[");
    }

    @Override
    public String make() {
        boolean usingFullyQualifiedName = this.useFullyQualifiedName && this.name != null;
        String name = "";
        String arraysDelimiters = "";
        if (usingFullyQualifiedName) {
            name = this.name;
        } else if (this.simpleName != null) {
            name = this.simpleName;
        }
        if (this.isArray()) {
            long dimension = name.chars().filter(ch -> ch == 91).count();
            for (long i2 = 0L; i2 < dimension; ++i2) {
                arraysDelimiters = arraysDelimiters + "[]";
            }
            name = name.replace("[L", "").replace("[", "").replace("]", "").replace(";", "");
        }
        return name + Optional.ofNullable(this.generics).map(generics -> "<" + this.getOrEmpty((Collection<?>)generics, ", ") + ">").orElseGet(() -> "") + this.getParametersCode() + arraysDelimiters + (this.isVarArgs ? "..." : "");
    }
}

