/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Predicate;
import org.burningwave.core.assembler.StaticComponentContainer;

public interface MembersRetriever {
    default public Field getDeclaredField(Class<?> cls, Predicate<Field> predicate) {
        Collection<Field> members = this.getDeclaredFields(cls, predicate);
        if (members.size() > 1) {
            StaticComponentContainer.Driver.throwException("More than one member found for class {}", cls.getName());
        }
        return members.stream().findFirst().orElse(null);
    }

    default public Method getDeclaredMethod(Class<?> cls, Predicate<Method> predicate) {
        Collection<Method> members = this.getDeclaredMethods(cls, predicate);
        if (members.size() > 1) {
            StaticComponentContainer.Driver.throwException("More than one member found for class {}", cls.getName());
        }
        return members.stream().findFirst().orElse(null);
    }

    default public <T> Constructor<T> getDeclaredConstructor(Class<T> cls, Predicate<Constructor<T>> predicate) {
        Collection<Constructor<T>> members = this.getDeclaredConstructors(cls, predicate);
        if (members.size() > 1) {
            StaticComponentContainer.Driver.throwException("More than one member found for class {}", cls.getName());
        }
        return members.stream().findFirst().orElse(null);
    }

    default public Collection<Field> getDeclaredFields(Class<?> cls, Predicate<Field> memberPredicate) {
        HashSet<Field> members = new HashSet<Field>();
        for (Field member : this.getDeclaredFields(cls)) {
            if (!memberPredicate.test(member)) continue;
            members.add(member);
        }
        return members;
    }

    default public <T> Collection<Constructor<T>> getDeclaredConstructors(Class<T> cls, Predicate<Constructor<T>> predicate) {
        HashSet<Constructor<T>> members = new HashSet<Constructor<T>>();
        for (Constructor<T> member : this.getDeclaredConstructors(cls)) {
            if (!predicate.test(member)) continue;
            members.add(member);
        }
        return members;
    }

    default public Collection<Method> getDeclaredMethods(Class<?> cls, Predicate<Method> memberPredicate) {
        HashSet<Method> members = new HashSet<Method>();
        for (Method member : this.getDeclaredMethods(cls)) {
            if (!memberPredicate.test(member)) continue;
            members.add(member);
        }
        return members;
    }

    public Field[] getDeclaredFields(Class<?> var1);

    public <T> Constructor<T>[] getDeclaredConstructors(Class<T> var1);

    public Method[] getDeclaredMethods(Class<?> var1);
}

