/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.io.EOFException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.EventDetails;
import org.apache.log4j.chainsaw.MyTableModel;
import org.apache.log4j.net.HardenedLoggingEventInputStream;
import org.apache.log4j.spi.LoggingEvent;

class LoggingReceiver
extends Thread {
    private static final Logger LOG = Logger.getLogger(LoggingReceiver.class);
    private MyTableModel mModel;
    private ServerSocket mSvrSock;

    LoggingReceiver(MyTableModel aModel, int aPort) throws IOException {
        this.setDaemon(true);
        this.mModel = aModel;
        this.mSvrSock = new ServerSocket(aPort);
    }

    public void run() {
        LOG.info("Thread started");
        try {
            while (true) {
                LOG.debug("Waiting for a connection");
                Socket client = this.mSvrSock.accept();
                LOG.debug("Got a connection from " + client.getInetAddress().getHostName());
                Thread t2 = new Thread(new Slurper(client));
                t2.setDaemon(true);
                t2.start();
            }
        }
        catch (IOException e2) {
            LOG.error("Error in accepting connections, stopping.", e2);
            return;
        }
    }

    private class Slurper
    implements Runnable {
        private final Socket mClient;

        Slurper(Socket aClient) {
            this.mClient = aClient;
        }

        public void run() {
            LOG.debug("Starting to get data");
            try {
                HardenedLoggingEventInputStream hleis = new HardenedLoggingEventInputStream(this.mClient.getInputStream());
                while (true) {
                    LoggingEvent event = (LoggingEvent)hleis.readObject();
                    LoggingReceiver.this.mModel.addEvent(new EventDetails(event));
                }
            }
            catch (EOFException e2) {
                LOG.info("Reached EOF, closing connection");
            }
            catch (SocketException e3) {
                LOG.info("Caught SocketException, closing connection");
            }
            catch (IOException e4) {
                LOG.warn("Got IOException, closing connection", e4);
            }
            catch (ClassNotFoundException e5) {
                LOG.warn("Got ClassNotFoundException, closing connection", e5);
            }
            try {
                this.mClient.close();
            }
            catch (IOException e6) {
                LOG.warn("Error closing connection", e6);
            }
        }
    }
}

