/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.hpack;

import java.nio.ByteBuffer;
import org.apache.hc.core5.util.ByteArrayBuffer;

final class HuffmanEncoder {
    private final int[] codes;
    private final byte[] lengths;

    HuffmanEncoder(int[] codes, byte[] lengths) {
        this.codes = codes;
        this.lengths = lengths;
    }

    void encode(ByteArrayBuffer out, ByteBuffer src) {
        long current = 0L;
        int n2 = 0;
        while (src.hasRemaining()) {
            int b2 = src.get() & 0xFF;
            int code = this.codes[b2];
            byte nbits = this.lengths[b2];
            current <<= nbits;
            current |= (long)code;
            n2 += nbits;
            while (n2 >= 8) {
                out.append((int)(current >> (n2 -= 8)));
            }
        }
        if (n2 > 0) {
            current <<= 8 - n2;
            out.append((int)(current |= (long)(255 >>> n2)));
        }
    }

    void encode(ByteArrayBuffer out, CharSequence src, int off, int len) {
        long current = 0L;
        int n2 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            int b2 = src.charAt(off + i2) & 0xFF;
            int code = this.codes[b2];
            byte nbits = this.lengths[b2];
            current <<= nbits;
            current |= (long)code;
            n2 += nbits;
            while (n2 >= 8) {
                out.append((int)(current >> (n2 -= 8)));
            }
        }
        if (n2 > 0) {
            current <<= 8 - n2;
            out.append((int)(current |= (long)(255 >>> n2)));
        }
    }
}

