/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import java.nio.ByteBuffer;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;

@Internal
public class Wire {
    private static final int MAX_STRING_BUILDER_SIZE = 2048;
    private static final ThreadLocal<StringBuilder> THREAD_LOCAL = new ThreadLocal();
    private final Logger log;
    private final String id;

    private static StringBuilder getStringBuilder() {
        StringBuilder result = THREAD_LOCAL.get();
        if (result == null) {
            result = new StringBuilder(2048);
            THREAD_LOCAL.set(result);
        }
        Wire.trimToMaxSize(result, 2048);
        result.setLength(0);
        return result;
    }

    private static void trimToMaxSize(StringBuilder stringBuilder, int maxSize) {
        if (stringBuilder != null && stringBuilder.capacity() > maxSize) {
            stringBuilder.setLength(maxSize);
            stringBuilder.trimToSize();
        }
    }

    public Wire(Logger log, String id) {
        this.log = log;
        this.id = id;
    }

    private void wire(String header, byte[] b2, int pos, int off) {
        StringBuilder buffer = Wire.getStringBuilder();
        for (int i2 = 0; i2 < off; ++i2) {
            byte ch = b2[pos + i2];
            if (ch == 13) {
                buffer.append("[\\r]");
                continue;
            }
            if (ch == 10) {
                buffer.append("[\\n]\"");
                buffer.insert(0, "\"");
                buffer.insert(0, header);
                this.log.debug("{} {}", (Object)this.id, (Object)buffer);
                buffer.setLength(0);
                continue;
            }
            if (ch < 32 || ch >= 127) {
                buffer.append("[0x");
                buffer.append(Integer.toHexString(ch));
                buffer.append("]");
                continue;
            }
            buffer.append((char)ch);
        }
        if (buffer.length() > 0) {
            buffer.append('\"');
            buffer.insert(0, '\"');
            buffer.insert(0, header);
            this.log.debug("{} {}", (Object)this.id, (Object)buffer);
        }
    }

    public boolean isEnabled() {
        return this.log.isDebugEnabled();
    }

    public void output(byte[] b2, int pos, int off) {
        Args.notNull(b2, "Output");
        this.wire(">> ", b2, pos, off);
    }

    public void input(byte[] b2, int pos, int off) {
        Args.notNull(b2, "Input");
        this.wire("<< ", b2, pos, off);
    }

    public void output(byte[] b2) {
        Args.notNull(b2, "Output");
        this.output(b2, 0, b2.length);
    }

    public void input(byte[] b2) {
        Args.notNull(b2, "Input");
        this.input(b2, 0, b2.length);
    }

    public void output(int b2) {
        this.output(new byte[]{(byte)b2});
    }

    public void input(int b2) {
        this.input(new byte[]{(byte)b2});
    }

    public void output(String s2) {
        Args.notNull(s2, "Output");
        this.output(s2.getBytes());
    }

    public void input(String s2) {
        Args.notNull(s2, "Input");
        this.input(s2.getBytes());
    }

    public void output(ByteBuffer b2) {
        Args.notNull(b2, "Output");
        if (b2.hasArray()) {
            this.output(b2.array(), b2.arrayOffset() + b2.position(), b2.remaining());
        } else {
            byte[] tmp = new byte[b2.remaining()];
            b2.get(tmp);
            this.output(tmp);
        }
    }

    public void input(ByteBuffer b2) {
        Args.notNull(b2, "Input");
        if (b2.hasArray()) {
            this.input(b2.array(), b2.arrayOffset() + b2.position(), b2.remaining());
        } else {
            byte[] tmp = new byte[b2.remaining()];
            b2.get(tmp);
            this.input(tmp);
        }
    }
}

