/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.PrintableString;
import iaik.asn1.UTF8String;
import iaik.asn1.structures.AVA;
import iaik.asn1.structures.Name;
import iaik.asn1.structures.RDN;
import iaik.utils.InternalErrorException;
import iaik.utils.RFC2253NameParserException;
import iaik.utils.a;
import iaik.utils.b;
import iaik.utils.c;
import iaik.utils.d;
import java.util.Hashtable;

public class RFC2253NameParser {
    protected StringBuffer nameStrBuf_;
    protected int position_ = 0;
    protected c name_ = new c(this);
    protected static Hashtable associations_ = new Hashtable();
    private static final char o = '#';
    private static final char p = '\\';
    private static final char g = '.';
    private static final char h = '-';
    private static final char k = '=';
    private static final char d = ';';
    private static final char n = ',';
    private static final char f = '+';
    private static final char c = ' ';
    private static final char e = '\"';
    private static final String i = "0123456789ABCDEFabcdef";
    private static final String l = "0123456789";
    private static final String q = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String j = "# ,+\"\\<>;";
    private static final String b = "<>\"";
    private static final String a = ",;+";
    private static final boolean m = false;

    protected void skipSpace() {
        while (this.position_ < this.nameStrBuf_.length() && this.nameStrBuf_.charAt(this.position_) == ' ') {
            ++this.position_;
        }
    }

    protected void skipOIDIntro() {
        if (this.nameStrBuf_.length() - this.position_ < 4) {
            return;
        }
        String string = this.nameStrBuf_.toString().substring(this.position_, this.position_ + 4);
        if (string.equalsIgnoreCase("oid.")) {
            this.position_ += 4;
        }
    }

    public static void register(String string, ObjectID objectID) {
        associations_.put(string, objectID);
    }

    protected b parseRDN() throws RFC2253NameParserException {
        b b2 = new b(this);
        boolean bl = false;
        do {
            b2.aVAs_.addElement(this.parseAVA());
            this.skipSpace();
            if (this.position_ < this.nameStrBuf_.length() && this.nameStrBuf_.charAt(this.position_) == '+') {
                ++this.position_;
                this.skipSpace();
                if (this.position_ == this.nameStrBuf_.length()) {
                    Object[] objectArray = new Object[]{new Integer(this.position_)};
                    throw new RFC2253NameParserException("Cannot find another AVA after having parsed a plus (position {0,number,integer}).", objectArray);
                }
                bl = true;
                continue;
            }
            bl = false;
        } while (bl);
        return b2;
    }

    protected char parseHexPairEscapeSequence() throws RFC2253NameParserException {
        char c2 = this.parseHexPair();
        if ((c2 & 0x80) == 0) {
            return c2;
        }
        if ((c2 & 0xC0) == 192) {
            ++this.position_;
            char c3 = this.parseHexPair();
            int n2 = (c2 & 0x1F) << 6;
            return (char)(n2 += c3 & 0x3F);
        }
        ++this.position_;
        char c4 = this.parseHexPair();
        ++this.position_;
        char c5 = this.parseHexPair();
        int n3 = c2 & 0xF000;
        n3 += (c4 & 0x3F) << 6;
        return (char)(n3 += c5 & 0x3F);
    }

    protected char parseHexPair() throws RFC2253NameParserException {
        if (this.nameStrBuf_.length() - this.position_ < 2) {
            Object[] objectArray = new Object[]{new Integer(this.position_)};
            throw new RFC2253NameParserException("Cannot parse hex pair (position {0,number,integer}).", objectArray);
        }
        if (i.indexOf(this.nameStrBuf_.charAt(this.position_)) == -1 || i.indexOf(this.nameStrBuf_.charAt(this.position_ + 1)) == -1) {
            Object[] objectArray = new Object[]{new Integer(this.position_)};
            throw new RFC2253NameParserException("Invalid hex pair character found when parsing a hex pair (position {0,number,integer}).", objectArray);
        }
        char c2 = (char)Integer.parseInt(this.nameStrBuf_.toString().substring(this.position_, this.position_ + 2), 16);
        this.position_ += 2;
        return c2;
    }

    /*
     * Unable to fully structure code
     */
    protected d parseAttrValue() throws RFC2253NameParserException {
        block19: {
            block18: {
                var1_1 = new StringBuffer();
                var2_2 = new d(this);
                if (this.position_ == this.nameStrBuf_.length()) {
                    var2_2.value_ = var1_1.toString();
                    return var2_2;
                }
                var3_3 = this.nameStrBuf_.charAt(this.position_) == '\"';
                v0 = var4_4 = this.nameStrBuf_.charAt(this.position_) == '#';
                if (!var3_3) break block18;
                ++this.position_;
                if (this.position_ != this.nameStrBuf_.length()) ** GOTO lbl32
                var5_5 = new Object[]{new Integer(this.position_)};
                throw new RFC2253NameParserException("Cannot find closing quote for attribute value ((position {0,number,integer}).", var5_5);
lbl-1000:
                // 1 sources

                {
                    if (this.nameStrBuf_.charAt(this.position_) == '\\') {
                        ++this.position_;
                        if (this.position_ == this.nameStrBuf_.length()) {
                            var5_6 = new Object[]{new Integer(this.position_)};
                            throw new RFC2253NameParserException("Cannot find escape character after having parsed a backslash (position {0,number,integer}).", var5_6);
                        }
                        if (this.nameStrBuf_.charAt(this.position_) == '\\' || this.nameStrBuf_.charAt(this.position_) == '\"') {
                            var1_1.append(this.nameStrBuf_.charAt(this.position_));
                            ++this.position_;
                        } else {
                            var1_1.append(this.parseHexPairEscapeSequence());
                        }
                    } else {
                        var1_1.append(this.nameStrBuf_.charAt(this.position_));
                        ++this.position_;
                    }
                    if (this.position_ != this.nameStrBuf_.length()) continue;
                    var5_7 = new Object[]{new Integer(this.position_)};
                    throw new RFC2253NameParserException("Cannot find closing quote for attribute value ((position {0,number,integer}).", var5_7);
lbl32:
                    // 2 sources

                    ** while (this.nameStrBuf_.charAt((int)this.position_) != '\"')
                }
lbl33:
                // 1 sources

                ++this.position_;
                break block19;
            }
            if (!var4_4) ** GOTO lbl78
            var2_2.hasHexValue_ = true;
            ++this.position_;
            var1_1.append(this.parseHexPair());
            while (this.position_ != this.nameStrBuf_.length() && "0123456789ABCDEFabcdef".indexOf(this.nameStrBuf_.charAt(this.position_)) != -1) {
                var1_1.append(this.parseHexPair());
            }
            break block19;
lbl-1000:
            // 1 sources

            {
                if ("<>\"".indexOf(this.nameStrBuf_.charAt(this.position_)) != -1) {
                    var5_9 = new Object[]{new Integer(this.position_)};
                    throw new RFC2253NameParserException("Invalid character (<>\") found in attribute value (position {0,number,integer}).", var5_9);
                }
                if (this.nameStrBuf_.charAt(this.position_) == ' ') {
                    if (this.position_ + 1 == this.nameStrBuf_.length() || ",;+".indexOf(this.nameStrBuf_.charAt(this.position_ + 1)) != -1) {
                        var5_8 = this.position_;
                        while (this.nameStrBuf_.charAt(var5_8 - 1) == ' ') {
                            --var5_8;
                        }
                        var1_1.setLength(var1_1.length() - this.position_ + var5_8);
                        ++this.position_;
                        continue;
                    }
                    var1_1.append(this.nameStrBuf_.charAt(this.position_));
                    ++this.position_;
                    continue;
                }
                if (this.nameStrBuf_.charAt(this.position_) == '\\') {
                    ++this.position_;
                    if (this.position_ == this.nameStrBuf_.length()) {
                        var5_10 = new Object[]{new Integer(this.position_)};
                        throw new RFC2253NameParserException("Cannot find escape character after having parsed a backslash (position {0,number,integer}).", var5_10);
                    }
                    if ("# ,+\"\\<>;".indexOf(this.nameStrBuf_.charAt(this.position_)) != -1) {
                        var1_1.append(this.nameStrBuf_.charAt(this.position_));
                        ++this.position_;
                        continue;
                    }
                    var1_1.append(this.parseHexPairEscapeSequence());
                    continue;
                }
                var1_1.append(this.nameStrBuf_.charAt(this.position_));
                ++this.position_;
lbl78:
                // 6 sources

                ** while (this.position_ != this.nameStrBuf_.length() && ",;+".indexOf((int)this.nameStrBuf_.charAt((int)this.position_)) == -1)
            }
        }
        try {
            var2_2.value_ = var1_1.toString();
            return var2_2;
        }
        catch (Exception var5_11) {
            throw new InternalErrorException(var5_11);
        }
    }

    protected String parseAttrType() throws RFC2253NameParserException {
        this.skipOIDIntro();
        if (q.indexOf(this.nameStrBuf_.charAt(this.position_)) != -1) {
            int n2 = this.position_;
            while (n2 < this.nameStrBuf_.length() && (this.nameStrBuf_.charAt(n2) == '-' || q.indexOf(this.nameStrBuf_.charAt(n2)) != -1 || l.indexOf(this.nameStrBuf_.charAt(n2)) != -1)) {
                ++n2;
            }
            if (n2 - this.position_ < 1) {
                Object[] objectArray = new Object[]{new Integer(this.position_)};
                throw new RFC2253NameParserException("Attribute type short name is corrupt (position {0,number,integer}).", objectArray);
            }
            String string = this.nameStrBuf_.toString().substring(this.position_, n2);
            this.position_ = n2;
            return string;
        }
        int n3 = this.position_;
        int n4 = this.position_;
        int n5 = this.position_;
        boolean bl = false;
        while (true) {
            if (n5 < this.nameStrBuf_.length() && l.indexOf(this.nameStrBuf_.charAt(n5)) != -1) {
                ++n5;
                continue;
            }
            if (n5 - n4 < 1) {
                Object[] objectArray = new Object[]{new Integer(this.position_)};
                throw new RFC2253NameParserException("Object Identifier representing attribute type is corrupt (position {0,number,integer}).", objectArray);
            }
            n3 = n5;
            if (this.nameStrBuf_.charAt(n5) == '.') {
                bl = true;
                n4 = ++n5;
            } else {
                bl = false;
            }
            if (!bl) break;
        }
        String string = this.nameStrBuf_.toString().substring(this.position_, n3);
        this.position_ = n3;
        return string;
    }

    protected d parseAVA() throws RFC2253NameParserException {
        String string = this.parseAttrType();
        this.skipSpace();
        if (this.position_ < this.nameStrBuf_.length() && this.nameStrBuf_.charAt(this.position_) == '=') {
            ++this.position_;
        } else {
            Object[] objectArray = new Object[]{new Integer(this.position_)};
            throw new RFC2253NameParserException("Cannot find attribute value after having parsed an equal (position {0,number,integer}).", objectArray);
        }
        this.skipSpace();
        if (this.position_ == this.nameStrBuf_.length()) {
            Object[] objectArray = new Object[]{new Integer(this.position_)};
            throw new RFC2253NameParserException("Cannot find attribute value after having parsed an equal (position {0,number,integer}).", objectArray);
        }
        d d2 = this.parseAttrValue();
        d2.type_ = string;
        this.skipSpace();
        return d2;
    }

    /*
     * Unable to fully structure code
     */
    public Name parse() throws RFC2253NameParserException {
        if (this.nameStrBuf_.length() == 0) {
            return new Name();
        }
        var1_1 = false;
        do {
            this.name_.rDNs_.addElement(this.parseRDN());
            this.skipSpace();
            if (this.position_ == this.nameStrBuf_.length()) {
                var1_1 = false;
            } else if (this.nameStrBuf_.charAt(this.position_) == ',' || this.nameStrBuf_.charAt(this.position_) == ';') {
                ++this.position_;
                var1_1 = true;
            } else {
                var2_2 = new Object[]{new Integer(this.position_)};
                throw new RFC2253NameParserException("RDNs are not separated by comma or semicolon (position {0,number,integer}).", var2_2);
            }
            this.skipSpace();
        } while (var1_1);
        var2_3 = new Name();
        var3_4 = new a(this);
        var4_5 = this.name_.rDNs_.size() - 1;
        while (var4_5 >= 0) {
            var5_6 = new RDN();
            var6_7 = (b)this.name_.rDNs_.elementAt(var4_5);
            var7_8 = 0;
            while (var7_8 < var6_7.aVAs_.size()) {
                block13: {
                    var8_9 = (d)var6_7.aVAs_.elementAt(var7_8);
                    var9_10 = "0123456789".indexOf(var8_9.type_.charAt(0)) == -1 ? var3_4.getOID(var8_9.type_) : new ObjectID(var8_9.type_);
                    if (var8_9.hasHexValue_) {
                        block14: {
                            var11_12 = null;
                            try {
                                var11_12 = var8_9.value_.getBytes("ISO8859_1");
                                var10_11 = DerCoder.decode((byte[])var11_12);
                                break block13;
                            }
                            catch (Exception v0) {
                                var12_13 = new StringBuffer();
                                if (var11_12 == null) break block14;
                                var13_14 = 0;
                                ** while (var13_14 < ((byte[])var11_12).length)
                            }
lbl-1000:
                            // 1 sources

                            {
                                if (var11_12[var13_14] < 16) {
                                    var12_13.append("0");
                                }
                                var12_13.append(Integer.toHexString(var11_12[var13_14]));
                                ++var13_14;
                                continue;
                            }
                        }
                        var13_15 = new Object[]{var12_13.toString()};
                        throw new RFC2253NameParserException("Cannot create AVA due to invalid hex value in attribute value (\"{0}\")", var13_15);
                    }
                    var10_11 = var8_9.value_;
                }
                var11_12 = var10_11 instanceof String ? (!PrintableString.isPrintableString((String)var10_11) ? (Object)new UTF8String((String)var10_11) : (Object)var10_11) : (Object)var10_11;
                var12_13 = new AVA(var9_10, var11_12);
                var5_6.addAVA((AVA)var12_13);
                ++var7_8;
            }
            var2_3.addRDN(var5_6);
            --var4_5;
        }
        return var2_3;
    }

    public RFC2253NameParser(String string) {
        try {
            this.nameStrBuf_ = new StringBuffer(string);
            return;
        }
        catch (Exception exception) {
            throw new InternalErrorException(exception);
        }
    }

    static {
        associations_.put("CN", ObjectID.commonName);
        associations_.put("C", ObjectID.country);
        associations_.put("L", ObjectID.locality);
        associations_.put("ST", ObjectID.stateOrProvince);
        associations_.put("STREET", ObjectID.streetAddress);
        associations_.put("O", ObjectID.organization);
        associations_.put("OU", ObjectID.organizationalUnit);
        associations_.put("T", ObjectID.title);
        associations_.put("SN", ObjectID.surName);
        associations_.put("DC", ObjectID.domainComponent);
        associations_.put("UID", ObjectID.userid);
        associations_.put("serialNumber", ObjectID.serialNumber);
        associations_.put("postalAddress", ObjectID.postalAddress);
        associations_.put("postalCode", ObjectID.postalCode);
        associations_.put("telephoneNumber", ObjectID.telephoneNumber);
        associations_.put("telexNumber", ObjectID.telexNumber);
        associations_.put("EMail", ObjectID.emailAddress);
        associations_.put("E", ObjectID.emailAddress);
        associations_.put("EA", ObjectID.emailAddress);
        associations_.put("MAIL", ObjectID.emailAddress);
        associations_.put("EMAIL", ObjectID.emailAddress);
    }
}

