/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.rsa;

import iaik.asn1.ASN1;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.security.rsa.a;
import iaik.utils.CryptoUtils;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public abstract class RSASignature
extends Signature {
    private static final int g = 2;
    private static final int f = 1;
    private static final String d = "PKCS1Padding";
    private static final String c = "ECB";
    private static final String e = "RSA";
    private a a;
    private AlgorithmID b;
    protected MessageDigest hash;

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2;
        byte[] byArray3 = this.hash.digest();
        try {
            byArray2 = this.a.doFinal(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw new SignatureException("Signature decryption error: " + exception.toString());
        }
        try {
            ASN1 aSN1 = new ASN1(byArray2);
            AlgorithmID algorithmID = new AlgorithmID(aSN1.getComponentAt(0));
            byte[] byArray4 = (byte[])aSN1.getComponentAt(1).getValue();
            if (!this.b.equals(algorithmID)) {
                throw new SignatureException("Signature AlgorithmID mismatch!");
            }
            return CryptoUtils.equalsBlock(byArray3, byArray4);
        }
        catch (SignatureException signatureException) {
            throw signatureException;
        }
        catch (Exception exception) {
            throw new SignatureException("Signature ASN.1 format error: " + exception.toString());
        }
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        this.hash.update(byArray, n2, n3);
    }

    protected void engineUpdate(byte by) {
        this.hash.update(by);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = this.hash.digest();
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.b.toASN1Object());
        sEQUENCE.addComponent(new OCTET_STRING(byArray));
        byte[] byArray2 = null;
        try {
            byte[] byArray3 = new ASN1(sEQUENCE).toByteArray();
            byArray2 = this.a.doFinal(byArray3, 0, byArray3.length);
        }
        catch (Exception exception) {
            throw new SignatureException("Signing error: " + exception.toString());
        }
        return byArray2;
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("Method not supported!");
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        try {
            this.a = new a();
            this.a.setMode(c);
            this.a.setPadding(d);
            this.a.init(2, publicKey, null);
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (Exception exception) {
            throw new InvalidKeyException("InitVerify error: " + exception.toString());
        }
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        try {
            this.a = new a();
            this.a.setMode(c);
            this.a.setPadding(d);
            this.a.init(1, privateKey, null);
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (Exception exception) {
            throw new InvalidKeyException("InitSign error: " + exception.toString());
        }
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("Method not supported!");
    }

    protected RSASignature(AlgorithmID algorithmID, MessageDigest messageDigest) {
        super(String.valueOf(algorithmID.getName()) + "withRSA");
        this.b = algorithmID;
        this.hash = messageDigest;
    }
}

