/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.asn1.ASN1;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.security.dh.DHParameters;
import iaik.security.dh.ESDHParameterSpec;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class ESDHParameters
extends DHParameters {
    private int c;
    private byte[] a;
    private BigInteger e;
    private BigInteger b;
    private BigInteger f;
    private BigInteger d;

    public int hashCode() {
        return this.d.hashCode() ^ this.f.hashCode() ^ this.b.hashCode();
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("p: " + this.d + "\n");
        stringBuffer.append("g: " + this.f + "\n");
        stringBuffer.append("q: " + this.b.toString());
        if (this.e != null) {
            stringBuffer.append("j: " + this.e.toString());
        }
        if (this.a != null) {
            stringBuffer.append("seed: " + this.a.toString());
            stringBuffer.append("pgenCounter: " + this.c);
        }
        return stringBuffer.toString();
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            ASN1 aSN1 = new ASN1(byArray);
            this.d = (BigInteger)aSN1.getComponentAt(0).getValue();
            this.f = (BigInteger)aSN1.getComponentAt(1).getValue();
            this.b = (BigInteger)aSN1.getComponentAt(2).getValue();
            int n2 = 0;
            while (n2 < aSN1.countComponents() - 3) {
                if (aSN1.getComponentAt(n2 + 3) instanceof INTEGER) {
                    this.e = (BigInteger)aSN1.getComponentAt(n2 + 3).getValue();
                }
                if (aSN1.getComponentAt(n2 + 3) instanceof SEQUENCE) {
                    SEQUENCE sEQUENCE = (SEQUENCE)aSN1.getComponentAt(n2 + 3);
                    this.a = (byte[])sEQUENCE.getComponentAt(0).getValue();
                    this.c = ((BigInteger)sEQUENCE.getComponentAt(1).getValue()).intValue();
                }
                ++n2;
            }
            return;
        }
        catch (CodingException codingException) {
            throw new IOException("Decoding error. " + codingException.toString());
        }
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof ESDHParameterSpec) {
            this.d = ((ESDHParameterSpec)algorithmParameterSpec).getP();
            this.f = ((ESDHParameterSpec)algorithmParameterSpec).getG();
            this.b = ((ESDHParameterSpec)algorithmParameterSpec).getQ();
            this.e = ((ESDHParameterSpec)algorithmParameterSpec).getJ();
            this.a = ((ESDHParameterSpec)algorithmParameterSpec).getSeed();
            this.c = ((ESDHParameterSpec)algorithmParameterSpec).getPGenCounter();
            return;
        }
        throw new InvalidParameterSpecException("Parameter must be ESDHParameterSpec.");
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        ESDHParameterSpec eSDHParameterSpec = new ESDHParameterSpec(this.d, this.f, this.b, this.e, this.a, this.c);
        if (!eSDHParameterSpec.getClass().isAssignableFrom(clazz)) {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
        }
        return eSDHParameterSpec;
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected byte[] engineGetEncoded() throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new INTEGER(this.d));
        sEQUENCE.addComponent(new INTEGER(this.f));
        sEQUENCE.addComponent(new INTEGER(this.b));
        if (this.e != null) {
            sEQUENCE.addComponent(new INTEGER(this.e));
        }
        if (this.a != null) {
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(new BIT_STRING(this.a));
            sEQUENCE2.addComponent(new INTEGER(this.c));
            sEQUENCE.addComponent(sEQUENCE2);
        }
        try {
            return new ASN1(sEQUENCE).toByteArray();
        }
        catch (CodingException codingException) {
            throw new IOException("Encoding error. " + codingException.toString());
        }
    }
}

