/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.security.cipher.l;
import iaik.utils.Util;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public class IvParameters
extends AlgorithmParametersSpi {
    byte[] a;

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IV: " + Util.toString(this.a) + "\n");
        return stringBuffer.toString();
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            ASN1Object aSN1Object = DerCoder.decode(byArray);
            if (!aSN1Object.isA(ASN.OCTET_STRING)) {
                throw new IOException("IV has to be encoded as ASN.1 OCTET STRING.");
            }
            this.a = (byte[])aSN1Object.getValue();
            return;
        }
        catch (CodingException codingException) {
            throw new IOException("DER decoding error. " + codingException.toString());
        }
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        try {
            this.a = l.a(1, algorithmParameterSpec, null, -1);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterSpecException(invalidAlgorithmParameterException.toString());
        }
        if (this.a == null) {
            throw new InvalidParameterSpecException("Unsupported type of AlgorithmParameterSpec: " + algorithmParameterSpec.getClass().getName());
        }
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (this.a == null) {
            throw new InvalidParameterSpecException("IV is null!");
        }
        IvParameterSpec ivParameterSpec = new IvParameterSpec(this.a);
        if (!ivParameterSpec.getClass().isAssignableFrom(clazz)) {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
        }
        return ivParameterSpec;
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected byte[] engineGetEncoded() throws IOException {
        OCTET_STRING oCTET_STRING = new OCTET_STRING(this.a);
        return DerCoder.encode(oCTET_STRING);
    }
}

