/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs8;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.ConstructedType;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.security.cipher.PBEKey;
import iaik.security.cipher.PBEKeyBMP;
import iaik.security.pbe.PBEGenParameterSpec;
import iaik.utils.InternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.Cipher;
import javax.crypto.spec.PBEParameterSpec;

public class EncryptedPrivateKeyInfo
implements ASN1Type,
Serializable,
PrivateKey {
    static /* synthetic */ Class d;
    ASN1 c;
    AlgorithmID b;
    PrivateKey a;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.c.writeTo(outputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.c == null) {
            throw new IOException("Private key not encrypted yet.");
        }
        objectOutputStream.write(this.getEncoded());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.b != null) {
            stringBuffer.append("Private key is encrypted with algorithm: " + this.b.getName());
        } else {
            stringBuffer.append(String.valueOf(this.a.getAlgorithm()) + " private key is not encrypted yet.");
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        return this.c.toASN1Object();
    }

    private Key a(char[] cArray) {
        if (this.b.equals(AlgorithmID.pbeWithMD5AndDES_CBC)) {
            return new PBEKey(cArray);
        }
        return new PBEKeyBMP(cArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        try {
            this.c = new ASN1(objectInputStream);
            this.a();
            return;
        }
        catch (CodingException codingException) {
            throw new IOException("Unable to restore PrivateKeyInfo: " + codingException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException("Unable to restore PrivateKeyInfo: " + invalidKeyException.toString());
        }
    }

    public PrivateKey getPrivateKeyInfo() {
        return this.a;
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        return this.c.toByteArray();
    }

    public String getAlgorithm() {
        return "ENCRYPTED";
    }

    public void encrypt(char[] cArray, AlgorithmID algorithmID, SecureRandom secureRandom, int n2) throws NoSuchAlgorithmException {
        byte[] byArray;
        Object object;
        this.b = (AlgorithmID)algorithmID.clone();
        try {
            object = this.b.getCipherInstance();
            PBEGenParameterSpec pBEGenParameterSpec = new PBEGenParameterSpec(8, n2);
            ((Cipher)object).init(1, this.a(cArray), pBEGenParameterSpec, secureRandom);
            byArray = ((Cipher)object).doFinal(this.a.getEncoded());
            this.b.setAlgorithmParameters(((Cipher)object).getParameters());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InternalErrorException(invalidKeyException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InternalErrorException(generalSecurityException);
        }
        object = null;
        try {
            object = new SEQUENCE();
            ((ConstructedType)object).addComponent(this.b.toASN1Object());
            ((ConstructedType)object).addComponent(new OCTET_STRING(byArray));
            this.c = new ASN1((ASN1Object)object);
            return;
        }
        catch (CodingException codingException) {
            throw new InternalErrorException(codingException);
        }
    }

    public void encrypt(char[] cArray, AlgorithmID algorithmID, SecureRandom secureRandom) throws NoSuchAlgorithmException {
        this.encrypt(cArray, algorithmID, secureRandom, 1);
    }

    public void encrypt(String string, AlgorithmID algorithmID, SecureRandom secureRandom) throws NoSuchAlgorithmException {
        this.encrypt(string.toCharArray(), algorithmID, secureRandom);
    }

    public PrivateKey decrypt(char[] cArray) throws GeneralSecurityException, NoSuchAlgorithmException {
        Object object;
        PBEParameterSpec pBEParameterSpec = null;
        try {
            object = this.b.getAlgorithmParameters("PBE");
            pBEParameterSpec = (PBEParameterSpec)((AlgorithmParameters)object).getParameterSpec(d != null ? d : (d = EncryptedPrivateKeyInfo.a("javax.crypto.spec.PBEParameterSpec")));
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InternalErrorException(invalidParameterSpecException);
        }
        object = this.b.getCipherInstance();
        try {
            ((Cipher)object).init(2, this.a(cArray), pBEParameterSpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InternalErrorException(invalidKeyException);
        }
        try {
            byte[] byArray = (byte[])this.c.getComponentAt(1).getValue();
            byte[] byArray2 = ((Cipher)object).doFinal(byArray);
            this.a = PrivateKeyInfo.getPrivateKey(byArray2);
            return this.a;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new GeneralSecurityException("Unable to parse decrypted private key: " + invalidKeyException.toString());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new GeneralSecurityException("Unable to decrypt private key: " + generalSecurityException.toString());
        }
        catch (CodingException codingException) {
            throw new GeneralSecurityException("Unable to parse decrypted private key: " + codingException.toString());
        }
    }

    public PrivateKey decrypt(String string) throws GeneralSecurityException, NoSuchAlgorithmException {
        return this.decrypt(string.toCharArray());
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.c = new ASN1(aSN1Object);
        try {
            this.a();
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CodingException(invalidKeyException.toString());
        }
    }

    private void a() throws InvalidKeyException {
        try {
            this.b = new AlgorithmID(this.c.getComponentAt(0));
            return;
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException(codingException.toString());
        }
    }

    public EncryptedPrivateKeyInfo(byte[] byArray) throws InvalidKeyException {
        try {
            this.c = new ASN1(byArray);
            this.a();
            return;
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("No PrivateKeyInfo: " + codingException.toString());
        }
    }

    public EncryptedPrivateKeyInfo(PrivateKey privateKey) {
        this.a = privateKey;
    }

    public EncryptedPrivateKeyInfo(InputStream inputStream) throws IOException, InvalidKeyException {
        try {
            this.c = new ASN1(inputStream);
            this.a();
            return;
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("No PrivateKeyInfo: " + codingException.toString());
        }
    }

    public EncryptedPrivateKeyInfo(ASN1Object aSN1Object) throws InvalidKeyException {
        try {
            this.c = new ASN1(aSN1Object);
            this.a();
            return;
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("No PrivateKeyInfo: " + codingException.toString());
        }
    }
}

