/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.signatures;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Signature;
import java.security.SignatureException;

public class SignatureInputStream
extends FilterInputStream {
    protected boolean on_ = true;
    protected Signature signatureEngine_;
    protected boolean isClosed_;
    protected boolean isAtEOF_;
    protected int bytesProcessed_;
    protected boolean passThroughClose_;

    public SignatureInputStream(InputStream inputStream, Signature signature, boolean bl) {
        super(inputStream);
        if (inputStream == null) {
            throw new NullPointerException("Argument \"data\" must not be null.");
        }
        this.setSignature(signature);
        this.passThroughClose_ = bl;
    }

    public int clearBytesProcessed() {
        int n2 = this.bytesProcessed_;
        this.bytesProcessed_ = 0;
        return n2;
    }

    public void close() throws IOException {
        if (this.passThroughClose_) {
            this.in.close();
        }
        this.isClosed_ = true;
    }

    public int getBytesProcessed() {
        return this.bytesProcessed_;
    }

    public Signature getSignature() {
        return this.signatureEngine_;
    }

    public boolean isOn() {
        return this.on_;
    }

    public boolean isStreamAtEOF() {
        return this.isAtEOF_;
    }

    public boolean isStreamClosed() {
        return this.isClosed_;
    }

    public int read() throws IOException {
        int n2;
        try {
            n2 = this.in.read();
        }
        catch (EOFException eOFException) {
            this.isAtEOF_ = true;
            throw eOFException;
        }
        if (n2 <= -1) {
            this.isAtEOF_ = true;
        } else if (this.on_) {
            try {
                this.signatureEngine_.update((byte)n2);
                ++this.bytesProcessed_;
            }
            catch (SignatureException signatureException) {
                throw new IOException("Error updating signature engine: " + signatureException.toString());
            }
        }
        return n2;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        try {
            n4 = this.in.read(byArray, n2, n3);
        }
        catch (EOFException eOFException) {
            this.isAtEOF_ = true;
            throw eOFException;
        }
        if (n4 <= -1) {
            this.isAtEOF_ = true;
        } else if (this.on_) {
            try {
                this.signatureEngine_.update(byArray, n2, n4);
                this.bytesProcessed_ += n4;
            }
            catch (SignatureException signatureException) {
                throw new IOException("Error updating signature engine: " + signatureException.toString());
            }
        }
        return n4;
    }

    public boolean setOn(boolean bl) {
        boolean bl2 = this.on_;
        this.on_ = bl;
        return bl2;
    }

    public void setSignature(Signature signature) {
        if (signature == null) {
            throw new NullPointerException("Argument \"signatureEngine\" must not be null.");
        }
        this.signatureEngine_ = signature;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(this.in.toString());
        stringBuffer.append('|');
        stringBuffer.append(this.signatureEngine_.toString());
        return stringBuffer.toString();
    }
}

