/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.random;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;

public class PKCS11RandomSpi
extends SecureRandomSpi
implements PKCS11EngineClass {
    private static final boolean DEBUG = false;
    protected static final String SOFTWARE_SECURE_RANDOM_ALGORITHM = "SHA1PRNG";
    protected TokenManager tokenManager_;
    protected Session session_;
    protected boolean pkcs11OperationInitialized_;
    protected boolean useSoftwareDelegation_;
    protected SecureRandom softwareDelegate_;

    public PKCS11RandomSpi() throws IAIKPkcs11Exception {
        int n2 = IAIKPkcs11.getProviderInstanceCount();
        if (n2 <= 0) {
            throw new IAIKPkcs11Exception("No instance of IAIKPkcs11 available.");
        }
        this.tokenManager_ = IAIKPkcs11.getProviderInstance(1).getTokenManager();
        this.initialize();
    }

    public PKCS11RandomSpi(TokenManager tokenManager) throws IAIKPkcs11Exception {
        if (tokenManager == null) {
            throw new NullPointerException("Argument \"tokenManager\" must not be null.");
        }
        this.tokenManager_ = tokenManager;
        this.initialize();
    }

    protected byte[] engineGenerateSeed(int n2) {
        byte[] byArray;
        if (n2 < 0) {
            throw new IllegalArgumentException("Argument \"numBytes\" must be greater than or equal to zero.");
        }
        if (this.useSoftwareDelegation_) {
            byArray = this.softwareDelegate_.generateSeed(n2);
        } else {
            if (!this.pkcs11OperationInitialized_) {
                this.initializePkcs11Operation();
            }
            try {
                try {
                    byArray = this.session_.generateRandom(n2);
                }
                catch (TokenException tokenException) {
                    if (tokenException instanceof PKCS11Exception) {
                        PKCS11Exception pKCS11Exception = (PKCS11Exception)tokenException;
                        if (pKCS11Exception.getErrorCode() == 257L) {
                            try {
                                this.tokenManager_.makeAuthorizedSession(this.session_, null);
                                byArray = this.session_.generateRandom(n2);
                            }
                            catch (TokenException tokenException2) {
                                throw new IAIKPkcs11Exception(tokenException.toString());
                            }
                        }
                        throw new IAIKPkcs11Exception(tokenException.toString());
                    }
                    throw new IAIKPkcs11Exception(tokenException.toString());
                }
                Object var4_5 = null;
                this.finalizePkcs11Operation();
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.finalizePkcs11Operation();
                throw throwable;
            }
        }
        return byArray;
    }

    protected void engineNextBytes(byte[] byArray) throws IAIKPkcs11Exception {
        if (byArray == null) {
            throw new NullPointerException("Argument \"arrayToFill\" must not be null.");
        }
        if (this.useSoftwareDelegation_) {
            this.softwareDelegate_.nextBytes(byArray);
        } else {
            int n2;
            if (!this.pkcs11OperationInitialized_) {
                this.initializePkcs11Operation();
            }
            if ((n2 = byArray.length) > 0) {
                byte[] byArray2;
                try {
                    try {
                        byArray2 = this.session_.generateRandom(n2);
                    }
                    catch (TokenException tokenException) {
                        if (tokenException instanceof PKCS11Exception) {
                            PKCS11Exception pKCS11Exception = (PKCS11Exception)tokenException;
                            if (pKCS11Exception.getErrorCode() == 257L) {
                                try {
                                    this.tokenManager_.makeAuthorizedSession(this.session_, null);
                                    byArray2 = this.session_.generateRandom(n2);
                                }
                                catch (TokenException tokenException2) {
                                    throw new IAIKPkcs11Exception(tokenException.toString());
                                }
                            }
                            throw new IAIKPkcs11Exception(tokenException.toString());
                        }
                        throw new IAIKPkcs11Exception(tokenException.toString());
                    }
                    Object var5_6 = null;
                    this.finalizePkcs11Operation();
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    this.finalizePkcs11Operation();
                    throw throwable;
                }
                System.arraycopy(byArray2, 0, byArray, 0, n2);
            }
        }
    }

    protected void engineSetSeed(byte[] byArray) throws IAIKPkcs11Exception {
        if (byArray == null) {
            throw new NullPointerException("Argument \"seedBytes\" must not be null.");
        }
        if (this.useSoftwareDelegation_) {
            this.softwareDelegate_.setSeed(byArray);
        } else {
            if (!this.pkcs11OperationInitialized_) {
                this.initializePkcs11Operation();
            }
            try {
                try {
                    this.session_.seedRandom(byArray);
                }
                catch (TokenException tokenException) {
                    if (tokenException instanceof PKCS11Exception) {
                        PKCS11Exception pKCS11Exception = (PKCS11Exception)tokenException;
                        if (pKCS11Exception.getErrorCode() == 257L) {
                            try {
                                this.tokenManager_.makeAuthorizedSession(this.session_, null);
                                this.session_.seedRandom(byArray);
                            }
                            catch (TokenException tokenException2) {
                                throw new IAIKPkcs11Exception(tokenException.toString());
                            }
                        }
                        throw new IAIKPkcs11Exception(tokenException.toString());
                    }
                    throw new IAIKPkcs11Exception(tokenException.toString());
                }
                Object var3_4 = null;
                this.finalizePkcs11Operation();
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.finalizePkcs11Operation();
                throw throwable;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.session_ != null) {
            this.tokenManager_.disposeSession(this.session_);
        }
        super.finalize();
    }

    protected void finalizePkcs11Operation() {
        this.pkcs11OperationInitialized_ = false;
        this.tokenManager_.disposeSession(this.session_);
        this.session_ = null;
    }

    protected String getSoftwareDelegateAlgorithm() {
        return SOFTWARE_SECURE_RANDOM_ALGORITHM;
    }

    protected void initialize() {
        try {
            boolean bl;
            Token token = this.tokenManager_.getToken();
            if (token != null) {
                TokenInfo tokenInfo = token.getTokenInfo();
                bl = tokenInfo.isRNG();
            } else {
                bl = false;
            }
            if (!bl) {
                this.useSoftwareDelegation_ = true;
                this.initializeSoftwareDelegate();
            } else {
                this.useSoftwareDelegation_ = false;
            }
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception("Could not get token info: " + tokenException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IAIKPkcs11Exception("Could not instantiate delegate secure random: " + generalSecurityException);
        }
    }

    protected void initializePkcs11Operation() {
        try {
            TokenInfo tokenInfo = this.tokenManager_.getToken().getTokenInfo();
            if (!tokenInfo.isRNG()) {
                throw new IAIKPkcs11Exception("The PKCS#11 token does not have a random number generator.");
            }
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
        this.initializeSession();
        this.pkcs11OperationInitialized_ = true;
    }

    protected void initializeSession() {
        try {
            if (this.session_ == null) {
                this.session_ = this.tokenManager_.getSession(false);
            }
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void initializeSoftwareDelegate() throws GeneralSecurityException {
        DelegateProvider delegateProvider = this.tokenManager_ != null ? this.tokenManager_.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.getSoftwareDelegateAlgorithm();
        this.softwareDelegate_ = delegateProvider.getSecureRandom(string);
        if (this.softwareDelegate_ == null) {
            throw new IAIKPkcs11Exception("Could not get delegate secure random engine for " + string);
        }
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            Token token = this.tokenManager_.getToken();
            if (token != null) {
                TokenInfo tokenInfo = token.getTokenInfo();
                bl = tokenInfo.isRNG();
            } else {
                bl = false;
            }
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }
}

