/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.macs;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.parameters.RC5Parameters;
import iaik.pkcs.pkcs11.provider.macs.PKCS11Mac;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;

public class Rc5Mac
extends PKCS11Mac {
    private static final boolean DEBUG = false;
    protected static String MAC_ALGORITHM_NAME = "MacRC5";
    protected Mechanism mechanism_;
    protected RC5ParameterSpec rc5ParameterSpec_;
    protected boolean rc5ParameterSpecChanged_;

    protected String getAlgorithmName() {
        return MAC_ALGORITHM_NAME;
    }

    protected Mechanism getMechanism() {
        if (this.rc5ParameterSpecChanged_) {
            Mechanism mechanism = (Mechanism)Mechanism.RC5_MAC.clone();
            if (this.rc5ParameterSpec_ != null) {
                int n2 = this.rc5ParameterSpec_.getWordSize();
                int n3 = this.rc5ParameterSpec_.getRounds();
                RC5Parameters rC5Parameters = new RC5Parameters(n2, n3);
                mechanism.setParameters(rC5Parameters);
                this.rc5ParameterSpecChanged_ = false;
            }
            this.mechanism_ = mechanism;
        }
        return this.mechanism_;
    }

    public Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            this.usedMechanisms_ = new Mechanism[]{Mechanism.RC5_MAC};
        }
        return this.usedMechanisms_;
    }

    protected int pkcs11GetMacLength() {
        int n2 = -1;
        if (this.rc5ParameterSpec_ != null) {
            n2 = this.rc5ParameterSpec_.getWordSize();
        }
        return n2;
    }

    protected void pkcs11Init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof RC5ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("key must be of type javax.crypto.spec.RC5ParameterSpec!");
        }
        this.rc5ParameterSpec_ = (RC5ParameterSpec)algorithmParameterSpec;
        this.rc5ParameterSpecChanged_ = true;
        super.pkcs11Init(key, algorithmParameterSpec);
    }
}

