/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keys;

import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DSAPublicKey;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keyfactories.DsaKeyFactory;
import iaik.pkcs.pkcs11.provider.keyfactories.KeyFactoryAdapter;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import iaik.security.dsa.DSAParams;
import java.math.BigInteger;
import java.security.KeyFactory;

public class IAIKPKCS11DsaPublicKey
extends IAIKPKCS11PublicKey
implements java.security.interfaces.DSAPublicKey {
    private static final boolean DEBUG = false;

    public IAIKPKCS11DsaPublicKey(TokenManager tokenManager, DSAPublicKey dSAPublicKey) {
        super(tokenManager, dSAPublicKey);
    }

    public static IAIKPKCS11DsaPublicKey create(TokenManager tokenManager, DSAPublicKey dSAPublicKey) {
        return new IAIKPKCS11DsaPublicKey(tokenManager, dSAPublicKey);
    }

    public String getAlgorithm() {
        return "DSA";
    }

    protected KeyFactory getKeyFactory() {
        return new KeyFactoryAdapter(new DsaKeyFactory(), this.tokenManager_.getProvider(), this.getAlgorithm());
    }

    public java.security.interfaces.DSAParams getParams() {
        DSAPublicKey dSAPublicKey = (DSAPublicKey)this.keyObject_;
        ByteArrayAttribute byteArrayAttribute = dSAPublicKey.getPrime();
        if (!byteArrayAttribute.isPresent()) {
            throw new UnsupportedOperationException("Prime P not present.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new UnsupportedOperationException("Prime P value is sensitive.");
        }
        byte[] byArray = byteArrayAttribute.getByteArrayValue();
        byteArrayAttribute = dSAPublicKey.getSubprime();
        if (!byteArrayAttribute.isPresent()) {
            throw new UnsupportedOperationException("Subprime Q not present.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new UnsupportedOperationException("Subprime Q value is sensitive.");
        }
        byte[] byArray2 = byteArrayAttribute.getByteArrayValue();
        byteArrayAttribute = dSAPublicKey.getBase();
        if (!byteArrayAttribute.isPresent()) {
            throw new UnsupportedOperationException("Base G not present.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new UnsupportedOperationException("Base G value is sensitive.");
        }
        byte[] byArray3 = byteArrayAttribute.getByteArrayValue();
        return new DSAParams(new BigInteger(1, byArray), new BigInteger(1, byArray2), new BigInteger(1, byArray3));
    }

    public BigInteger getY() {
        DSAPublicKey dSAPublicKey = (DSAPublicKey)this.keyObject_;
        ByteArrayAttribute byteArrayAttribute = dSAPublicKey.getValue();
        if (!byteArrayAttribute.isPresent()) {
            throw new UnsupportedOperationException("Y not present.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new UnsupportedOperationException("Y value is sensitive.");
        }
        byte[] byArray = byteArrayAttribute.getByteArrayValue();
        return new BigInteger(1, byArray);
    }
}

