/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keys;

import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keyfactories.DhKeyFactory;
import iaik.pkcs.pkcs11.provider.keyfactories.KeyFactoryAdapter;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import java.math.BigInteger;
import java.security.KeyFactory;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

public class IAIKPKCS11DhPublicKey
extends IAIKPKCS11PublicKey
implements DHPublicKey {
    private static final boolean DEBUG = false;

    public IAIKPKCS11DhPublicKey(TokenManager tokenManager, iaik.pkcs.pkcs11.objects.DHPublicKey dHPublicKey) {
        super(tokenManager, dHPublicKey);
    }

    public static IAIKPKCS11DhPublicKey create(TokenManager tokenManager, iaik.pkcs.pkcs11.objects.DHPublicKey dHPublicKey) {
        return new IAIKPKCS11DhPublicKey(tokenManager, dHPublicKey);
    }

    public String getAlgorithm() {
        return "DH";
    }

    protected KeyFactory getKeyFactory() {
        return new KeyFactoryAdapter(new DhKeyFactory(), this.tokenManager_.getProvider(), this.getAlgorithm());
    }

    public DHParameterSpec getParams() {
        iaik.pkcs.pkcs11.objects.DHPublicKey dHPublicKey = (iaik.pkcs.pkcs11.objects.DHPublicKey)this.keyObject_;
        ByteArrayAttribute byteArrayAttribute = dHPublicKey.getPrime();
        if (!byteArrayAttribute.isPresent()) {
            throw new UnsupportedOperationException("Prime P not present.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new UnsupportedOperationException("Prime P value is sensitive.");
        }
        byte[] byArray = byteArrayAttribute.getByteArrayValue();
        byteArrayAttribute = dHPublicKey.getBase();
        if (!byteArrayAttribute.isPresent()) {
            throw new UnsupportedOperationException("Base G not present.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new UnsupportedOperationException("Base G value is sensitive.");
        }
        byte[] byArray2 = byteArrayAttribute.getByteArrayValue();
        return new DHParameterSpec(new BigInteger(1, byArray), new BigInteger(1, byArray2));
    }

    public BigInteger getY() {
        iaik.pkcs.pkcs11.objects.DHPublicKey dHPublicKey = (iaik.pkcs.pkcs11.objects.DHPublicKey)this.keyObject_;
        ByteArrayAttribute byteArrayAttribute = dHPublicKey.getValue();
        if (!byteArrayAttribute.isPresent()) {
            throw new UnsupportedOperationException("Y not present.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new UnsupportedOperationException("Y value is sensitive.");
        }
        byte[] byArray = byteArrayAttribute.getByteArrayValue();
        return new BigInteger(1, byArray);
    }
}

