/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keypairgenerators;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.DSAPublicKey;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.provider.keypairgenerators.PKCS11KeyPairGenerationSpec;
import iaik.pkcs.pkcs11.provider.keypairgenerators.PKCS11KeyPairGenerator;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;

public class X942DhKeyPairGenerator
extends PKCS11KeyPairGenerator {
    private static final boolean DEBUG = false;

    protected iaik.pkcs.pkcs11.objects.Object createPublicKeyCreationTemplate(PKCS11KeyPairGenerationSpec pKCS11KeyPairGenerationSpec) {
        iaik.pkcs.pkcs11.objects.Object object;
        AlgorithmParameterSpec algorithmParameterSpec = pKCS11KeyPairGenerationSpec.getAlgorithmParameterSpec();
        if (algorithmParameterSpec != null && algorithmParameterSpec instanceof DSAParameterSpec) {
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
            DSAPublicKey dSAPublicKey = new DSAPublicKey();
            BigInteger bigInteger = dSAParameterSpec.getP();
            byte[] byArray = Util.unsignedBigIntergerToByteArray(bigInteger);
            BigInteger bigInteger2 = dSAParameterSpec.getQ();
            byte[] byArray2 = Util.unsignedBigIntergerToByteArray(bigInteger2);
            BigInteger bigInteger3 = dSAParameterSpec.getG();
            byte[] byArray3 = Util.unsignedBigIntergerToByteArray(bigInteger3);
            dSAPublicKey.getPrime().setByteArrayValue(byArray);
            dSAPublicKey.getSubprime().setByteArrayValue(byArray2);
            dSAPublicKey.getBase().setByteArrayValue(byArray3);
            PublicKey publicKey = this.keyPairGenerationSpec_.getPublicKeyTemplate();
            GenericTemplate genericTemplate = new GenericTemplate();
            genericTemplate.addAllPresentAttributes(dSAPublicKey);
            if (publicKey != null) {
                genericTemplate.addAllPresentAttributes(publicKey);
            }
            object = genericTemplate;
        } else {
            object = this.keyPairGenerationSpec_.getPublicKeyTemplate();
        }
        System.out.println(((iaik.pkcs.pkcs11.objects.Object)object).toString());
        return object;
    }

    protected Mechanism getMechanism() {
        return Mechanism.X9_42_DH_KEY_PAIR_GEN;
    }

    protected void validateAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("This key-pair generator does not accept the given parameters. They must be null or an isntance of DSAParameterSpec, but they are " + algorithmParameterSpec);
        }
    }
}

