/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keypairgenerators;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.DHPrivateKey;
import iaik.pkcs.pkcs11.objects.DHPublicKey;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.provider.keypairgenerators.PKCS11KeyPairGenerationSpec;
import iaik.pkcs.pkcs11.provider.keypairgenerators.PKCS11KeyPairGenerator;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public class DhKeyPairGenerator
extends PKCS11KeyPairGenerator {
    private static final boolean DEBUG = false;

    protected iaik.pkcs.pkcs11.objects.Object createPrivateKeyCreationTemplate(PKCS11KeyPairGenerationSpec pKCS11KeyPairGenerationSpec) {
        iaik.pkcs.pkcs11.objects.Object object;
        AlgorithmParameterSpec algorithmParameterSpec = pKCS11KeyPairGenerationSpec.getAlgorithmParameterSpec();
        if (algorithmParameterSpec != null && algorithmParameterSpec instanceof DHParameterSpec) {
            DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
            DHPrivateKey dHPrivateKey = new DHPrivateKey();
            int n2 = dHParameterSpec.getL();
            if (n2 > 0) {
                dHPrivateKey.getValueBits().setLongValue(new Long(n2));
                PrivateKey privateKey = this.keyPairGenerationSpec_.getPrivateKeyTemplate();
                GenericTemplate genericTemplate = new GenericTemplate();
                genericTemplate.addAllPresentAttributes(dHPrivateKey);
                if (privateKey != null) {
                    genericTemplate.addAllPresentAttributes(privateKey);
                }
                object = genericTemplate;
            } else {
                object = this.keyPairGenerationSpec_.getPrivateKeyTemplate();
            }
        } else {
            object = this.keyPairGenerationSpec_.getPrivateKeyTemplate();
        }
        return object;
    }

    protected iaik.pkcs.pkcs11.objects.Object createPublicKeyCreationTemplate(PKCS11KeyPairGenerationSpec pKCS11KeyPairGenerationSpec) {
        iaik.pkcs.pkcs11.objects.Object object;
        AlgorithmParameterSpec algorithmParameterSpec = pKCS11KeyPairGenerationSpec.getAlgorithmParameterSpec();
        if (algorithmParameterSpec != null && algorithmParameterSpec instanceof DHParameterSpec) {
            DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
            DHPublicKey dHPublicKey = new DHPublicKey();
            BigInteger bigInteger = dHParameterSpec.getP();
            byte[] byArray = Util.unsignedBigIntergerToByteArray(bigInteger);
            BigInteger bigInteger2 = dHParameterSpec.getG();
            byte[] byArray2 = Util.unsignedBigIntergerToByteArray(bigInteger2);
            dHPublicKey.getPrime().setByteArrayValue(byArray);
            dHPublicKey.getBase().setByteArrayValue(byArray2);
            PublicKey publicKey = this.keyPairGenerationSpec_.getPublicKeyTemplate();
            GenericTemplate genericTemplate = new GenericTemplate();
            genericTemplate.addAllPresentAttributes(dHPublicKey);
            if (publicKey != null) {
                genericTemplate.addAllPresentAttributes(publicKey);
            }
            object = genericTemplate;
        } else {
            object = this.keyPairGenerationSpec_.getPublicKeyTemplate();
        }
        return object;
    }

    protected Mechanism getMechanism() {
        return Mechanism.DH_PKCS_KEY_PAIR_GEN;
    }

    protected void validateAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("This key-pair generator does not accept the given parameters. They must be null or an isntance of DHParameterSpec, but they are " + algorithmParameterSpec);
        }
    }
}

