/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyfactories;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.SessionInfo;
import iaik.pkcs.pkcs11.State;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.SecretKeyFactorySpi;

public abstract class PKCS11SecretKeyFactory
extends SecretKeyFactorySpi
implements PKCS11EngineClass {
    private static final boolean DEBUG = false;
    protected TokenManager tokenManager_;
    protected Session session_;
    protected boolean pkcs11OperationInitialized_;
    protected PKCS11KeySpec pkcs11KeySpec_;
    protected SecretKeyFactory softwareDelegate_;

    protected Key createKey(iaik.pkcs.pkcs11.objects.Object object) throws InvalidKeySpecException {
        this.initializePkcs11Operation();
        iaik.pkcs.pkcs11.objects.Key key = null;
        try {
            key = (iaik.pkcs.pkcs11.objects.Key)this.session_.createObject(object);
        }
        catch (TokenException tokenException) {
            this.finalizePkcs11Operation();
            throw new InvalidKeySpecException("The public key could not be generated using the given key spec: " + tokenException.toString());
        }
        IAIKPKCS11Key iAIKPKCS11Key = IAIKPKCS11Key.create(this.tokenManager_, key);
        if (!key.getToken().getBooleanValue().booleanValue()) {
            iAIKPKCS11Key.setSession(this.session_);
        }
        this.finalizePkcs11Operation();
        return iAIKPKCS11Key;
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        SecretKey secretKey;
        if (keySpec instanceof PKCS11KeySpec) {
            secretKey = this.pkcs11GenerateSecret(keySpec);
        } else {
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            secretKey = this.softwareDelegate_.generateSecret(keySpec);
        }
        return secretKey;
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        KeySpec keySpec;
        if (secretKey instanceof IAIKPKCS11Key) {
            keySpec = this.pkcs11GetKeySpec(secretKey, clazz);
        } else {
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            keySpec = this.softwareDelegate_.getKeySpec(secretKey, clazz);
        }
        return keySpec;
    }

    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        SecretKey secretKey2;
        if (secretKey instanceof IAIKPKCS11Key) {
            secretKey2 = this.pkcs11TranslateKey(secretKey);
        } else {
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            secretKey2 = this.softwareDelegate_.translateKey(secretKey);
        }
        return secretKey2;
    }

    protected void finalize() throws Throwable {
        if (this.session_ != null) {
            this.tokenManager_.disposeSession(this.session_);
        }
        super.finalize();
    }

    protected void finalizePkcs11Operation() {
        this.pkcs11OperationInitialized_ = false;
        this.tokenManager_.disposeSession(this.session_);
        this.session_ = null;
    }

    protected abstract String getSoftwareDelegateAlgorithm();

    protected void initializePkcs11Operation() {
        this.initializeSession();
        this.pkcs11OperationInitialized_ = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initializeSession() {
        if (this.pkcs11KeySpec_ == null) throw new IAIKPkcs11Exception("Key factory is not initialized properly. The key spec is not set appropriately.");
        this.tokenManager_ = this.pkcs11KeySpec_.getTokenManager();
        try {
            if (this.isSessionAppropriate(this.session_, this.pkcs11KeySpec_)) return;
            if (this.session_ == null) {
                Session session = this.session_ = this.pkcs11KeySpec_.isUseROSession() ? this.tokenManager_.getSession(false) : this.tokenManager_.getSession(true);
            }
            if (!this.pkcs11KeySpec_.isUseUserSession()) return;
            this.tokenManager_.makeAuthorizedSession(this.session_, null);
            return;
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void initializeSoftwareDelegate() {
        DelegateProvider delegateProvider = this.tokenManager_ != null ? this.tokenManager_.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.getSoftwareDelegateAlgorithm();
        this.softwareDelegate_ = delegateProvider.getSecretKeyFactory(string);
        if (this.softwareDelegate_ == null) {
            throw new IAIKPkcs11Exception("Could not get delegate secret key factory engine for " + string);
        }
    }

    protected boolean isSessionAppropriate(Session session, PKCS11KeySpec pKCS11KeySpec) throws TokenException {
        boolean bl = false;
        if (session != null && pKCS11KeySpec != null) {
            SessionInfo sessionInfo = session.getSessionInfo();
            Token token = session.getToken();
            State state = sessionInfo.getState();
            boolean bl2 = state.equals(State.RO_USER_FUNCTIONS) || state.equals(State.RW_USER_FUNCTIONS);
            bl = token.equals(this.tokenManager_.getToken()) && sessionInfo.isRwSession() != pKCS11KeySpec.isUseROSession() && bl2 == pKCS11KeySpec.isUseUserSession();
        }
        return bl;
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        return true;
    }

    protected abstract SecretKey pkcs11GenerateSecret(KeySpec var1) throws InvalidKeySpecException;

    protected abstract KeySpec pkcs11GetKeySpec(SecretKey var1, Class var2) throws InvalidKeySpecException;

    protected abstract SecretKey pkcs11TranslateKey(SecretKey var1) throws InvalidKeyException;
}

