/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyfactories;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.SessionInfo;
import iaik.pkcs.pkcs11.State;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public abstract class PKCS11KeyFactory
extends KeyFactorySpi
implements PKCS11EngineClass {
    private static final boolean DEBUG = false;
    public static final int PKCS8_VERSION = 0;
    protected TokenManager tokenManager_;
    protected Session session_;
    protected boolean pkcs11OperationInitialized_;
    protected PKCS11KeySpec pkcs11KeySpec_;
    protected KeyFactory softwareDelegate_;

    protected Key createKey(iaik.pkcs.pkcs11.objects.Object object) throws InvalidKeySpecException {
        this.initializePkcs11Operation();
        iaik.pkcs.pkcs11.objects.Key key = null;
        try {
            key = (iaik.pkcs.pkcs11.objects.Key)this.session_.createObject(object);
        }
        catch (TokenException tokenException) {
            this.finalizePkcs11Operation();
            throw new InvalidKeySpecException("The public key could not be generated using the given key spec: " + tokenException.toString());
        }
        IAIKPKCS11Key iAIKPKCS11Key = IAIKPKCS11Key.create(this.tokenManager_, key);
        if (!key.getToken().getBooleanValue().booleanValue()) {
            iAIKPKCS11Key.setSession(this.session_);
        }
        this.finalizePkcs11Operation();
        return iAIKPKCS11Key;
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        PrivateKey privateKey;
        if (keySpec instanceof PKCS11KeySpec) {
            privateKey = this.pkcs11GeneratePrivate(keySpec);
        } else {
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            privateKey = this.softwareDelegate_.generatePrivate(keySpec);
        }
        return privateKey;
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        PublicKey publicKey;
        if (keySpec instanceof PKCS11KeySpec) {
            publicKey = this.pkcs11GeneratePublic(keySpec);
        } else {
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            publicKey = this.softwareDelegate_.generatePublic(keySpec);
        }
        return publicKey;
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        KeySpec keySpec;
        if (key instanceof IAIKPKCS11Key) {
            keySpec = this.pkcs11GetKeySpec(key, clazz);
        } else {
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            keySpec = this.softwareDelegate_.getKeySpec(key, clazz);
        }
        return keySpec;
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        Key key2;
        if (key instanceof IAIKPKCS11Key) {
            key2 = this.pkcs11TranslateKey(key);
        } else {
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            key2 = this.softwareDelegate_.translateKey(key);
        }
        return key2;
    }

    protected void finalize() throws Throwable {
        if (this.session_ != null) {
            this.tokenManager_.disposeSession(this.session_);
        }
        super.finalize();
    }

    protected void finalizePkcs11Operation() {
        this.pkcs11OperationInitialized_ = false;
        this.tokenManager_.disposeSession(this.session_);
        this.session_ = null;
    }

    protected abstract String getSoftwareDelegateAlgorithm();

    protected void initializePkcs11Operation() {
        this.initializeSession();
        this.pkcs11OperationInitialized_ = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initializeSession() {
        if (this.pkcs11KeySpec_ == null) throw new IAIKPkcs11Exception("Key factory is not initialized properly. The key spec is not set appropriately.");
        this.tokenManager_ = this.pkcs11KeySpec_.getTokenManager();
        try {
            if (this.isSessionAppropriate(this.session_, this.pkcs11KeySpec_)) return;
            if (this.session_ == null) {
                Session session = this.session_ = this.pkcs11KeySpec_.isUseROSession() ? this.tokenManager_.getSession(false) : this.tokenManager_.getSession(true);
            }
            if (!this.pkcs11KeySpec_.isUseUserSession()) return;
            this.tokenManager_.makeAuthorizedSession(this.session_, null);
            return;
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void initializeSoftwareDelegate() {
        DelegateProvider delegateProvider = this.tokenManager_ != null ? this.tokenManager_.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.getSoftwareDelegateAlgorithm();
        this.softwareDelegate_ = delegateProvider.getKeyFactory(string);
        if (this.softwareDelegate_ == null) {
            throw new IAIKPkcs11Exception("Could not get delegate key factory engine for " + string);
        }
    }

    protected boolean isSessionAppropriate(Session session, PKCS11KeySpec pKCS11KeySpec) throws TokenException {
        boolean bl = false;
        if (session != null && pKCS11KeySpec != null) {
            SessionInfo sessionInfo = session.getSessionInfo();
            Token token = session.getToken();
            State state = sessionInfo.getState();
            boolean bl2 = state.equals(State.RO_USER_FUNCTIONS) || state.equals(State.RW_USER_FUNCTIONS);
            bl = token.equals(this.tokenManager_.getToken()) && sessionInfo.isRwSession() != pKCS11KeySpec.isUseROSession() && bl2 == pKCS11KeySpec.isUseUserSession();
        }
        return bl;
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        return true;
    }

    protected abstract PrivateKey pkcs11GeneratePrivate(KeySpec var1) throws InvalidKeySpecException;

    protected abstract PublicKey pkcs11GeneratePublic(KeySpec var1) throws InvalidKeySpecException;

    protected abstract KeySpec pkcs11GetKeySpec(Key var1, Class var2) throws InvalidKeySpecException;

    protected abstract Key pkcs11TranslateKey(Key var1) throws InvalidKeyException;
}

