/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyfactories;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.ConstructedType;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.ECDSAPrivateKey;
import iaik.pkcs.pkcs11.objects.ECDSAPublicKey;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeyFactory;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import iaik.pkcs.pkcs11.wrapper.Functions;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class EcDsaKeyFactory
extends PKCS11KeyFactory {
    private static final boolean DEBUG = false;
    protected static String KEY_FACTORY_ALGORITHM_NAME = "ECDSA";
    protected static final ObjectID OBJECT_ID_EC_KEY = new ObjectID("1.2.840.10045.2.1");
    protected static final AlgorithmID EC_ALGORITHM_ID = new AlgorithmID(OBJECT_ID_EC_KEY);
    public static final INTEGER EC_PRIVATE_KEY_VERSION = new INTEGER(1);
    static /* synthetic */ Class class$java$security$spec$X509EncodedKeySpec;
    static /* synthetic */ Class class$java$security$spec$PKCS8EncodedKeySpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected String getSoftwareDelegateAlgorithm() {
        return KEY_FACTORY_ALGORITHM_NAME;
    }

    protected PrivateKey pkcs11GeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        byte[] byArray;
        byte[] byArray2;
        Object object;
        Object object2;
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            throw new IllegalArgumentException("Argument \"keySpec\" must be of instance iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec.");
        }
        this.pkcs11KeySpec_ = (PKCS11KeySpec)keySpec;
        KeySpec keySpec2 = this.pkcs11KeySpec_.getKeySpec();
        Object var3_3 = null;
        if (!(keySpec2 instanceof PKCS8EncodedKeySpec)) {
            throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.PKCS8EncodedKeySpec.");
        }
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = (PKCS8EncodedKeySpec)keySpec2;
        byte[] byArray3 = pKCS8EncodedKeySpec.getEncoded();
        try {
            object2 = new ASN1(byArray3);
            int n2 = ((BigInteger)((ASN1)object2).getComponentAt(0).getValue()).intValue();
            object = new AlgorithmID(((ASN1)object2).getComponentAt(1));
            ASN1Object aSN1Object = ((AlgorithmID)object).getParameter();
            byArray2 = DerCoder.encode(aSN1Object);
            OCTET_STRING oCTET_STRING = (OCTET_STRING)((ASN1)object2).getComponentAt(2);
            SEQUENCE sEQUENCE = (SEQUENCE)DerCoder.decode((byte[])oCTET_STRING.getValue());
            INTEGER iNTEGER = (INTEGER)sEQUENCE.getComponentAt(0);
            if (!iNTEGER.getValue().equals(EC_PRIVATE_KEY_VERSION.getValue())) {
                throw new InvalidKeySpecException("The encoded private key has an invalid version field: " + iNTEGER.toString());
            }
            OCTET_STRING oCTET_STRING2 = (OCTET_STRING)sEQUENCE.getComponentAt(1);
            byArray = (byte[])oCTET_STRING2.getValue();
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw invalidKeySpecException;
        }
        catch (Exception exception) {
            throw new InvalidKeySpecException("The private key spec could not be parsed: " + exception.toString());
        }
        object2 = new ECDSAPrivateKey();
        ((ECDSAPrivateKey)object2).getEcdsaParams().setByteArrayValue(byArray2);
        ((ECDSAPrivateKey)object2).getValue().setByteArrayValue(byArray);
        GenericTemplate genericTemplate = new GenericTemplate();
        genericTemplate.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object2);
        object = this.pkcs11KeySpec_.getKeyTemplate();
        if (object != null) {
            genericTemplate.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object);
        }
        return (PrivateKey)this.createKey(genericTemplate);
    }

    protected PublicKey pkcs11GeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        byte[] byArray;
        byte[] byArray2;
        Object object;
        Object object2;
        Object object3;
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            throw new IllegalArgumentException("Argument \"keySpec\" must be of instance iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec.");
        }
        this.pkcs11KeySpec_ = (PKCS11KeySpec)keySpec;
        KeySpec keySpec2 = this.pkcs11KeySpec_.getKeySpec();
        Object var3_3 = null;
        if (!(keySpec2 instanceof X509EncodedKeySpec)) {
            throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.X509EncodedKeySpec.");
        }
        X509EncodedKeySpec x509EncodedKeySpec = (X509EncodedKeySpec)keySpec2;
        byte[] byArray3 = x509EncodedKeySpec.getEncoded();
        try {
            object3 = new ASN1(byArray3);
            object2 = new AlgorithmID(((ASN1)object3).getComponentAt(0));
            object = ((AlgorithmID)object2).getParameter();
            byArray2 = DerCoder.encode((ASN1Object)object);
            BIT_STRING bIT_STRING = (BIT_STRING)((ASN1)object3).getComponentAt(1);
            OCTET_STRING oCTET_STRING = new OCTET_STRING((byte[])bIT_STRING.getValue());
            byArray = DerCoder.encode(oCTET_STRING);
        }
        catch (Exception exception) {
            throw new InvalidKeySpecException("The public key spec could not be parsed: " + exception.toString());
        }
        object3 = new ECDSAPublicKey();
        ((ECDSAPublicKey)object3).getEcdsaParams().setByteArrayValue(byArray2);
        ((ECDSAPublicKey)object3).getEcPoint().setByteArrayValue(byArray);
        object2 = new GenericTemplate();
        object = this.pkcs11KeySpec_.getKeyTemplate();
        if (object != null) {
            ((GenericTemplate)object2).addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object);
        }
        ((GenericTemplate)object2).addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object3);
        return (PublicKey)this.createKey((iaik.pkcs.pkcs11.objects.Object)object2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected KeySpec pkcs11GetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        byte[] byArray;
        void var3_6;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument \"keySpecClass\" must not be null.");
        }
        Object var3_3 = null;
        if (clazz.equals(class$java$security$spec$X509EncodedKeySpec != null ? class$java$security$spec$X509EncodedKeySpec : (class$java$security$spec$X509EncodedKeySpec = EcDsaKeyFactory.class$("java.security.spec.X509EncodedKeySpec")))) {
            byte[] byArray2;
            if (!(key instanceof IAIKPKCS11PublicKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PublicKey to get an X509EncodedKeySpec.");
            IAIKPKCS11PublicKey iAIKPKCS11PublicKey = (IAIKPKCS11PublicKey)key;
            iaik.pkcs.pkcs11.objects.Key key2 = iAIKPKCS11PublicKey.getKeyObject();
            if (!(key2 instanceof ECDSAPublicKey)) throw new InvalidKeySpecException("This factory does only accept ECDSA keys, but the PKCS#11 key object in the given key is: " + key2);
            ECDSAPublicKey eCDSAPublicKey = (ECDSAPublicKey)key2;
            ByteArrayAttribute byteArrayAttribute = eCDSAPublicKey.getEcdsaParams();
            ByteArrayAttribute byteArrayAttribute2 = eCDSAPublicKey.getEcPoint();
            if (!byteArrayAttribute.isPresent()) {
                throw new IAIKPkcs11Exception("The PKCS#11 ECDSA key object does not possess a ECDSA parameters attribute.");
            }
            if (!byteArrayAttribute2.isPresent()) {
                throw new IAIKPkcs11Exception("The PKCS#11 ECDSA key object does not possess a EC point attribute.");
            }
            try {
                byte[] byArray3 = byteArrayAttribute.getByteArrayValue();
                byte[] byArray4 = byteArrayAttribute2.getByteArrayValue();
                AlgorithmID algorithmID = (AlgorithmID)EC_ALGORITHM_ID.clone();
                ASN1 aSN1 = new ASN1(byArray3);
                algorithmID.setParameter(aSN1.toASN1Object());
                ASN1Object aSN1Object = DerCoder.decode(byArray4);
                if (!aSN1Object.isA(ASN.OCTET_STRING)) {
                    throw new InvalidKeySpecException("The encoded public key value of the PKCS#11 key is no OCTET STRING: " + Functions.toHexString(byArray4));
                }
                ConstructedType constructedType = (OCTET_STRING)aSN1Object;
                BIT_STRING bIT_STRING = new BIT_STRING((byte[])((OCTET_STRING)constructedType).getValue());
                constructedType = new SEQUENCE();
                constructedType.addComponent(algorithmID.toASN1Object());
                constructedType.addComponent(bIT_STRING);
                byArray2 = DerCoder.encode(constructedType);
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException("Error during encoding of ECDSA public key: " + exception.toString());
            }
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray2);
            return var3_6;
        }
        if (!clazz.equals(class$java$security$spec$PKCS8EncodedKeySpec != null ? class$java$security$spec$PKCS8EncodedKeySpec : (class$java$security$spec$PKCS8EncodedKeySpec = EcDsaKeyFactory.class$("java.security.spec.PKCS8EncodedKeySpec")))) throw new InvalidKeySpecException("The given key spec class is invalid. It must be of either X509EncodedKeySpec or PKCS8EncodedKeySpec.");
        if (!(key instanceof IAIKPKCS11PrivateKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PrivateKey to get a PKCS8EncodedKeySpec.");
        IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)key;
        iaik.pkcs.pkcs11.objects.Key key3 = iAIKPKCS11PrivateKey.getKeyObject();
        if (!(key3 instanceof ECDSAPrivateKey)) throw new InvalidKeySpecException("This factory does only accept ECDSA keys, but the PKCS#11 key object in the given key is: " + key3);
        ECDSAPrivateKey eCDSAPrivateKey = (ECDSAPrivateKey)key3;
        ByteArrayAttribute byteArrayAttribute = eCDSAPrivateKey.getEcdsaParams();
        ByteArrayAttribute byteArrayAttribute3 = eCDSAPrivateKey.getValue();
        if (!byteArrayAttribute.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 ECDSA key object does not possess a ECDSA parameters attribute.");
        }
        if (!byteArrayAttribute3.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 ECDSA key object does not possess a EC point attribute.");
        }
        try {
            byte[] byArray5 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray6 = byteArrayAttribute3.getByteArrayValue();
            AlgorithmID algorithmID = (AlgorithmID)EC_ALGORITHM_ID.clone();
            ASN1 aSN1 = new ASN1(byArray5);
            algorithmID.setParameter(aSN1.toASN1Object());
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(0));
            sEQUENCE.addComponent(algorithmID.toASN1Object());
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(EC_PRIVATE_KEY_VERSION);
            sEQUENCE2.addComponent(new OCTET_STRING(byArray6));
            OCTET_STRING oCTET_STRING = new OCTET_STRING(DerCoder.encode(sEQUENCE2));
            sEQUENCE.addComponent(oCTET_STRING);
            byArray = DerCoder.encode(sEQUENCE);
        }
        catch (Exception exception) {
            throw new InvalidKeySpecException("Error during encoding of ECDSA private key: " + exception.toString());
        }
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        return var3_6;
    }

    protected Key pkcs11TranslateKey(Key key) throws InvalidKeyException {
        throw new UnsupportedOperationException("This method is unsupported by this factory.");
    }
}

