/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyfactories;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DSAPrivateKey;
import iaik.pkcs.pkcs11.objects.DSAPublicKey;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeyFactory;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class DsaKeyFactory
extends PKCS11KeyFactory {
    private static final boolean DEBUG = false;
    protected static String KEY_FACTORY_ALGORITHM_NAME = "DSA";
    static /* synthetic */ Class class$java$security$spec$DSAPublicKeySpec;
    static /* synthetic */ Class class$java$security$spec$DSAPrivateKeySpec;
    static /* synthetic */ Class class$java$security$spec$X509EncodedKeySpec;
    static /* synthetic */ Class class$java$security$spec$PKCS8EncodedKeySpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected String getSoftwareDelegateAlgorithm() {
        return KEY_FACTORY_ALGORITHM_NAME;
    }

    protected PrivateKey pkcs11GeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        Object object;
        Object object2;
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4;
        Object object3;
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            throw new IllegalArgumentException("Argument \"keySpec\" must be of instance iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec.");
        }
        this.pkcs11KeySpec_ = (PKCS11KeySpec)keySpec;
        KeySpec keySpec2 = this.pkcs11KeySpec_.getKeySpec();
        Object var7_3 = null;
        if (keySpec2 instanceof DSAPrivateKeySpec) {
            object3 = (DSAPrivateKeySpec)keySpec2;
            byArray4 = Util.unsignedBigIntergerToByteArray(((DSAPrivateKeySpec)object3).getG());
            byArray3 = Util.unsignedBigIntergerToByteArray(((DSAPrivateKeySpec)object3).getP());
            byArray2 = Util.unsignedBigIntergerToByteArray(((DSAPrivateKeySpec)object3).getQ());
            byArray = Util.unsignedBigIntergerToByteArray(((DSAPrivateKeySpec)object3).getX());
        } else if (keySpec2 instanceof PKCS8EncodedKeySpec) {
            BigInteger bigInteger;
            BigInteger bigInteger2;
            BigInteger bigInteger3;
            object3 = (PKCS8EncodedKeySpec)keySpec2;
            object2 = ((PKCS8EncodedKeySpec)object3).getEncoded();
            try {
                ASN1 aSN1 = new ASN1((byte[])object2);
                int n2 = ((BigInteger)aSN1.getComponentAt(0).getValue()).intValue();
                AlgorithmID algorithmID = new AlgorithmID(aSN1.getComponentAt(1));
                byte[] byArray5 = (byte[])aSN1.getComponentAt(2).getValue();
                ASN1 aSN12 = new ASN1(byArray5);
                object = (BigInteger)aSN12.toASN1Object().getValue();
                ASN1Object aSN1Object = algorithmID.getParameter();
                if (aSN1Object != null && !aSN1Object.isA(ASN.NULL)) {
                    if (!aSN1Object.isA(ASN.SEQUENCE)) {
                        throw new InvalidKeySpecException("The private key spec could not be parsed. The key parameters are no ASN.1 SEQUENCE.");
                    }
                    if (aSN1Object.countComponents() < 3) {
                        throw new InvalidKeySpecException("The private key spec could not be parsed. The key parameters do not have 3 components.");
                    }
                } else {
                    throw new InvalidKeySpecException("The private key spec does not contain key parameters, which are required by this key factory.");
                }
                bigInteger3 = (BigInteger)aSN1Object.getComponentAt(0).getValue();
                bigInteger2 = (BigInteger)aSN1Object.getComponentAt(1).getValue();
                bigInteger = (BigInteger)aSN1Object.getComponentAt(2).getValue();
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("The private key spec could not be parsed: " + codingException.toString());
            }
            byArray4 = Util.unsignedBigIntergerToByteArray(bigInteger);
            byArray3 = Util.unsignedBigIntergerToByteArray(bigInteger3);
            byArray2 = Util.unsignedBigIntergerToByteArray(bigInteger2);
            byArray = Util.unsignedBigIntergerToByteArray((BigInteger)object);
        } else {
            throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.DSAPrivateKeySpec.");
        }
        object3 = new DSAPrivateKey();
        ((DSAPrivateKey)object3).getBase().setByteArrayValue(byArray4);
        ((DSAPrivateKey)object3).getPrime().setByteArrayValue(byArray3);
        ((DSAPrivateKey)object3).getSubprime().setByteArrayValue(byArray2);
        ((DSAPrivateKey)object3).getValue().setByteArrayValue(byArray);
        object2 = new GenericTemplate();
        ((GenericTemplate)object2).addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object3);
        object = this.pkcs11KeySpec_.getKeyTemplate();
        if (object != null) {
            ((GenericTemplate)object2).addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object);
        }
        return (PrivateKey)this.createKey((iaik.pkcs.pkcs11.objects.Object)object2);
    }

    protected PublicKey pkcs11GeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        Object object;
        Object object2;
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4;
        Object object3;
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            throw new IllegalArgumentException("Argument \"keySpec\" must be of instance iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec.");
        }
        this.pkcs11KeySpec_ = (PKCS11KeySpec)keySpec;
        KeySpec keySpec2 = this.pkcs11KeySpec_.getKeySpec();
        Object var7_3 = null;
        if (keySpec2 instanceof DSAPublicKeySpec) {
            object3 = (DSAPublicKeySpec)keySpec2;
            byArray4 = Util.unsignedBigIntergerToByteArray(((DSAPublicKeySpec)object3).getG());
            byArray3 = Util.unsignedBigIntergerToByteArray(((DSAPublicKeySpec)object3).getP());
            byArray2 = Util.unsignedBigIntergerToByteArray(((DSAPublicKeySpec)object3).getQ());
            byArray = Util.unsignedBigIntergerToByteArray(((DSAPublicKeySpec)object3).getY());
        } else if (keySpec2 instanceof X509EncodedKeySpec) {
            BigInteger bigInteger;
            BigInteger bigInteger2;
            BigInteger bigInteger3;
            object3 = (X509EncodedKeySpec)keySpec2;
            object2 = ((X509EncodedKeySpec)object3).getEncoded();
            try {
                ASN1 aSN1 = new ASN1((byte[])object2);
                AlgorithmID algorithmID = new AlgorithmID(aSN1.getComponentAt(0));
                byte[] byArray5 = (byte[])aSN1.getComponentAt(1).getValue();
                ASN1 aSN12 = new ASN1(byArray5);
                object = (BigInteger)aSN12.toASN1Object().getValue();
                ASN1Object aSN1Object = algorithmID.getParameter();
                if (aSN1Object != null && !aSN1Object.isA(ASN.NULL)) {
                    if (!aSN1Object.isA(ASN.SEQUENCE)) {
                        throw new InvalidKeySpecException("The public key spec could not be parsed. The key parameters are no ASN.1 SEQUENCE.");
                    }
                    if (aSN1Object.countComponents() < 3) {
                        throw new InvalidKeySpecException("The public key spec could not be parsed. The key parameters do not have 3 components.");
                    }
                } else {
                    throw new InvalidKeySpecException("The public key spec does not contain key parameters, which are required by this key factory.");
                }
                bigInteger3 = (BigInteger)aSN1Object.getComponentAt(0).getValue();
                bigInteger2 = (BigInteger)aSN1Object.getComponentAt(1).getValue();
                bigInteger = (BigInteger)aSN1Object.getComponentAt(2).getValue();
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("The public key spec could not be parsed: " + codingException.toString());
            }
            byArray4 = Util.unsignedBigIntergerToByteArray(bigInteger);
            byArray3 = Util.unsignedBigIntergerToByteArray(bigInteger3);
            byArray2 = Util.unsignedBigIntergerToByteArray(bigInteger2);
            byArray = Util.unsignedBigIntergerToByteArray((BigInteger)object);
        } else {
            throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.DSAPublicKeySpec.");
        }
        object3 = new DSAPublicKey();
        ((DSAPublicKey)object3).getBase().setByteArrayValue(byArray4);
        ((DSAPublicKey)object3).getPrime().setByteArrayValue(byArray3);
        ((DSAPublicKey)object3).getSubprime().setByteArrayValue(byArray2);
        ((DSAPublicKey)object3).getValue().setByteArrayValue(byArray);
        object2 = new GenericTemplate();
        ((GenericTemplate)object2).addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object3);
        object = this.pkcs11KeySpec_.getKeyTemplate();
        if (object != null) {
            ((GenericTemplate)object2).addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object);
        }
        return (PublicKey)this.createKey((iaik.pkcs.pkcs11.objects.Object)object2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected KeySpec pkcs11GetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        byte[] byArray;
        void var3_8;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument \"keySpecClass\" must not be null.");
        }
        Object var3_3 = null;
        if (clazz.equals(class$java$security$spec$DSAPublicKeySpec != null ? class$java$security$spec$DSAPublicKeySpec : (class$java$security$spec$DSAPublicKeySpec = DsaKeyFactory.class$("java.security.spec.DSAPublicKeySpec")))) {
            if (!(key instanceof IAIKPKCS11PublicKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PublicKeyto get a DSAPublicKeySpec.");
            IAIKPKCS11PublicKey iAIKPKCS11PublicKey = (IAIKPKCS11PublicKey)key;
            iaik.pkcs.pkcs11.objects.Key key2 = iAIKPKCS11PublicKey.getKeyObject();
            if (!(key2 instanceof DSAPublicKey)) throw new InvalidKeySpecException("This factory does only accept DSA keys, but the PKCS#11 key objectin the given key is: " + key2);
            DSAPublicKey dSAPublicKey = (DSAPublicKey)key2;
            this.verifyPublicKeyExtractable(dSAPublicKey);
            ByteArrayAttribute byteArrayAttribute = dSAPublicKey.getBase();
            ByteArrayAttribute byteArrayAttribute2 = dSAPublicKey.getPrime();
            ByteArrayAttribute byteArrayAttribute3 = dSAPublicKey.getSubprime();
            ByteArrayAttribute byteArrayAttribute4 = dSAPublicKey.getValue();
            byte[] byArray2 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray3 = byteArrayAttribute2.getByteArrayValue();
            byte[] byArray4 = byteArrayAttribute3.getByteArrayValue();
            byte[] byArray5 = byteArrayAttribute4.getByteArrayValue();
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(new BigInteger(1, byArray5), new BigInteger(1, byArray3), new BigInteger(1, byArray4), new BigInteger(1, byArray2));
            return var3_8;
        }
        if (clazz.equals(class$java$security$spec$DSAPrivateKeySpec != null ? class$java$security$spec$DSAPrivateKeySpec : (class$java$security$spec$DSAPrivateKeySpec = DsaKeyFactory.class$("java.security.spec.DSAPrivateKeySpec")))) {
            if (!(key instanceof IAIKPKCS11PrivateKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PrivateKey to get a DSAPrivateKeySpec.");
            IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)key;
            iaik.pkcs.pkcs11.objects.Key key3 = iAIKPKCS11PrivateKey.getKeyObject();
            if (!(key3 instanceof DSAPrivateKey)) throw new InvalidKeySpecException("This factory does only accept DSA keys, but the PKCS#11 key object in the given key is: " + key3);
            DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)key3;
            this.verifyPrivateKeyExtractable(dSAPrivateKey);
            ByteArrayAttribute byteArrayAttribute = dSAPrivateKey.getBase();
            ByteArrayAttribute byteArrayAttribute5 = dSAPrivateKey.getPrime();
            ByteArrayAttribute byteArrayAttribute6 = dSAPrivateKey.getSubprime();
            ByteArrayAttribute byteArrayAttribute7 = dSAPrivateKey.getValue();
            byte[] byArray6 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray7 = byteArrayAttribute5.getByteArrayValue();
            byte[] byArray8 = byteArrayAttribute6.getByteArrayValue();
            byte[] byArray9 = byteArrayAttribute7.getByteArrayValue();
            DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(new BigInteger(1, byArray9), new BigInteger(1, byArray7), new BigInteger(1, byArray8), new BigInteger(1, byArray6));
            return var3_8;
        }
        if (clazz.equals(class$java$security$spec$X509EncodedKeySpec != null ? class$java$security$spec$X509EncodedKeySpec : (class$java$security$spec$X509EncodedKeySpec = DsaKeyFactory.class$("java.security.spec.X509EncodedKeySpec")))) {
            byte[] byArray10;
            if (!(key instanceof IAIKPKCS11PublicKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PublicKey to get a X509EncodedKeySpec.");
            IAIKPKCS11PublicKey iAIKPKCS11PublicKey = (IAIKPKCS11PublicKey)key;
            iaik.pkcs.pkcs11.objects.Key key4 = iAIKPKCS11PublicKey.getKeyObject();
            if (!(key4 instanceof DSAPublicKey)) throw new InvalidKeySpecException("This factory does only accept RSA keys, but the PKCS#11 key object in the given key is: " + key4);
            DSAPublicKey dSAPublicKey = (DSAPublicKey)key4;
            this.verifyPublicKeyExtractable(dSAPublicKey);
            ByteArrayAttribute byteArrayAttribute = dSAPublicKey.getBase();
            ByteArrayAttribute byteArrayAttribute8 = dSAPublicKey.getPrime();
            ByteArrayAttribute byteArrayAttribute9 = dSAPublicKey.getSubprime();
            ByteArrayAttribute byteArrayAttribute10 = dSAPublicKey.getValue();
            byte[] byArray11 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray12 = byteArrayAttribute8.getByteArrayValue();
            byte[] byArray13 = byteArrayAttribute9.getByteArrayValue();
            byte[] byArray14 = byteArrayAttribute10.getByteArrayValue();
            try {
                AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.dsa.clone();
                ASN1 aSN1 = new ASN1(new INTEGER(new BigInteger(1, byArray14)));
                byte[] byArray15 = aSN1.toByteArray();
                SEQUENCE sEQUENCE = new SEQUENCE();
                sEQUENCE.addComponent(new INTEGER(new BigInteger(1, byArray12)));
                sEQUENCE.addComponent(new INTEGER(new BigInteger(1, byArray13)));
                sEQUENCE.addComponent(new INTEGER(new BigInteger(1, byArray11)));
                algorithmID.setParameter(sEQUENCE);
                SEQUENCE sEQUENCE2 = new SEQUENCE();
                sEQUENCE2.addComponent(algorithmID.toASN1Object());
                sEQUENCE2.addComponent(new BIT_STRING(byArray15));
                byArray10 = DerCoder.encode(sEQUENCE2);
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("Error during encoding of RSA public key: " + codingException.toString());
            }
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray10);
            return var3_8;
        }
        if (!clazz.equals(class$java$security$spec$PKCS8EncodedKeySpec != null ? class$java$security$spec$PKCS8EncodedKeySpec : (class$java$security$spec$PKCS8EncodedKeySpec = DsaKeyFactory.class$("java.security.spec.PKCS8EncodedKeySpec")))) throw new InvalidKeySpecException("The given key spec class is invalid. It must be of either DSAPublicKeySpec, X509EncodedKeySpec, DSAPrivateKeySpec or PKCS8EncodedKeySpec.");
        if (!(key instanceof IAIKPKCS11PrivateKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PrivateKey to get a PKCS8EncodedKeySpec.");
        IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)key;
        iaik.pkcs.pkcs11.objects.Key key5 = iAIKPKCS11PrivateKey.getKeyObject();
        if (!(key5 instanceof DSAPrivateKey)) throw new InvalidKeySpecException("This factory does only accept RSA keys, but the PKCS#11 key object in the given key is: " + key5);
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)key5;
        this.verifyPrivateKeyExtractable(dSAPrivateKey);
        ByteArrayAttribute byteArrayAttribute = dSAPrivateKey.getBase();
        ByteArrayAttribute byteArrayAttribute11 = dSAPrivateKey.getPrime();
        ByteArrayAttribute byteArrayAttribute12 = dSAPrivateKey.getSubprime();
        ByteArrayAttribute byteArrayAttribute13 = dSAPrivateKey.getValue();
        byte[] byArray16 = byteArrayAttribute.getByteArrayValue();
        byte[] byArray17 = byteArrayAttribute11.getByteArrayValue();
        byte[] byArray18 = byteArrayAttribute12.getByteArrayValue();
        byte[] byArray19 = byteArrayAttribute13.getByteArrayValue();
        try {
            AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
            ASN1 aSN1 = new ASN1(new INTEGER(new BigInteger(1, byArray19)));
            byte[] byArray20 = aSN1.toByteArray();
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(new BigInteger(1, byArray17)));
            sEQUENCE.addComponent(new INTEGER(new BigInteger(1, byArray18)));
            sEQUENCE.addComponent(new INTEGER(new BigInteger(1, byArray16)));
            algorithmID.setParameter(sEQUENCE);
            SEQUENCE sEQUENCE3 = new SEQUENCE();
            sEQUENCE3.addComponent(new INTEGER(0));
            sEQUENCE3.addComponent(algorithmID.toASN1Object());
            sEQUENCE3.addComponent(new OCTET_STRING(byArray20));
            byArray = DerCoder.encode(sEQUENCE3);
        }
        catch (CodingException codingException) {
            throw new InvalidKeySpecException("Error during encoding of RSA private key: " + codingException.toString());
        }
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        return var3_8;
    }

    protected Key pkcs11TranslateKey(Key key) throws InvalidKeyException {
        throw new UnsupportedOperationException("This method is unsupported by this factory.");
    }

    protected void verifyPrivateKeyExtractable(DSAPrivateKey dSAPrivateKey) throws IAIKPkcs11Exception {
        ByteArrayAttribute byteArrayAttribute = dSAPrivateKey.getBase();
        ByteArrayAttribute byteArrayAttribute2 = dSAPrivateKey.getPrime();
        ByteArrayAttribute byteArrayAttribute3 = dSAPrivateKey.getSubprime();
        ByteArrayAttribute byteArrayAttribute4 = dSAPrivateKey.getValue();
        if (!byteArrayAttribute.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object does not possess a base attribute.");
        }
        if (!byteArrayAttribute2.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object does not possess a prime attribute.");
        }
        if (!byteArrayAttribute3.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object does not possess a subprime attribute.");
        }
        if (!byteArrayAttribute4.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object does not possess a value attribute.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object's base attribute is sensitive.");
        }
        if (byteArrayAttribute2.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object's prime attribute is sensitive.");
        }
        if (byteArrayAttribute3.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object's subprime attribute is sensitive.");
        }
        if (byteArrayAttribute4.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object's value attribute is sensitive.");
        }
    }

    protected void verifyPublicKeyExtractable(DSAPublicKey dSAPublicKey) throws IAIKPkcs11Exception {
        ByteArrayAttribute byteArrayAttribute = dSAPublicKey.getBase();
        ByteArrayAttribute byteArrayAttribute2 = dSAPublicKey.getPrime();
        ByteArrayAttribute byteArrayAttribute3 = dSAPublicKey.getSubprime();
        ByteArrayAttribute byteArrayAttribute4 = dSAPublicKey.getValue();
        if (!byteArrayAttribute.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object does not possess a base attribute.");
        }
        if (!byteArrayAttribute2.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object does not possess a prime attribute.");
        }
        if (!byteArrayAttribute3.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object does not possess a subprime attribute.");
        }
        if (!byteArrayAttribute4.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object does not possess a value attribute.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object's base attribute is sensitive.");
        }
        if (byteArrayAttribute2.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object's prime attribute is sensitive.");
        }
        if (byteArrayAttribute3.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object's subprime attribute is sensitive.");
        }
        if (byteArrayAttribute4.isSensitive()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object's value attribute is sensitive.");
        }
    }
}

