/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyfactories;

import iaik.pkcs.pkcs11.objects.DES2SecretKey;
import iaik.pkcs.pkcs11.objects.DES3SecretKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keyfactories.SecretKeyFactory;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class DesEdeKeyFactory
extends SecretKeyFactory {
    private static final boolean DEBUG = false;
    protected static final String ALGORITHM_NAME = "DESede";
    static /* synthetic */ Class class$javax$crypto$spec$SecretKeySpec;
    static /* synthetic */ Class class$javax$crypto$spec$DESedeKeySpec;
    static /* synthetic */ Class class$iaik$pkcs$pkcs11$provider$keyfactories$PKCS11KeySpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected iaik.pkcs.pkcs11.objects.Object createKeyCreationTemplate(KeySpec keySpec) throws InvalidKeySpecException {
        SecretKey secretKey;
        byte[] byArray;
        this.validateKeySpec(keySpec);
        if (keySpec instanceof SecretKeySpec) {
            byArray = ((SecretKeySpec)keySpec).getEncoded();
        } else if (keySpec instanceof DESedeKeySpec) {
            byArray = ((DESedeKeySpec)keySpec).getKey();
        } else {
            throw new InvalidKeySpecException("The given key spec is invalid. It must be either aSecretKeySpec or a DESedeKeySpec.");
        }
        if (byArray.length == 16) {
            DES2SecretKey dES2SecretKey = new DES2SecretKey();
            dES2SecretKey.getValue().setByteArrayValue(byArray);
            secretKey = dES2SecretKey;
        } else {
            DES3SecretKey dES3SecretKey = new DES3SecretKey();
            dES3SecretKey.getValue().setByteArrayValue(byArray);
            secretKey = dES3SecretKey;
        }
        return secretKey;
    }

    protected String getAlgorithmName() {
        return ALGORITHM_NAME;
    }

    protected boolean isAlgorithmAccepted(String string) {
        return string != null && string.equalsIgnoreCase(ALGORITHM_NAME);
    }

    protected KeySpec pkcs11GetKeySpec(javax.crypto.SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        KeySpec keySpec;
        if (secretKey == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument \"keySpecClass\" must not be null.");
        }
        if (!(secretKey instanceof IAIKPKCS11SecretKey)) {
            throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11SecretKey.");
        }
        IAIKPKCS11SecretKey iAIKPKCS11SecretKey = (IAIKPKCS11SecretKey)secretKey;
        Key key = iAIKPKCS11SecretKey.getKeyObject();
        byte[] byArray = this.extractKeyMaterial(key);
        if (clazz.equals(class$javax$crypto$spec$SecretKeySpec != null ? class$javax$crypto$spec$SecretKeySpec : (class$javax$crypto$spec$SecretKeySpec = DesEdeKeyFactory.class$("javax.crypto.spec.SecretKeySpec")))) {
            keySpec = new SecretKeySpec(byArray, this.getAlgorithmName());
        } else if (clazz.equals(class$javax$crypto$spec$DESedeKeySpec != null ? class$javax$crypto$spec$DESedeKeySpec : (class$javax$crypto$spec$DESedeKeySpec = DesEdeKeyFactory.class$("javax.crypto.spec.DESedeKeySpec")))) {
            try {
                keySpec = new DESedeKeySpec(byArray);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidKeySpecException("The key value of the given spec is invalid: " + invalidKeyException.toString());
            }
        } else if (clazz.equals(class$iaik$pkcs$pkcs11$provider$keyfactories$PKCS11KeySpec != null ? class$iaik$pkcs$pkcs11$provider$keyfactories$PKCS11KeySpec : (class$iaik$pkcs$pkcs11$provider$keyfactories$PKCS11KeySpec = DesEdeKeyFactory.class$("iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec")))) {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, this.getAlgorithmName());
            boolean bl = key.getPrivate().getBooleanValue();
            keySpec = new PKCS11KeySpec(secretKeySpec, iAIKPKCS11SecretKey.getTokenManager(), null, bl ^ true, bl);
        } else {
            throw new InvalidKeySpecException("The given key spec class is invalid. It must be of eitherSecretKeySpec or DESedeKeySpec.");
        }
        return keySpec;
    }

    protected void validateKeySpec(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (keySpec instanceof SecretKeySpec) {
            SecretKeySpec secretKeySpec = (SecretKeySpec)keySpec;
            String string = secretKeySpec.getAlgorithm();
            if (!this.isAlgorithmAccepted(string)) {
                throw new InvalidKeySpecException("The algorithm of the given spec is unsupported: " + string);
            }
            String string2 = secretKeySpec.getAlgorithm();
            if (!this.isFormatAccepted(string2)) {
                throw new InvalidKeySpecException("The format of the key encoding of the given spec is unsupported: " + string2);
            }
        } else if (!(keySpec instanceof DESedeKeySpec)) {
            throw new InvalidKeySpecException("The key spec must be of type javax.crypto.spec.SecretKeySpec.");
        }
    }
}

