/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyagreements;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.objects.DHPrivateKey;
import iaik.pkcs.pkcs11.objects.DHPublicKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.parameters.DHPkcsDeriveParameters;
import iaik.pkcs.pkcs11.provider.keyagreements.PKCS11KeyAgreement;
import java.security.InvalidKeyException;

public class DhKeyAgreement
extends PKCS11KeyAgreement {
    private static final boolean DEBUG = false;
    protected static String KEY_AGREEEMENT_ALGORITHM_NAME = "DiffieHellman";
    protected Mechanism mechanism_;

    protected void checkInitKeyObject(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("key must be of instance DHPrivateKey.");
        }
    }

    protected void checkPhaseKeyObject(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (!(key instanceof DHPublicKey)) {
            throw new InvalidKeyException("key must be of instance DHPublicKey.");
        }
    }

    protected String getAlgorithmName() {
        return KEY_AGREEEMENT_ALGORITHM_NAME;
    }

    protected Mechanism getMechanism() {
        if (this.keyAgreementSpecChanged_) {
            Mechanism mechanism = (Mechanism)Mechanism.DH_PKCS_DERIVE.clone();
            if (this.phaseKeyObject_ != null) {
                DHPublicKey dHPublicKey = (DHPublicKey)this.phaseKeyObject_;
                byte[] byArray = dHPublicKey.getValue().getByteArrayValue();
                DHPkcsDeriveParameters dHPkcsDeriveParameters = new DHPkcsDeriveParameters(byArray);
                mechanism.setParameters(dHPkcsDeriveParameters);
            }
            this.mechanism_ = mechanism;
            this.keyAgreementSpecChanged_ = false;
        }
        return this.mechanism_;
    }

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            this.usedMechanisms_ = new Mechanism[]{Mechanism.DH_PKCS_DERIVE};
        }
        return this.usedMechanisms_;
    }
}

