/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.hashes;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import java.security.MessageDigest;

public abstract class PKCS11Hash
extends MessageDigest
implements PKCS11EngineClass {
    private static final boolean DEBUG = false;
    protected TokenManager tokenManager_;
    protected Session session_;
    protected int hashValueLength_;
    protected Mechanism mechanism_;
    protected Mechanism[] usedMechanisms_;
    protected MechanismInfo[][] usedMechanismInfos_;
    protected boolean initialized_;
    protected boolean pkcs11OperationInitialized_;
    protected boolean useSoftwareDelegate_;
    protected MessageDigest softwareDelegate_;

    protected PKCS11Hash(String string, int n2, Mechanism mechanism) {
        super(string);
        if (n2 < 0) {
            throw new NullPointerException("Argument \"hashValueLength\" must be >= 0.");
        }
        if (mechanism == null) {
            throw new NullPointerException("Argument \"mechanism\" must not be null.");
        }
        this.hashValueLength_ = n2;
        this.mechanism_ = mechanism;
    }

    protected byte[] engineDigest() {
        if (!this.initialized_) {
            this.initialize();
        }
        byte[] byArray = null;
        if (this.useSoftwareDelegate_) {
            byArray = this.softwareDelegate_.digest();
        } else {
            try {
                try {
                    byArray = this.session_.digestFinal();
                    this.pkcs11OperationInitialized_ = false;
                }
                catch (TokenException tokenException) {
                    throw new IAIKPkcs11Exception("Error updating digest: " + tokenException);
                }
                Object var3_3 = null;
                this.finalizePkcs11Operation();
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.finalizePkcs11Operation();
                throw throwable;
            }
        }
        return byArray;
    }

    protected int engineGetDigestLength() {
        int n2 = this.useSoftwareDelegate_ ? this.softwareDelegate_.getDigestLength() : this.hashValueLength_;
        return n2;
    }

    protected void engineReset() {
        if (this.useSoftwareDelegate_) {
            if (!this.initialized_) {
                this.initialize();
            }
            this.softwareDelegate_.reset();
        } else if (!this.initialized_) {
            this.initialize();
        } else {
            this.finalizePkcs11Operation();
            try {
                this.initializePkcs11Operation();
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception("Error initializing the PKCS#11 digest: " + tokenException.toString());
            }
        }
    }

    protected void engineUpdate(byte by) {
        if (!this.initialized_) {
            this.initialize();
        }
        if (this.useSoftwareDelegate_) {
            this.softwareDelegate_.update(by);
        } else {
            if (!this.pkcs11OperationInitialized_) {
                try {
                    this.initializePkcs11Operation();
                }
                catch (TokenException tokenException) {
                    throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 hash for next operation: " + tokenException.toString());
                }
            }
            byte[] byArray = new byte[]{by};
            try {
                this.session_.digestUpdate(byArray);
            }
            catch (TokenException tokenException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Error updating digest: " + tokenException);
            }
        }
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"data\" must not be null.");
        }
        if (n2 + n3 > byArray.length) {
            throw new IllegalArgumentException("Arguments must satisfy ((offset + length) <= data.length).");
        }
        if (!this.initialized_) {
            this.initialize();
        }
        if (this.useSoftwareDelegate_) {
            this.softwareDelegate_.update(byArray, n2, n3);
        } else {
            if (!this.pkcs11OperationInitialized_) {
                try {
                    this.initializePkcs11Operation();
                }
                catch (TokenException tokenException) {
                    throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 hash for next operation: " + tokenException.toString());
                }
            }
            byte[] byArray2 = null;
            if (n2 == 0 && n3 == byArray.length) {
                byArray2 = byArray;
            } else {
                byArray2 = new byte[n3];
                System.arraycopy(byArray, n2, byArray2, 0, n3);
            }
            try {
                this.session_.digestUpdate(byArray2);
            }
            catch (TokenException tokenException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Error updating digest: " + tokenException);
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.session_ != null) {
            this.tokenManager_.disposeSession(this.session_);
        }
        super.finalize();
    }

    protected void finalizePkcs11Operation() {
        if (this.pkcs11OperationInitialized_) {
            try {
                this.session_.digestFinal();
            }
            catch (TokenException tokenException) {
                // empty catch block
            }
        }
        this.pkcs11OperationInitialized_ = false;
        this.tokenManager_.disposeSession(this.session_);
        this.session_ = null;
    }

    public TokenManager getTokenManager() {
        return this.tokenManager_;
    }

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setDigest(true);
            this.usedMechanismInfos_ = new MechanismInfo[][]{{mechanismInfo}};
        }
        return this.usedMechanismInfos_;
    }

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            this.usedMechanisms_ = new Mechanism[]{this.mechanism_};
        }
        return this.usedMechanisms_;
    }

    protected void initialize() {
        block4: {
            IAIKPkcs11 iAIKPkcs11 = (IAIKPkcs11)this.getProvider();
            this.tokenManager_ = iAIKPkcs11.getTokenManager();
            try {
                if (this.isSupportedBy(this.tokenManager_)) {
                    this.initializePkcs11Operation();
                    this.useSoftwareDelegate_ = false;
                    break block4;
                }
                if (IAIKPkcs11.isEnableSoftwareDelegation()) {
                    this.initializeSoftwareDelegate();
                    this.useSoftwareDelegate_ = true;
                    break block4;
                }
                throw new IAIKPkcs11Exception("Software delegation is disabled and the current token does not support: " + this.mechanism_.toString());
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception("Error initializing the PKCS#11 digest: " + tokenException.toString());
            }
        }
        this.initialized_ = true;
    }

    protected void initializePkcs11Operation() throws TokenException {
        this.initializeSession();
        this.session_.digestInit(this.mechanism_);
        this.pkcs11OperationInitialized_ = true;
    }

    protected void initializeSession() throws TokenException {
        if (this.session_ == null) {
            this.session_ = this.tokenManager_.getSession(false);
        }
        this.tokenManager_.makeAuthorizedSession(this.session_, null);
    }

    protected void initializeSoftwareDelegate() {
        DelegateProvider delegateProvider = this.tokenManager_ != null ? this.tokenManager_.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.getAlgorithm();
        this.softwareDelegate_ = delegateProvider.getMessageDigest(string);
        if (this.softwareDelegate_ == null) {
            throw new IAIKPkcs11Exception("Could not get delegate message digest engine for " + string);
        }
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            Mechanism[] mechanismArray = this.getUsedMechanisms();
            MechanismInfo[][] mechanismInfoArray = this.getUsedMechanismFeatures();
            bl = tokenManager.isMechanismFeatureSupported(mechanismArray, mechanismInfoArray);
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    public void setTokenManager(TokenManager tokenManager) {
        if (tokenManager == null) {
            throw new NullPointerException("Argument \"tokenManager\" must not be null.");
        }
        this.tokenManager_ = tokenManager;
        if (!this.initialized_) {
            this.initialize();
        }
    }
}

