/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.ciphers;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.parameters.RSAPkcsOaepParameters;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.ciphers.PKCS11Cipher;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import java.io.ByteArrayOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class RsaCipher
extends PKCS11Cipher {
    private static final boolean DEBUG = false;
    protected static final String CIPHER_NAME = "RSA";
    protected static final String DEFAULT_MODE = "ecb";
    protected static final String DEFAULT_PADDING = "pkcs1padding";
    protected static final Mechanism DEFAULT_MECHANISM = Mechanism.RSA_PKCS;
    protected static final int PKCS11_OPERATION_SIGN_VERIFY = 1;
    protected static final int PKCS11_OPERATION_ENCRYPT_DECRYPT = 2;
    protected Hashtable modePaddingMechanisms_ = this.getModePaddingMechanisms();
    protected static Vector supportedModes_;
    protected static Vector supportedPaddings_;
    protected static Hashtable cipherModePaddingMechansims_;
    protected int pkcs11Operation_;
    protected ByteArrayOutputStream buffer_;

    public RsaCipher() {
        this.mode_ = this.getDefaultMode();
        this.padding_ = this.getDefaultPadding();
        this.buffer_ = new ByteArrayOutputStream(128);
    }

    protected void checkKeyObject(iaik.pkcs.pkcs11.objects.Key key) throws InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null.");
        }
        if (!(key instanceof iaik.pkcs.pkcs11.objects.RSAPrivateKey) && !(key instanceof RSAPublicKey)) {
            throw new InvalidKeyException("PKCS#11 key object inside IAIKPKCS11Key must be of type RSA");
        }
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        int n2;
        if (key instanceof IAIKPKCS11Key) {
            n2 = this.pkcs11GetKeySize(key);
        } else if (key instanceof RSAPrivateKey) {
            n2 = ((RSAPrivateKey)key).getModulus().bitLength();
        } else if (key instanceof java.security.interfaces.RSAPublicKey) {
            n2 = ((java.security.interfaces.RSAPublicKey)key).getModulus().bitLength();
        } else {
            throw new UnsupportedOperationException("Cannot determine size of software key. Key is not a RSA key. Key is of class: " + (key != null ? key.getClass().toString() : "null"));
        }
        return n2;
    }

    protected String getAlgorithmName() {
        return CIPHER_NAME;
    }

    protected Mechanism getDefaultMechanism() {
        return DEFAULT_MECHANISM;
    }

    protected String getDefaultMode() {
        return DEFAULT_MODE;
    }

    protected String getDefaultPadding() {
        return DEFAULT_PADDING;
    }

    protected Mechanism getMechanism() {
        if (this.modeChanged_ || this.paddingChanged_) {
            try {
                this.mechanism_ = this.getMechanismForModeAndPadding();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.mechanism_ = null;
            }
            this.modeChanged_ = false;
            this.paddingChanged_ = false;
        }
        return this.mechanism_;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Mechanism getMechanismForModeAndPadding() throws NoSuchAlgorithmException {
        Mechanism mechanism;
        Mechanism mechanism2 = null;
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(this.mode_);
        stringBuffer.append('/');
        stringBuffer.append(this.padding_);
        String string = stringBuffer.toString().toLowerCase();
        if (!this.modePaddingMechanisms_.containsKey(string)) throw new NoSuchAlgorithmException("Combination of mode and padding not supported: " + string);
        mechanism2 = (Mechanism)this.modePaddingMechanisms_.get(string);
        if (mechanism2 == null) throw new NoSuchAlgorithmException("Combination of mode and padding not supported: " + string);
        if (!(mechanism2 = (Mechanism)mechanism2.clone()).equals(Mechanism.RSA_PKCS_OAEP)) return mechanism2;
        String string2 = this.padding_.toLowerCase();
        String string3 = "oaepwith";
        if (this.padding_.startsWith(string3)) {
            String string4 = this.padding_.substring(string3.length());
            if (string4.startsWith("sha-1") || string4.startsWith("sha1")) {
                mechanism = Mechanism.SHA_1;
            } else if (string4.startsWith("md5")) {
                mechanism = Mechanism.MD5;
            } else if (string4.startsWith("md2")) {
                mechanism = Mechanism.MD2;
            } else if (string4.startsWith("ripemd128") || string4.startsWith("ripemd-128")) {
                mechanism = Mechanism.RIPEMD128;
            } else {
                if (!string4.startsWith("ripemd160") && !string4.startsWith("ripemd-160")) throw new NoSuchAlgorithmException("Requested hash algorithm for padding not supported: " + string);
                mechanism = Mechanism.RIPEMD160;
            }
            if (!string4.endsWith("andmgf1padding")) {
                throw new NoSuchAlgorithmException("Unknown message generation function (MGF) in requested padding: " + string);
            }
        } else {
            mechanism = Mechanism.SHA_1;
        }
        RSAPkcsOaepParameters rSAPkcsOaepParameters = new RSAPkcsOaepParameters(mechanism, 1L, 1L, null);
        mechanism2.setParameters(rSAPkcsOaepParameters);
        return mechanism2;
    }

    protected Hashtable getModePaddingMechanisms() {
        if (cipherModePaddingMechansims_ == null) {
            Hashtable<String, Mechanism> hashtable = new Hashtable<String, Mechanism>(15);
            hashtable.put("ecb/nopadding", Mechanism.RSA_X_509);
            hashtable.put("ecb/pkcs1padding", Mechanism.RSA_PKCS);
            hashtable.put("ecb/oaeppadding", Mechanism.RSA_PKCS_OAEP);
            hashtable.put("ecb/oaep", Mechanism.RSA_PKCS_OAEP);
            hashtable.put("ecb/oaepwithmd5andmgf1padding", Mechanism.RSA_PKCS_OAEP);
            hashtable.put("ecb/oaepwithmd2andmgf1padding", Mechanism.RSA_PKCS_OAEP);
            hashtable.put("ecb/oaepwithsha1andmgf1padding", Mechanism.RSA_PKCS_OAEP);
            hashtable.put("ecb/oaepwithsha-1andmgf1padding", Mechanism.RSA_PKCS_OAEP);
            hashtable.put("ecb/oaepwithripemd128andmgf1padding", Mechanism.RSA_PKCS_OAEP);
            hashtable.put("ecb/oaepwithripemd-128andmgf1padding", Mechanism.RSA_PKCS_OAEP);
            hashtable.put("ecb/oaepwithripemd160andmgf1padding", Mechanism.RSA_PKCS_OAEP);
            hashtable.put("ecb/oaepwithripemd-160andmgf1padding", Mechanism.RSA_PKCS_OAEP);
            hashtable.put("ecb/iso9796padding", Mechanism.RSA_9796);
            hashtable.put("ecb/iso9796", Mechanism.RSA_9796);
            hashtable.put("ecb/rawx509", Mechanism.RSA_X_509);
            cipherModePaddingMechansims_ = hashtable;
        }
        return cipherModePaddingMechansims_;
    }

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setEncrypt(true);
            MechanismInfo mechanismInfo2 = new MechanismInfo();
            mechanismInfo2.setDecrypt(true);
            MechanismInfo mechanismInfo3 = new MechanismInfo();
            mechanismInfo3.setSign(true);
            MechanismInfo mechanismInfo4 = new MechanismInfo();
            mechanismInfo4.setVerify(true);
            MechanismInfo mechanismInfo5 = new MechanismInfo();
            mechanismInfo5.setWrap(true);
            MechanismInfo mechanismInfo6 = new MechanismInfo();
            mechanismInfo6.setUnwrap(true);
            this.usedMechanismInfos_ = new MechanismInfo[][]{{mechanismInfo, mechanismInfo2, mechanismInfo3, mechanismInfo4, mechanismInfo5, mechanismInfo6}, {mechanismInfo, mechanismInfo2, mechanismInfo3, mechanismInfo4, mechanismInfo5, mechanismInfo6}, {mechanismInfo, mechanismInfo2, mechanismInfo5, mechanismInfo6}, {mechanismInfo3, mechanismInfo4}};
        }
        return this.usedMechanismInfos_;
    }

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            this.usedMechanisms_ = new Mechanism[]{Mechanism.RSA_PKCS, Mechanism.RSA_X_509, Mechanism.RSA_PKCS_OAEP, Mechanism.RSA_9796};
        }
        return this.usedMechanisms_;
    }

    protected void initializePkcs11Operation() throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.initializeSession();
        try {
            if (this.operationMode_ == 2) {
                this.session_.decryptInit(this.mechanism_, this.key_.getKeyObject());
                this.pkcs11Operation_ = 2;
            } else if (this.operationMode_ == 1) {
                iaik.pkcs.pkcs11.objects.Key key = this.key_.getKeyObject();
                if (key instanceof PrivateKey) {
                    this.session_.signInit(this.mechanism_, key);
                    this.pkcs11Operation_ = 1;
                } else {
                    this.session_.encryptInit(this.mechanism_, key);
                    this.pkcs11Operation_ = 2;
                }
            }
        }
        catch (TokenException tokenException) {
            throw new InvalidKeyException("Error initializing the PKCS#11 RSA cipher: " + tokenException.toString());
        }
        this.updateUsed_ = false;
        this.pkcs11OperationInitialized_ = true;
    }

    protected boolean isModeSupported(String string) {
        boolean bl = false;
        if (string != null) {
            if (supportedModes_ == null) {
                Vector<String> vector = new Vector<String>(1);
                vector.add(DEFAULT_MODE);
                supportedModes_ = vector;
            }
            bl = supportedModes_.contains(string.toLowerCase());
        }
        return bl;
    }

    protected boolean isPaddingSupported(String string) {
        boolean bl = false;
        if (string != null) {
            if (supportedPaddings_ == null) {
                Vector<String> vector = new Vector<String>(15);
                vector.add("nopadding");
                vector.add(DEFAULT_PADDING);
                vector.add("oaeppadding");
                vector.add("oaep");
                vector.add("oaepwithmd5andmgf1padding");
                vector.add("oaepwithmd2andmgf1padding");
                vector.add("oaepwithsha1andmgf1padding");
                vector.add("oaepwithsha-1andmgf1padding");
                vector.add("oaepwithripemd128andmgf1padding");
                vector.add("oaepwithripemd-128andmgf1padding");
                vector.add("oaepwithripemd160andmgf1padding");
                vector.add("oaepwithripemd-160andmgf1padding");
                vector.add("iso9796padding");
                vector.add("iso9796");
                vector.add("rawx509");
                supportedPaddings_ = vector;
            }
            bl = supportedPaddings_.contains(string.toLowerCase());
        }
        return bl;
    }

    protected byte[] pkcs11DoFinal(byte[] byArray, int n2, int n3) throws BadPaddingException, IllegalBlockSizeException {
        byte[] byArray2;
        if (!this.initialized_ || this.key_ == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        if (byArray != null && n2 + n3 > byArray.length) {
            throw new NullPointerException("Arguments must satisfy ((inputOffset + inputLength) <= input.length).");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException.toString());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException.toString());
            }
        }
        if (byArray != null) {
            this.buffer_.write(byArray, n2, n3);
        }
        byte[] byArray3 = this.buffer_.toByteArray();
        this.buffer_.reset();
        try {
            try {
                if (this.operationMode_ == 1) {
                    byArray2 = this.pkcs11Operation_ == 1 ? this.session_.sign(byArray3) : this.session_.encrypt(byArray3);
                } else if (this.operationMode_ == 2) {
                    byArray2 = this.session_.decrypt(byArray3);
                } else {
                    throw new UnsupportedOperationException("Method only supported in state encrypt or decrypt.");
                }
                this.pkcs11OperationInitialized_ = false;
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception("Error finishing cipher operation: " + tokenException);
            }
            Object var7_9 = null;
            this.finalizePkcs11Operation();
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.finalizePkcs11Operation();
            throw throwable;
        }
        return byArray2;
    }

    protected int pkcs11GetBlockSize() {
        return this.pkcs11GetOutputSize(1);
    }

    protected int pkcs11GetKeySize(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        int n2 = -1;
        if (key instanceof IAIKPKCS11PrivateKey) {
            iaik.pkcs.pkcs11.objects.RSAPrivateKey rSAPrivateKey = (iaik.pkcs.pkcs11.objects.RSAPrivateKey)((IAIKPKCS11PrivateKey)key).getKeyObject();
            n2 = rSAPrivateKey.getModulus().getByteArrayValue().length << 3;
        } else if (key instanceof IAIKPKCS11PublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)((IAIKPKCS11PublicKey)key).getKeyObject();
            n2 = rSAPublicKey.getModulusBits().getLongValue().intValue();
        } else if (key instanceof RSAPrivateKey) {
            n2 = ((RSAPrivateKey)key).getModulus().bitLength();
        } else if (key instanceof java.security.interfaces.RSAPublicKey) {
            n2 = ((java.security.interfaces.RSAPublicKey)key).getModulus().bitLength();
        } else {
            throw new InvalidKeyException("The provided key must be an IAIKPKCS11PrivateKey or an IAIKPKCS11PublicKey but it is : " + key.toString());
        }
        return n2;
    }

    protected int pkcs11GetOutputSize(int n2) {
        int n3 = -1;
        if (this.initialized_) {
            try {
                n3 = this.pkcs11GetKeySize(this.key_) + 7 >> 3;
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IAIKPkcs11Exception(invalidKeyException.toString());
            }
        } else {
            throw new IAIKPkcs11Exception("Cipher object not initialized.");
        }
        return n3;
    }

    protected void pkcs11Init(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.currentKeyIsSoftwareKey_ = false;
        if (n2 != 1 && n2 != 2 && n2 != 4 && n2 != 3) {
            throw new IAIKPkcs11Exception("Unknown operation mode: " + n2);
        }
        this.operationMode_ = n2;
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not supported: " + algorithmParameterSpec);
        }
        this.key_ = (IAIKPKCS11Key)key;
        this.keyObject_ = this.key_.getKeyObject();
        this.checkKeyObject(this.keyObject_);
        this.mechanism_ = this.getMechanism();
        if (this.mechanism_ == null) {
            throw new IAIKPkcs11Exception("The currently selected combination of mode and padding is not supported: " + this.mode_ + "/" + this.padding_);
        }
        this.initialize();
    }

    protected byte[] pkcs11Update(byte[] byArray, int n2, int n3) {
        if (!this.initialized_ || this.key_ == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        if (byArray == null) {
            throw new NullPointerException("Argument \"data\" must not be null.");
        }
        if (n2 + n3 > byArray.length) {
            throw new NullPointerException("Arguments must satisfy ((offset + length) <= data.length).");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException.toString());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException.toString());
            }
        }
        this.buffer_.write(byArray, n2, n3);
        byte[] byArray2 = null;
        return byArray2;
    }
}

