/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.ciphers;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.RC4SecretKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.ciphers.PKCS11Cipher;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class Rc4Cipher
extends PKCS11Cipher {
    private static final boolean DEBUG = false;
    protected static final String CIPHER_NAME = "RC4";
    protected static final Mechanism DEFAULT_MECHANISM = Mechanism.RC4;

    protected void checkKeyObject(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null.");
        }
        if (!(key instanceof RC4SecretKey)) {
            throw new InvalidKeyException("PKCS#11 key object inside IAIKPKCS11SecretKey must be of type RC4SecretKey");
        }
    }

    protected String getAlgorithmName() {
        return CIPHER_NAME;
    }

    protected Mechanism getDefaultMechanism() {
        return DEFAULT_MECHANISM;
    }

    protected Mechanism getMechanism() {
        return DEFAULT_MECHANISM;
    }

    protected boolean isModeSupported(String string) {
        return string == null || string.equalsIgnoreCase("NONE");
    }

    protected boolean isPaddingSupported(String string) {
        return string == null || string.equalsIgnoreCase("NoPadding");
    }

    protected int pkcs11GetBlockSize() {
        return 1;
    }

    protected int pkcs11GetKeySize(java.security.Key key) throws InvalidKeyException {
        SecretKey secretKey;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        int n2 = -1;
        if (key instanceof IAIKPKCS11SecretKey) {
            secretKey = (SecretKey)((IAIKPKCS11SecretKey)key).getKeyObject();
            if (!(secretKey instanceof RC4SecretKey)) {
                throw new InvalidKeyException("The provided IAIKPKCS11SecretKey must contain a RC4 secret key but contains: " + secretKey.toString());
            }
        } else {
            throw new InvalidKeyException("The provided key must be an IAIKPKCS11SecretKey but it is: " + key.toString());
        }
        RC4SecretKey rC4SecretKey = (RC4SecretKey)secretKey;
        n2 = rC4SecretKey.getValueLen().getLongValue().intValue() << 3;
        return n2;
    }

    protected int pkcs11GetOutputSize(int n2) {
        int n3 = -1;
        if (n2 >= 0) {
            n3 = n2;
        }
        return n3;
    }

    protected void pkcs11Init(int n2, java.security.Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (n2 != 1 && n2 != 2 && n2 != 4 && n2 != 3) {
            throw new IAIKPkcs11Exception("Unknown operation mode: " + n2);
        }
        this.operationMode_ = n2;
        if (!(key instanceof IAIKPKCS11SecretKey)) {
            throw new InvalidKeyException("key must be of type iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey!");
        }
        this.key_ = (IAIKPKCS11SecretKey)key;
        this.keyObject_ = this.key_.getKeyObject();
        this.checkKeyObject(this.keyObject_);
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("This cipher does not support AlgorithmParameterSpec.");
        }
        this.mechanism_ = this.getMechanism();
        if (this.mechanism_ == null) {
            throw new IAIKPkcs11Exception("This cipher object is not corretly initialized.");
        }
        this.initialize();
    }
}

