/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.ciphers;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.RC2SecretKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.parameters.RC2CbcParameters;
import iaik.pkcs.pkcs11.parameters.RC2Parameters;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.ciphers.BlockCipher;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import javax.crypto.spec.RC2ParameterSpec;

public class Rc2Cipher
extends BlockCipher {
    private static final boolean DEBUG = false;
    protected static final String CIPHER_NAME = "RC2";
    protected static final Mechanism DEFAULT_MECHANISM = Mechanism.RC2_ECB;
    protected static Hashtable cipherModePaddingMechansims_;
    protected RC2ParameterSpec rc2ParameterSpec_;
    protected boolean rc2ParameterSpecChanged_;
    protected Mechanism[] usedMechanisms_;

    protected void checkKeyObject(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null.");
        }
        if (!(key instanceof RC2SecretKey)) {
            throw new InvalidKeyException("PKCS#11 key object inside IAIKPKCS11SecretKey must be of type RC2SecretKey");
        }
    }

    protected String getAlgorithmName() {
        return CIPHER_NAME;
    }

    protected Mechanism getDefaultMechanism() {
        return DEFAULT_MECHANISM;
    }

    protected Mechanism getMechanism() {
        if (this.modeChanged_ || this.paddingChanged_ || this.rc2ParameterSpecChanged_) {
            Mechanism mechanism = null;
            try {
                mechanism = this.getMechanismForModeAndPadding();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                mechanism = null;
            }
            if (mechanism != null && this.mode_.equalsIgnoreCase("ecb") && this.rc2ParameterSpec_ != null) {
                int n2 = this.rc2ParameterSpec_.getEffectiveKeyBits();
                RC2Parameters rC2Parameters = new RC2Parameters(n2);
                mechanism.setParameters(rC2Parameters);
            } else if (mechanism != null && this.mode_.equalsIgnoreCase("cbc") && this.rc2ParameterSpec_ != null) {
                int n3 = this.rc2ParameterSpec_.getEffectiveKeyBits();
                byte[] byArray = this.rc2ParameterSpec_.getIV();
                RC2CbcParameters rC2CbcParameters = new RC2CbcParameters(n3, byArray);
                mechanism.setParameters(rC2CbcParameters);
            }
            this.mechanism_ = mechanism;
            this.modeChanged_ = false;
            this.paddingChanged_ = false;
            this.rc2ParameterSpecChanged_ = false;
        }
        return this.mechanism_;
    }

    protected Hashtable getModePaddingMechanisms() {
        if (cipherModePaddingMechansims_ == null) {
            Hashtable<String, Mechanism> hashtable = new Hashtable<String, Mechanism>(3);
            hashtable.put("ecb/nopadding", Mechanism.RC2_ECB);
            hashtable.put("cbc/nopadding", Mechanism.RC2_CBC);
            hashtable.put("cbc/pkcs5padding", Mechanism.RC2_CBC_PAD);
            cipherModePaddingMechansims_ = hashtable;
        }
        return cipherModePaddingMechansims_;
    }

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            this.usedMechanisms_ = new Mechanism[]{Mechanism.RC2_CBC_PAD, Mechanism.RC2_ECB, Mechanism.RC2_CBC};
        }
        return this.usedMechanisms_;
    }

    protected int pkcs11GetBlockSize() {
        return 8;
    }

    protected int pkcs11GetKeySize(java.security.Key key) throws InvalidKeyException {
        SecretKey secretKey;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        int n2 = -1;
        if (key instanceof IAIKPKCS11SecretKey) {
            secretKey = (SecretKey)((IAIKPKCS11SecretKey)key).getKeyObject();
            if (!(secretKey instanceof RC2SecretKey)) {
                throw new InvalidKeyException("The provided IAIKPKCS11SecretKey must contain a RC2 secret key but contains: " + secretKey.toString());
            }
        } else {
            throw new InvalidKeyException("The provided key must be an IAIKPKCS11SecretKey but it is: " + key.toString());
        }
        RC2SecretKey rC2SecretKey = (RC2SecretKey)secretKey;
        n2 = rC2SecretKey.getValueLen().getLongValue().intValue() << 3;
        return n2;
    }

    protected int pkcs11GetOutputSize(int n2) {
        int n3 = -1;
        if (n2 >= 0) {
            n3 = n2 + 15;
        }
        return n3;
    }

    protected void pkcs11Init(int n2, java.security.Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (n2 != 1 && n2 != 2 && n2 != 4 && n2 != 3) {
            throw new IAIKPkcs11Exception("Unknown operation mode: " + n2);
        }
        this.operationMode_ = n2;
        if (!(key instanceof IAIKPKCS11SecretKey)) {
            throw new InvalidKeyException("key must be of type iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey!");
        }
        this.key_ = (IAIKPKCS11SecretKey)key;
        this.keyObject_ = this.key_.getKeyObject();
        this.checkKeyObject(this.keyObject_);
        if (this.mode_.equalsIgnoreCase("ecb")) {
            if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof RC2ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("RC2ParameterSpec required, but parameterSpecs is: " + algorithmParameterSpec);
            }
            this.rc2ParameterSpec_ = (RC2ParameterSpec)algorithmParameterSpec;
            this.rc2ParameterSpecChanged_ = true;
        } else if (this.mode_.equalsIgnoreCase("cbc")) {
            if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof RC2ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("RC2ParameterSpec required, but parameterSpecs is: " + algorithmParameterSpec);
            }
            this.rc2ParameterSpec_ = (RC2ParameterSpec)algorithmParameterSpec;
            this.rc2ParameterSpecChanged_ = true;
            if (this.rc2ParameterSpec_.getIV() == null) {
                throw new InvalidAlgorithmParameterException("Initialization vector required in RC2ParameterSpec in CBC mode, in the given RC2ParameterSpec it is null.");
            }
        }
        this.mechanism_ = this.getMechanism();
        if (this.mechanism_ == null) {
            throw new IAIKPkcs11Exception("The currently selected combination of mode and padding is not supported: " + this.mode_ + "/" + this.padding_);
        }
        this.initialize();
    }
}

