/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.ciphers;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.objects.Storage;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public abstract class PKCS11Cipher
extends CipherSpi
implements PKCS11EngineClass {
    private static final boolean DEBUG = false;
    protected static final byte[] DUMMY_DATA = new byte[1];
    protected Session session_;
    protected TokenManager tokenManager_;
    protected IAIKPKCS11Key key_;
    protected iaik.pkcs.pkcs11.objects.Key keyObject_;
    protected int operationMode_;
    protected Mechanism mechanism_ = this.getDefaultMechanism();
    protected boolean initialized_;
    protected boolean pkcs11OperationInitialized_;
    protected boolean updateUsed_;
    protected boolean currentKeyIsSoftwareKey_;
    protected Cipher softwareDelegate_;
    protected String mode_;
    protected String padding_;
    protected AlgorithmParameters parameters_;
    protected boolean modeChanged_;
    protected boolean paddingChanged_;
    protected Mechanism[] usedMechanisms_;
    protected MechanismInfo[][] usedMechanismInfos_;

    protected PKCS11Cipher() {
    }

    protected abstract void checkKeyObject(iaik.pkcs.pkcs11.objects.Key var1) throws InvalidKeyException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws BadPaddingException, IllegalBlockSizeException {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11DoFinal(byArray, n2, n3);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.doFinal(byArray, n2, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11DoFinal(byArray, n2, n3, byArray2, n4);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.doFinal(byArray, n2, n3, byArray2, n4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int engineGetBlockSize() {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11GetBlockSize();
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.getBlockSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineGetIV() {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11GetIV();
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.getIV();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof IAIKPKCS11Key) {
            return this.pkcs11GetKeySize(key);
        }
        if (!(key instanceof javax.crypto.SecretKey)) throw new InvalidKeyException("Cannot determine size of software key.");
        byte[] byArray = key.getEncoded();
        if (byArray == null) throw new InvalidKeyException("Cannot determine size of software secret key. Key encoding is null.");
        return byArray.length << 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int engineGetOutputSize(int n2) {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11GetOutputSize(n2);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.getOutputSize(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AlgorithmParameters engineGetParameters() {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11GetParameters();
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.getParameters();
    }

    protected void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (key instanceof IAIKPKCS11Key) {
            this.pkcs11Init(n2, key, algorithmParameters, secureRandom);
            this.currentKeyIsSoftwareKey_ = false;
        } else if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            this.softwareDelegate_.init(n2, key, algorithmParameters, secureRandom);
            this.currentKeyIsSoftwareKey_ = true;
        } else {
            throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        }
    }

    protected void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (key instanceof IAIKPKCS11Key) {
            this.pkcs11Init(n2, key, secureRandom);
            this.currentKeyIsSoftwareKey_ = false;
        } else if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            this.softwareDelegate_.init(n2, key, secureRandom);
            this.currentKeyIsSoftwareKey_ = true;
        } else {
            throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        }
    }

    protected void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (key instanceof IAIKPKCS11Key) {
            this.pkcs11Init(n2, key, algorithmParameterSpec, secureRandom);
            this.currentKeyIsSoftwareKey_ = false;
        } else if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            this.currentKeyIsSoftwareKey_ = true;
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            this.softwareDelegate_.init(n2, key, algorithmParameterSpec, secureRandom);
        } else {
            throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        }
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!this.isModeSupported(string)) {
            throw new NoSuchAlgorithmException("Mode not supported: " + string);
        }
        this.mode_ = string;
        this.modeChanged_ = true;
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (this.isPaddingSupported(string)) {
            this.padding_ = string;
            this.paddingChanged_ = true;
            if (this.getMechanism() == null) {
                throw new NoSuchPaddingException("Padding not supported with this mode: " + this.mode_ + "/" + string);
            }
        } else {
            throw new NoSuchPaddingException("Padding not supported: " + string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Key engineUnwrap(byte[] byArray, String string, int n2) throws NoSuchAlgorithmException, InvalidKeyException {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11Unwrap(byArray, string, n2);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.unwrap(byArray, string, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11Update(byArray, n2, n3);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.update(byArray, n2, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11Update(byArray, n2, n3, byArray2, n4);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.update(byArray, n2, n3, byArray2, n4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11Wrap(key);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.wrap(key);
    }

    protected void finalize() throws Throwable {
        if (this.session_ != null) {
            this.tokenManager_.disposeSession(this.session_);
        }
        super.finalize();
    }

    protected void finalizePkcs11Operation() {
        if (this.pkcs11OperationInitialized_) {
            this.pkcs11OperationInitialized_ = false;
            this.tokenManager_.closeSession(this.session_);
            this.session_ = null;
        } else {
            this.pkcs11OperationInitialized_ = false;
            this.tokenManager_.disposeSession(this.session_);
            this.session_ = null;
        }
    }

    protected abstract String getAlgorithmName();

    protected abstract Mechanism getDefaultMechanism();

    protected String getFullAlgorithmName() {
        String string;
        String string2 = this.getAlgorithmName();
        if (this.mode_ != null && this.padding_ != null) {
            StringBuffer stringBuffer = new StringBuffer(string2.length() + this.mode_.length() + this.padding_.length() + 2);
            stringBuffer.append(string2);
            stringBuffer.append('/');
            stringBuffer.append(this.mode_);
            stringBuffer.append('/');
            stringBuffer.append(this.padding_);
            string = stringBuffer.toString();
        } else {
            string = string2;
        }
        return string;
    }

    protected abstract Mechanism getMechanism();

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setEncrypt(true);
            MechanismInfo mechanismInfo2 = new MechanismInfo();
            mechanismInfo2.setDecrypt(true);
            MechanismInfo mechanismInfo3 = new MechanismInfo();
            mechanismInfo3.setWrap(true);
            MechanismInfo mechanismInfo4 = new MechanismInfo();
            mechanismInfo4.setUnwrap(true);
            this.usedMechanismInfos_ = new MechanismInfo[][]{{mechanismInfo, mechanismInfo2, mechanismInfo3, mechanismInfo4}};
        }
        return this.usedMechanismInfos_;
    }

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            this.usedMechanisms_ = new Mechanism[]{this.getMechanism()};
        }
        return this.usedMechanisms_;
    }

    protected void initialize() throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.initializePkcs11Operation();
        this.initialized_ = true;
    }

    protected void initializePkcs11Operation() throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.initializeSession();
        try {
            if (this.operationMode_ == 2) {
                this.session_.decryptInit(this.mechanism_, this.key_.getKeyObject());
            } else if (this.operationMode_ == 1) {
                this.session_.encryptInit(this.mechanism_, this.key_.getKeyObject());
            }
        }
        catch (TokenException tokenException) {
            throw new InvalidKeyException("Error initializing the PKCS#11 cipher: " + tokenException.toString());
        }
        this.updateUsed_ = false;
        this.pkcs11OperationInitialized_ = true;
    }

    protected void initializeSession() {
        try {
            this.tokenManager_ = this.key_.getTokenManager();
            if (this.session_ == null) {
                this.session_ = this.tokenManager_.getSession(false);
            }
            this.tokenManager_.makeAuthorizedSession(this.session_, null);
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void initializeSoftwareDelegate() {
        DelegateProvider delegateProvider = this.tokenManager_ != null ? this.tokenManager_.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.getFullAlgorithmName();
        this.softwareDelegate_ = delegateProvider.getCipher(string);
        if (this.softwareDelegate_ == null) {
            throw new IAIKPkcs11Exception("Could not get delegate cipher engine for " + string);
        }
    }

    protected abstract boolean isModeSupported(String var1);

    protected abstract boolean isPaddingSupported(String var1);

    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            Mechanism[] mechanismArray = this.getUsedMechanisms();
            MechanismInfo[][] mechanismInfoArray = this.getUsedMechanismFeatures();
            bl = tokenManager.isMechanismFeatureSupported(mechanismArray, mechanismInfoArray);
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    protected byte[] pkcs11DoFinal(byte[] byArray, int n2, int n3) throws BadPaddingException, IllegalBlockSizeException {
        byte[] byArray2;
        if (!this.initialized_ || this.key_ == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        if (byArray != null && n2 + n3 > byArray.length) {
            throw new IllegalArgumentException("Arguments must satisfy ((inputOffset + inputLength) <= input.length).");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException.toString());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException.toString());
            }
        }
        if (!this.updateUsed_ && byArray != null) {
            byte[] byArray3 = null;
            if (n2 == 0 && n3 == byArray.length) {
                byArray3 = byArray;
            } else {
                byArray3 = new byte[n3];
                System.arraycopy(byArray, n2, byArray3, 0, n3);
            }
            try {
                try {
                    if (this.operationMode_ == 1) {
                        byArray2 = this.session_.encrypt(byArray3);
                    } else if (this.operationMode_ == 2) {
                        byArray2 = this.session_.decrypt(byArray3);
                    } else {
                        throw new UnsupportedOperationException("Method only supported in state encrypt or decrypt.");
                    }
                    this.pkcs11OperationInitialized_ = false;
                }
                catch (TokenException tokenException) {
                    throw new IAIKPkcs11Exception("Error updating cipher: " + tokenException);
                }
                Object var7_10 = null;
                this.finalizePkcs11Operation();
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                this.finalizePkcs11Operation();
                throw throwable;
            }
        }
        try {
            try {
                if (byArray != null) {
                    this.pkcs11Update(byArray, n2, n3);
                }
                if (this.operationMode_ == 1) {
                    byArray2 = this.session_.encryptFinal();
                } else if (this.operationMode_ == 2) {
                    byArray2 = this.session_.decryptFinal();
                } else {
                    throw new UnsupportedOperationException("Method only supported in state encrypt or decrypt.");
                }
                this.pkcs11OperationInitialized_ = false;
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception("Error updating cipher: " + tokenException);
            }
            Object var6_14 = null;
            this.finalizePkcs11Operation();
        }
        catch (Throwable throwable) {
            Object var6_15 = null;
            this.finalizePkcs11Operation();
            throw throwable;
        }
        return byArray2;
    }

    protected int pkcs11DoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException {
        byte[] byArray3;
        if (!this.initialized_ || this.key_ == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException.toString());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException.toString());
            }
        }
        if ((byArray3 = this.pkcs11DoFinal(byArray, n2, n3)) != null && byArray2 != null) {
            if (byArray2.length - n4 < byArray3.length) {
                throw new ShortBufferException("Output is " + byArray3.length + "bytes long." + "The given buffer has only place for " + (byArray2.length - n4) + "bytes.");
            }
            System.arraycopy(byArray3, 0, byArray2, n4, byArray3.length);
        }
        return byArray3.length;
    }

    protected int pkcs11GetBlockSize() {
        return -1;
    }

    protected byte[] pkcs11GetIV() {
        return null;
    }

    protected int pkcs11GetKeySize(Key key) throws InvalidKeyException {
        return -1;
    }

    protected int pkcs11GetOutputSize(int n2) {
        return -1;
    }

    protected AlgorithmParameters pkcs11GetParameters() {
        return this.parameters_;
    }

    protected void pkcs11Init(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.pkcs11Init(n2, key, (AlgorithmParameterSpec)null, secureRandom);
    }

    protected void pkcs11Init(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.pkcs11Init(n2, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IAIKPkcs11Exception(invalidAlgorithmParameterException.toString());
        }
    }

    protected void pkcs11Init(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (n2 != 1 && n2 != 2 && n2 != 4 && n2 != 3) {
            throw new IAIKPkcs11Exception("Unknown operation mode: " + n2);
        }
        this.mechanism_ = this.getMechanism();
        if (this.mechanism_ == null) {
            throw new IAIKPkcs11Exception("This cipher object has not been initialized corretly.");
        }
        this.operationMode_ = n2;
        this.key_ = (IAIKPKCS11Key)key;
        iaik.pkcs.pkcs11.objects.Key key2 = this.key_.getKeyObject();
        this.checkKeyObject(key2);
        this.keyObject_ = key2;
        this.initialize();
    }

    protected Key pkcs11Unwrap(byte[] byArray, String string, int n2) throws NoSuchAlgorithmException, InvalidKeyException {
        Object object;
        GenericTemplate genericTemplate;
        if (!this.initialized_ || this.key_ == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        if (byArray == null) {
            throw new NullPointerException("Argument \"wrappedKey\" must not be null.");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException.toString());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException.toString());
            }
        }
        if (this.operationMode_ != 4) {
            throw new UnsupportedOperationException("Method only supported in state unwrap.");
        }
        IAIKPKCS11Key iAIKPKCS11Key = null;
        switch (n2) {
            case 3: {
                genericTemplate = new GenericTemplate();
                LongAttribute longAttribute = new LongAttribute(Attribute.CLASS);
                longAttribute.setLongValue(Object.ObjectClass.SECRET_KEY);
                genericTemplate.addAttribute(longAttribute);
                break;
            }
            case 2: {
                genericTemplate = new GenericTemplate();
                LongAttribute longAttribute = new LongAttribute(Attribute.CLASS);
                longAttribute.setLongValue(Object.ObjectClass.PRIVATE_KEY);
                genericTemplate.addAttribute(longAttribute);
                break;
            }
            case 1: {
                genericTemplate = new GenericTemplate();
                LongAttribute longAttribute = new LongAttribute(Attribute.CLASS);
                longAttribute.setLongValue(Object.ObjectClass.PUBLIC_KEY);
                genericTemplate.addAttribute(longAttribute);
                break;
            }
            default: {
                genericTemplate = null;
            }
        }
        if (genericTemplate != null) {
            object = IAIKPKCS11Key.getAlgorithmCode(string);
            LongAttribute longAttribute = new LongAttribute(Attribute.KEY_TYPE);
            longAttribute.setLongValue((Long)object);
            genericTemplate.addAttribute(longAttribute);
        }
        object = null;
        try {
            object = this.session_.unwrapKey(this.mechanism_, this.key_.getKeyObject(), byArray, genericTemplate);
        }
        catch (TokenException tokenException) {
            this.finalizePkcs11Operation();
            throw new IAIKPkcs11Exception("Error unwrapping key: " + tokenException);
        }
        if (object instanceof PrivateKey) {
            iAIKPKCS11Key = IAIKPKCS11Key.create(this.tokenManager_, (iaik.pkcs.pkcs11.objects.Key)object);
        } else if (object instanceof PublicKey) {
            iAIKPKCS11Key = IAIKPKCS11PublicKey.create(this.tokenManager_, (PublicKey)object);
        } else if (object instanceof SecretKey) {
            iAIKPKCS11Key = IAIKPKCS11SecretKey.create(this.tokenManager_, (SecretKey)object);
        } else {
            this.finalizePkcs11Operation();
            throw new InvalidKeyException("This type of PKCS#11 key cannot be handled: " + object);
        }
        if (!((Storage)object).getToken().getBooleanValue().booleanValue()) {
            iAIKPKCS11Key.setSession(this.session_);
            this.session_ = null;
            this.pkcs11OperationInitialized_ = false;
        } else {
            this.finalizePkcs11Operation();
        }
        return iAIKPKCS11Key;
    }

    protected byte[] pkcs11Update(byte[] byArray, int n2, int n3) {
        byte[] byArray2;
        block13: {
            if (!this.initialized_ || this.key_ == null) {
                throw new IllegalStateException("Cipher not initialized.");
            }
            if (!this.pkcs11OperationInitialized_) {
                try {
                    this.initializePkcs11Operation();
                }
                catch (InvalidKeyException invalidKeyException) {
                    this.finalizePkcs11Operation();
                    throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException.toString());
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    this.finalizePkcs11Operation();
                    throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException.toString());
                }
            }
            if (byArray == null) {
                throw new NullPointerException("Argument \"data\" must not be null.");
            }
            if (n2 + n3 > byArray.length) {
                throw new IllegalArgumentException("Arguments must satisfy ((offset + length) <= data.length).");
            }
            byte[] byArray3 = null;
            if (n2 == 0 && n3 == byArray.length) {
                byArray3 = byArray;
            } else {
                byArray3 = new byte[n3];
                System.arraycopy(byArray, n2, byArray3, 0, n3);
            }
            try {
                if (this.operationMode_ == 1) {
                    byArray2 = this.session_.encryptUpdate(byArray3);
                    break block13;
                }
                if (this.operationMode_ == 2) {
                    byArray2 = this.session_.decryptUpdate(byArray3);
                    break block13;
                }
                throw new UnsupportedOperationException("Method only supported in state encrypt or decrypt.");
            }
            catch (TokenException tokenException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Error updating cipher: " + tokenException);
            }
        }
        this.updateUsed_ = true;
        return byArray2;
    }

    protected int pkcs11Update(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        if (!this.initialized_ || this.key_ == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        if (byArray == null) {
            throw new NullPointerException("Argument \"data\" must not be null.");
        }
        byte[] byArray3 = this.pkcs11Update(byArray, n2, n3);
        if (byArray3 != null && byArray2 != null) {
            if (byArray2.length - n4 < byArray3.length) {
                throw new ShortBufferException("Output is " + byArray3.length + "bytes long." + "The given buffer has only place for " + (byArray2.length - n4) + "bytes.");
            }
            System.arraycopy(byArray3, 0, byArray2, n4, byArray3.length);
        }
        this.updateUsed_ = true;
        return byArray3.length;
    }

    protected byte[] pkcs11Wrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        byte[] byArray;
        if (!this.initialized_ || this.key_ == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (!(key instanceof IAIKPKCS11Key)) {
            throw new InvalidKeyException("Argument key must be of instance iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key.");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException.toString());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException.toString());
            }
        }
        iaik.pkcs.pkcs11.objects.Key key2 = ((IAIKPKCS11Key)key).getKeyObject();
        try {
            try {
                if (this.operationMode_ != 3) {
                    throw new UnsupportedOperationException("Method only supported in state wrap.");
                }
                byArray = this.session_.wrapKey(this.mechanism_, this.key_.getKeyObject(), key2);
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception("Error wrapping key: " + tokenException);
            }
            Object var5_7 = null;
            this.finalizePkcs11Operation();
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.finalizePkcs11Operation();
            throw throwable;
        }
        return byArray;
    }
}

