/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.ciphers;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.objects.CASTSecretKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.provider.ciphers.BlockCipher;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidKeyException;
import java.util.Hashtable;

public class CastCipher
extends BlockCipher {
    private static final boolean DEBUG = false;
    protected static final String CIPHER_NAME = "CAST";
    protected static final Mechanism DEFAULT_MECHANISM = Mechanism.CAST_ECB;
    protected static Hashtable cipherModePaddingMechansims_;
    protected Mechanism[] usedMechanisms_;

    protected void checkKeyObject(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null.");
        }
        if (!(key instanceof CASTSecretKey)) {
            throw new InvalidKeyException("PKCS#11 key object inside IAIKPKCS11SecretKey must be of type CASTSecretKey");
        }
    }

    protected String getAlgorithmName() {
        return CIPHER_NAME;
    }

    protected Mechanism getDefaultMechanism() {
        return DEFAULT_MECHANISM;
    }

    protected Hashtable getModePaddingMechanisms() {
        if (cipherModePaddingMechansims_ == null) {
            Hashtable<String, Mechanism> hashtable = new Hashtable<String, Mechanism>(3);
            hashtable.put("ecb/nopadding", Mechanism.CAST_ECB);
            hashtable.put("cbc/nopadding", Mechanism.CAST_CBC);
            hashtable.put("cbc/pkcs5padding", Mechanism.CAST_CBC_PAD);
            cipherModePaddingMechansims_ = hashtable;
        }
        return cipherModePaddingMechansims_;
    }

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            this.usedMechanisms_ = new Mechanism[]{Mechanism.CAST_CBC_PAD, Mechanism.CAST_ECB, Mechanism.CAST_CBC};
        }
        return this.usedMechanisms_;
    }

    protected int pkcs11GetBlockSize() {
        return 8;
    }

    protected int pkcs11GetKeySize(java.security.Key key) throws InvalidKeyException {
        SecretKey secretKey;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        int n2 = -1;
        if (key instanceof IAIKPKCS11SecretKey) {
            secretKey = (SecretKey)((IAIKPKCS11SecretKey)key).getKeyObject();
            if (!(secretKey instanceof CASTSecretKey)) {
                throw new InvalidKeyException("The provided IAIKPKCS11SecretKey must contain a CAST secret key but contains: " + secretKey.toString());
            }
        } else {
            throw new InvalidKeyException("The provided key must be an IAIKPKCS11SecretKey but it is: " + key.toString());
        }
        CASTSecretKey cASTSecretKey = (CASTSecretKey)secretKey;
        n2 = cASTSecretKey.getValueLen().getLongValue().intValue() << 3;
        return n2;
    }

    protected int pkcs11GetOutputSize(int n2) {
        int n3 = -1;
        if (n2 >= 0) {
            n3 = n2 + 15;
        }
        return n3;
    }
}

