/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.ciphers;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.objects.CAST128SecretKey;
import iaik.pkcs.pkcs11.objects.CAST5SecretKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.provider.ciphers.BlockCipher;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidKeyException;
import java.util.Hashtable;

public class Cast128Cipher
extends BlockCipher {
    private static final boolean DEBUG = false;
    protected static final String CIPHER_NAME = "CAST128";
    protected static final Mechanism DEFAULT_MECHANISM = Mechanism.CAST128_ECB;
    protected static Hashtable cipherModePaddingMechansims_;
    protected Mechanism[] usedMechanisms_;

    protected void checkKeyObject(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null.");
        }
        if (!(key instanceof CAST5SecretKey) && !(key instanceof CAST128SecretKey)) {
            throw new InvalidKeyException("PKCS#11 key object inside IAIKPKCS11SecretKey must be of type CAST5SecretKey or CAST128SecretKey");
        }
    }

    protected String getAlgorithmName() {
        return CIPHER_NAME;
    }

    protected Mechanism getDefaultMechanism() {
        return DEFAULT_MECHANISM;
    }

    protected Hashtable getModePaddingMechanisms() {
        if (cipherModePaddingMechansims_ == null) {
            Hashtable<String, Mechanism> hashtable = new Hashtable<String, Mechanism>(128);
            hashtable.put("ecb/nopadding", Mechanism.CAST128_ECB);
            hashtable.put("cbc/nopadding", Mechanism.CAST128_CBC);
            hashtable.put("cbc/pkcs5padding", Mechanism.CAST128_CBC_PAD);
            cipherModePaddingMechansims_ = hashtable;
        }
        return cipherModePaddingMechansims_;
    }

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            this.usedMechanisms_ = new Mechanism[]{Mechanism.CAST128_CBC_PAD, Mechanism.CAST128_ECB, Mechanism.CAST128_CBC};
        }
        return this.usedMechanisms_;
    }

    protected int pkcs11GetBlockSize() {
        return 8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int pkcs11GetKeySize(java.security.Key key) throws InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        int n2 = -1;
        if (!(key instanceof IAIKPKCS11SecretKey)) throw new InvalidKeyException("The provided key must be an IAIKPKCS11SecretKey but it is: " + key.toString());
        SecretKey secretKey = (SecretKey)((IAIKPKCS11SecretKey)key).getKeyObject();
        if (secretKey instanceof CAST5SecretKey) {
            CAST5SecretKey cAST5SecretKey = (CAST5SecretKey)secretKey;
            return cAST5SecretKey.getValueLen().getLongValue().intValue() << 3;
        }
        if (!(secretKey instanceof CAST128SecretKey)) throw new InvalidKeyException("The provided IAIKPKCS11SecretKey must contain a CAST128 secret key but contains: " + secretKey.toString());
        CAST128SecretKey cAST128SecretKey = (CAST128SecretKey)secretKey;
        return cAST128SecretKey.getValueLen().getLongValue().intValue() << 3;
    }

    protected int pkcs11GetOutputSize(int n2) {
        int n3 = -1;
        if (n2 >= 0) {
            n3 = n2 + 15;
        }
        return n3;
    }
}

