/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.ciphers;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.parameters.InitializationVectorParameters;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.ciphers.PKCS11Cipher;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public abstract class BlockCipher
extends PKCS11Cipher {
    private static final boolean DEBUG = false;
    protected static final String DEFAULT_MODE = "ecb";
    protected static final String DEFAULT_PADDING = "nopadding";
    protected static Vector supportedModes_;
    protected static Vector supportedPaddings_;
    protected Hashtable modePaddingMechanisms_ = this.getModePaddingMechanisms();
    protected IvParameterSpec ivParameterSpec_;
    protected boolean ivParameterSpecChanged_;
    static /* synthetic */ Class class$javax$crypto$spec$IvParameterSpec;

    public BlockCipher() {
        this.mode_ = this.getDefaultMode();
        this.padding_ = this.getDefaultPadding();
    }

    protected void checkKeyObject(iaik.pkcs.pkcs11.objects.Key key) throws InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null.");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("PKCS#11 key object inside IAIKPKCS11SecretKey must be of type SecretKey");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected abstract Mechanism getDefaultMechanism();

    protected String getDefaultMode() {
        return DEFAULT_MODE;
    }

    protected String getDefaultPadding() {
        return DEFAULT_PADDING;
    }

    protected Mechanism getMechanism() {
        Mechanism mechanism = null;
        if (this.modeChanged_ || this.paddingChanged_ || this.ivParameterSpecChanged_) {
            try {
                mechanism = this.getMechanismForModeAndPadding();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                mechanism = null;
            }
            if (mechanism != null && this.mode_.equalsIgnoreCase("cbc") && this.ivParameterSpec_ != null) {
                byte[] byArray = this.ivParameterSpec_.getIV();
                InitializationVectorParameters initializationVectorParameters = new InitializationVectorParameters(byArray);
                mechanism.setParameters(initializationVectorParameters);
            }
            this.mechanism_ = mechanism;
            this.modeChanged_ = false;
            this.paddingChanged_ = false;
            this.ivParameterSpecChanged_ = false;
        }
        return this.mechanism_;
    }

    protected Mechanism getMechanismForModeAndPadding() throws NoSuchAlgorithmException {
        Mechanism mechanism = null;
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(this.mode_);
        stringBuffer.append('/');
        stringBuffer.append(this.padding_);
        String string = stringBuffer.toString().toLowerCase();
        if (this.modePaddingMechanisms_.containsKey(string)) {
            mechanism = (Mechanism)this.modePaddingMechanisms_.get(string);
            if (mechanism == null) {
                throw new NoSuchAlgorithmException("Combination of mode and padding not supported: " + string);
            }
        } else {
            throw new NoSuchAlgorithmException("Combination of mode and padding not supported: " + string);
        }
        mechanism = (Mechanism)mechanism.clone();
        return mechanism;
    }

    protected abstract Hashtable getModePaddingMechanisms();

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setEncrypt(true);
            MechanismInfo mechanismInfo2 = new MechanismInfo();
            mechanismInfo2.setDecrypt(true);
            this.usedMechanismInfos_ = new MechanismInfo[][]{{mechanismInfo, mechanismInfo2}, {mechanismInfo, mechanismInfo2}, {mechanismInfo, mechanismInfo2}};
        }
        return this.usedMechanismInfos_;
    }

    protected boolean isModeSupported(String string) {
        boolean bl = false;
        if (string != null) {
            if (supportedModes_ == null) {
                Vector<String> vector = new Vector<String>(2);
                vector.add(DEFAULT_MODE);
                vector.add("cbc");
                supportedModes_ = vector;
            }
            bl = supportedModes_.contains(string.toLowerCase());
        }
        return bl;
    }

    protected boolean isPaddingSupported(String string) {
        boolean bl = false;
        if (string != null) {
            if (supportedPaddings_ == null) {
                Vector<String> vector = new Vector<String>(2);
                vector.add(DEFAULT_PADDING);
                vector.add("pkcs5padding");
                supportedPaddings_ = vector;
            }
            bl = supportedPaddings_.contains(string.toLowerCase());
        }
        return bl;
    }

    protected int pkcs11GetBlockSize() {
        return -1;
    }

    protected byte[] pkcs11GetIV() {
        byte[] byArray = this.ivParameterSpec_ != null ? this.ivParameterSpec_.getIV() : null;
        return byArray;
    }

    protected abstract int pkcs11GetKeySize(Key var1) throws InvalidKeyException;

    protected void pkcs11Init(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        try {
            AlgorithmParameterSpec algorithmParameterSpec = algorithmParameters != null ? (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(class$javax$crypto$spec$IvParameterSpec != null ? class$javax$crypto$spec$IvParameterSpec : (class$javax$crypto$spec$IvParameterSpec = BlockCipher.class$("javax.crypto.spec.IvParameterSpec"))) : null;
            this.parameters_ = algorithmParameters;
            this.pkcs11Init(n2, key, algorithmParameterSpec, secureRandom);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException(invalidParameterSpecException.toString());
        }
    }

    protected void pkcs11Init(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (n2 != 1 && n2 != 2 && n2 != 4 && n2 != 3) {
            throw new IAIKPkcs11Exception("Unknown operation mode: " + n2);
        }
        if (!(key instanceof IAIKPKCS11SecretKey)) {
            throw new InvalidKeyException("key must be of type iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey!");
        }
        IAIKPKCS11SecretKey iAIKPKCS11SecretKey = (IAIKPKCS11SecretKey)key;
        iaik.pkcs.pkcs11.objects.Key key2 = iAIKPKCS11SecretKey.getKeyObject();
        this.checkKeyObject(key2);
        if (this.mode_.equalsIgnoreCase(DEFAULT_MODE) && algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not supported in ECB mode, but parameterSpecs is: " + algorithmParameterSpec);
        }
        if (this.mode_.equalsIgnoreCase("cbc") && (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof IvParameterSpec))) {
            throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec IvParameterSpec required in CBC mode, but parameterSpecs is: " + algorithmParameterSpec);
        }
        this.key_ = iAIKPKCS11SecretKey;
        this.keyObject_ = key2;
        this.operationMode_ = n2;
        this.ivParameterSpec_ = (IvParameterSpec)algorithmParameterSpec;
        this.ivParameterSpecChanged_ = true;
        this.mechanism_ = this.getMechanism();
        if (this.mechanism_ == null) {
            throw new IAIKPkcs11Exception("The currently selected combination of mode and padding is not supported: " + this.mode_ + "/" + this.padding_);
        }
        this.initialize();
    }
}

