/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.ciphers;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.objects.AESSecretKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.provider.ciphers.BlockCipher;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidKeyException;
import java.util.Hashtable;

public class AesCipher
extends BlockCipher {
    private static final boolean DEBUG = false;
    protected static final String CIPHER_NAME = "AES";
    protected static final Mechanism DEFAULT_MECHANISM = Mechanism.AES_ECB;
    protected static Hashtable cipherModePaddingMechansims_;
    protected Mechanism[] usedMechanisms_;

    protected void checkKeyObject(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null.");
        }
        if (!(key instanceof AESSecretKey)) {
            throw new InvalidKeyException("PKCS#11 key object inside IAIKPKCS11SecretKey must be of type AESSecretKey");
        }
    }

    protected String getAlgorithmName() {
        return CIPHER_NAME;
    }

    protected Mechanism getDefaultMechanism() {
        return DEFAULT_MECHANISM;
    }

    protected Hashtable getModePaddingMechanisms() {
        if (cipherModePaddingMechansims_ == null) {
            Hashtable<String, Mechanism> hashtable = new Hashtable<String, Mechanism>(3);
            hashtable.put("ecb/nopadding", Mechanism.AES_ECB);
            hashtable.put("cbc/nopadding", Mechanism.AES_CBC);
            hashtable.put("cbc/pkcs5padding", Mechanism.AES_CBC_PAD);
            cipherModePaddingMechansims_ = hashtable;
        }
        return cipherModePaddingMechansims_;
    }

    protected int getOutputSize(int n2) {
        int n3 = -1;
        if (n2 >= 0) {
            n3 = n2 + 15;
        }
        return n3;
    }

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            this.usedMechanisms_ = new Mechanism[]{Mechanism.AES_CBC_PAD, Mechanism.AES_ECB, Mechanism.AES_CBC};
        }
        return this.usedMechanisms_;
    }

    protected int pkcs11GetBlockSize() {
        return 16;
    }

    protected int pkcs11GetKeySize(java.security.Key key) throws InvalidKeyException {
        SecretKey secretKey;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        int n2 = -1;
        if (key instanceof IAIKPKCS11SecretKey) {
            secretKey = (SecretKey)((IAIKPKCS11SecretKey)key).getKeyObject();
            if (!(secretKey instanceof AESSecretKey)) {
                throw new InvalidKeyException("The provided IAIKPKCS11SecretKey must contain a AES secret key but contains: " + secretKey.toString());
            }
        } else {
            throw new InvalidKeyException("The provided key must be an IAIKPKCS11SecretKey but it is: " + key.toString());
        }
        AESSecretKey aESSecretKey = (AESSecretKey)secretKey;
        n2 = aESSecretKey.getValueLen().getLongValue().intValue() << 3;
        return n2;
    }
}

