/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider;

import iaik.pkcs.pkcs11.DefaultInitializeArgs;
import iaik.pkcs.pkcs11.InitializeArgs;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.SessionInfo;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.State;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.provider.Constants;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11AuthenticationCanceledException;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11AuthenticationException;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11TokenUnavailableException;
import iaik.pkcs.pkcs11.provider.LoginManager;
import iaik.pkcs.pkcs11.provider.TokenKeyStore;
import iaik.pkcs.pkcs11.provider.TokenKeyStoreSpi;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class TokenManager {
    private static final boolean DEBUG = false;
    protected static final Object moduleMapsLock_ = new Object();
    protected static final HashMap usedModulesMap_ = new HashMap(4);
    protected static final HashMap modulesUsageCounterMap_ = new HashMap(4);
    protected static final HashMap usedSlotsMap_ = new HashMap(4);
    protected IAIKPkcs11 myProvider_;
    protected String pkcs11ModulePath_;
    protected Module pkcs11module_;
    protected Slot slot_;
    protected LinkedList sessionROPool_;
    protected LinkedList sessionRWPool_;
    protected int sessionPoolMaxSize_;
    protected int openSessions_;
    protected int sessionsInPool_;
    protected int openedSessionsTotal_;
    protected Map sessionCloseLockCounts_ = new HashMap(4);
    protected Set sessionsToBeClosed_ = new HashSet(4);

    public TokenManager(IAIKPkcs11 iAIKPkcs11) throws IOException, TokenException, IAIKPkcs11Exception {
        Object object;
        Object object2;
        Slot[] slotArray;
        HashSet<Slot> hashSet;
        if (iAIKPkcs11 == null) {
            throw new NullPointerException("Argument \"myProvider\" must not be null");
        }
        this.myProvider_ = iAIKPkcs11;
        Properties properties = iAIKPkcs11.getProperties();
        String string = properties.getProperty("PKCS11_NATIVE_MODULE");
        String string2 = properties.getProperty("SLOT_ID");
        Module module = Module.getInstance(string);
        Object object3 = moduleMapsLock_;
        synchronized (object3) {
            hashSet = (Module)usedModulesMap_.get(module);
            if (hashSet != null) {
                module = hashSet;
            } else {
                usedModulesMap_.put(module, module);
            }
            slotArray = (Slot[])modulesUsageCounterMap_.get(module);
            if (slotArray == null) {
                String string3 = this.myProvider_.getModuleInitializationParameters();
                if (string3 == null) {
                    if (this.myProvider_.isMultiThreadInit()) {
                        object2 = new DefaultInitializeArgs(null, false, true);
                        module.initialize((InitializeArgs)object2);
                    } else {
                        module.initialize(null);
                    }
                } else {
                    object2 = new DefaultInitializeArgs();
                    object = string3.getBytes("UTF-8");
                    byte[] byArray = new byte[((byte[])object).length + 9];
                    System.arraycopy(object, 0, byArray, 0, ((byte[])object).length);
                    ((DefaultInitializeArgs)object2).setReserved(byArray);
                    module.initialize((InitializeArgs)object2);
                }
                slotArray = new Integer(1);
                modulesUsageCounterMap_.put(module, slotArray);
            } else {
                slotArray = new Integer(slotArray.intValue() + 1);
                modulesUsageCounterMap_.put(module, slotArray);
            }
        }
        object3 = usedSlotsMap_;
        synchronized (object3) {
            hashSet = (Set)usedSlotsMap_.get(module);
            if (hashSet == null) {
                hashSet = new HashSet<Slot>();
                usedSlotsMap_.put(module, hashSet);
            }
            if (string2 != null && !string2.equals("")) {
                long l2 = Long.parseLong(string2);
                object2 = hashSet.iterator();
                while (object2.hasNext()) {
                    object = (Slot)object2.next();
                    if (((Slot)object).getSlotID() != l2) continue;
                    this.slot_ = object;
                    break;
                }
                if (this.slot_ == null) {
                    object = module.getSlotList(false);
                    int n2 = 0;
                    while (n2 < ((Object)object).length) {
                        if (((Slot)object[n2]).getSlotID() == l2) {
                            this.slot_ = object[n2];
                            break;
                        }
                        ++n2;
                    }
                }
                if (this.slot_ == null) {
                    throw new IAIKPkcs11Exception("Slot with the configured ID " + l2 + " not found.");
                }
            } else {
                slotArray = module.getSlotList(true);
                if (slotArray.length > 0) {
                    int n3 = 0;
                    while (n3 < slotArray.length) {
                        if (!hashSet.contains(slotArray[n3])) {
                            this.slot_ = slotArray[n3];
                            break;
                        }
                        ++n3;
                    }
                }
                if (this.slot_ == null && (slotArray = module.getSlotList(false)).length > 0) {
                    int n4 = 0;
                    while (n4 < slotArray.length) {
                        if (!hashSet.contains(slotArray[n4])) {
                            this.slot_ = slotArray[n4];
                            break;
                        }
                        ++n4;
                    }
                }
                if (this.slot_ == null) {
                    throw new IAIKPkcs11Exception("No slot found for this module: " + module);
                }
            }
            hashSet.add(this.slot_);
        }
        this.pkcs11ModulePath_ = string;
        this.pkcs11module_ = module;
        this.sessionROPool_ = new LinkedList();
        this.sessionRWPool_ = new LinkedList();
        this.sessionPoolMaxSize_ = this.myProvider_.getSessionPoolMaxSize();
    }

    public void acquireSessionCloseLock(Session session) {
        Map map = this.sessionCloseLockCounts_;
        synchronized (map) {
            Integer n2 = (Integer)this.sessionCloseLockCounts_.get(session);
            int n3 = n2 == null ? 1 : n2 + 1;
            n2 = new Integer(n3);
            this.sessionCloseLockCounts_.put(session, n2);
        }
    }

    public void clearSessionPool(boolean bl) {
        LinkedList linkedList = this.sessionROPool_;
        synchronized (linkedList) {
            LinkedList linkedList2 = this.sessionRWPool_;
            synchronized (linkedList2) {
                if (bl) {
                    Session session;
                    Iterator iterator = this.sessionROPool_.iterator();
                    while (iterator.hasNext()) {
                        session = (Session)iterator.next();
                        this.closeSession(session);
                    }
                    iterator = this.sessionRWPool_.iterator();
                    while (iterator.hasNext()) {
                        session = (Session)iterator.next();
                        this.closeSession(session);
                    }
                }
                this.sessionROPool_.clear();
                this.sessionRWPool_.clear();
                this.sessionsInPool_ = 0;
            }
        }
    }

    public void closeSession(Session session) {
        if (session != null) {
            if (this.isSessionCloseLocked(session)) {
                this.setToBeClosed(session);
            } else {
                this.closeSessionNow(session);
            }
        }
    }

    protected void closeSessionNow(Session session) {
        block2: {
            if (session == null) break block2;
            try {
                session.closeSession();
                --this.openSessions_;
            }
            catch (TokenException tokenException) {}
        }
    }

    public void disposeSession(Session session) {
        block12: {
            if (session == null) break block12;
            try {
                SessionInfo sessionInfo = session.getSessionInfo();
                LinkedList linkedList = this.sessionROPool_;
                synchronized (linkedList) {
                    LinkedList linkedList2 = this.sessionRWPool_;
                    synchronized (linkedList2) {
                        int n2 = this.sessionROPool_.size() + this.sessionRWPool_.size();
                        if (n2 < this.sessionPoolMaxSize_) {
                            if (sessionInfo.isRwSession()) {
                                this.sessionRWPool_.addLast(session);
                                ++this.sessionsInPool_;
                            } else {
                                this.sessionROPool_.addLast(session);
                                ++this.sessionsInPool_;
                            }
                        } else {
                            this.closeSession(session);
                        }
                    }
                }
            }
            catch (TokenException tokenException) {
                this.closeSession(session);
            }
        }
    }

    public void finalize() throws Throwable {
        Object object = moduleMapsLock_;
        synchronized (object) {
            Integer n2 = (Integer)modulesUsageCounterMap_.get(this.pkcs11module_);
            if (n2 != null) {
                int n3 = n2;
                if (n3 > 1) {
                    modulesUsageCounterMap_.put(this.pkcs11module_, new Integer(--n3));
                } else {
                    modulesUsageCounterMap_.remove(this.pkcs11module_);
                    usedModulesMap_.remove(this.pkcs11module_);
                    this.pkcs11module_.finalize(null);
                }
            } else {
                usedModulesMap_.remove(this.pkcs11module_);
                this.pkcs11module_.finalize(null);
            }
        }
        super.finalize();
    }

    public TokenKeyStore getKeyStore() {
        TokenKeyStoreSpi tokenKeyStoreSpi = new TokenKeyStoreSpi(this);
        TokenKeyStore tokenKeyStore = new TokenKeyStore(tokenKeyStoreSpi, this.myProvider_, "TokenKeyStoreSpi");
        return tokenKeyStore;
    }

    public Module getModule() {
        return this.pkcs11module_;
    }

    public String getModulePath() {
        return this.pkcs11ModulePath_;
    }

    public IAIKPkcs11 getProvider() {
        return this.myProvider_;
    }

    public Session getSession(boolean bl) throws TokenException, IAIKPkcs11TokenUnavailableException {
        Session session;
        Token token = this.slot_.getToken();
        if (token != null) {
            do {
                LinkedList linkedList;
                if (!bl) {
                    linkedList = this.sessionROPool_;
                    synchronized (linkedList) {
                        if (this.sessionROPool_.size() > 0) {
                            session = (Session)this.sessionROPool_.removeFirst();
                            --this.sessionsInPool_;
                        } else {
                            session = token.openSession(true, bl, null, null);
                            ++this.openSessions_;
                            ++this.openedSessionsTotal_;
                        }
                    }
                }
                linkedList = this.sessionRWPool_;
                synchronized (linkedList) {
                    if (this.sessionRWPool_.size() > 0) {
                        session = (Session)this.sessionRWPool_.removeFirst();
                        --this.sessionsInPool_;
                    } else {
                        session = token.openSession(true, bl, null, null);
                        ++this.openSessions_;
                        ++this.openedSessionsTotal_;
                    }
                }
                try {
                    session.getSessionInfo();
                }
                catch (TokenException tokenException) {
                    this.clearSessionPool(true);
                    session = null;
                }
            } while (session == null);
        } else {
            this.clearSessionPool(false);
            throw new IAIKPkcs11TokenUnavailableException("Token unavailable.");
        }
        return session;
    }

    public Slot getSlot() {
        return this.slot_;
    }

    public Token getToken() throws TokenException {
        return this.slot_.getToken();
    }

    public boolean isMechanismFeatureSupported(Mechanism mechanism, MechanismInfo mechanismInfo) throws TokenException {
        boolean bl;
        if (mechanism == null) {
            throw new NullPointerException("Argument \"mechanism\" must not be null.");
        }
        Token token = this.getToken();
        if (token != null) {
            bl = false;
            Mechanism[] mechanismArray = token.getMechanismList();
            int n2 = 0;
            while (n2 < mechanismArray.length) {
                if (mechanism.equals(mechanismArray[n2])) {
                    MechanismInfo mechanismInfo2 = token.getMechanismInfo(mechanismArray[n2]);
                    if (mechanismInfo2.isDigest() || mechanismArray[n2].isDigestMechanism()) {
                        mechanismInfo2.setMaxKeySize(0L);
                        mechanismInfo2.setMinKeySize(0L);
                    }
                    if (mechanismInfo == null || mechanismInfo2.supports(mechanismInfo)) {
                        bl = true;
                        break;
                    }
                }
                ++n2;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isMechanismFeatureSupported(Mechanism[] mechanismArray, MechanismInfo[][] mechanismInfoArray) throws TokenException {
        boolean bl;
        block13: {
            if (mechanismArray == null) {
                throw new NullPointerException("Argument \"mechanisms\" must not be null.");
            }
            if (mechanismInfoArray == null) {
                throw new NullPointerException("Argument \"mechanismFeatures\" must not be null.");
            }
            if (mechanismArray.length != mechanismInfoArray.length) {
                throw new NullPointerException("The lengths of  \"mechanisms\" and \"mechanismFeatures\" must match.");
            }
            Token token = this.getToken();
            if (token != null) {
                try {
                    if (mechanismArray.length > 0) {
                        bl = false;
                        Mechanism[] mechanismArray2 = token.getMechanismList();
                        HashSet<Mechanism> hashSet = new HashSet<Mechanism>(mechanismArray2.length);
                        hashSet.addAll(Arrays.asList(mechanismArray2));
                        int n2 = 0;
                        while (n2 < mechanismArray.length) {
                            if (hashSet.contains(mechanismArray[n2])) {
                                int n3 = 0;
                                while (n3 < mechanismInfoArray[n2].length) {
                                    MechanismInfo mechanismInfo = token.getMechanismInfo(mechanismArray[n2]);
                                    if (mechanismInfo.isDigest() || mechanismArray[n2].isDigestMechanism()) {
                                        mechanismInfo.setMaxKeySize(0L);
                                        mechanismInfo.setMinKeySize(0L);
                                    }
                                    if (mechanismInfoArray[n2][n3] == null || mechanismInfo.supports(mechanismInfoArray[n2][n3])) {
                                        bl = true;
                                        break block13;
                                    }
                                    ++n3;
                                }
                            }
                            ++n2;
                        }
                        break block13;
                    }
                    bl = true;
                }
                catch (TokenException tokenException) {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isSessionCloseLocked(Session session) {
        boolean bl;
        Map map = this.sessionCloseLockCounts_;
        synchronized (map) {
            Integer n2 = (Integer)this.sessionCloseLockCounts_.get(session);
            bl = n2 != null;
        }
        return bl;
    }

    protected boolean isToBeClosed(Session session) {
        boolean bl;
        if (session != null) {
            Set set = this.sessionsToBeClosed_;
            synchronized (set) {
                bl = this.sessionsToBeClosed_.contains(session);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isTokenPresent() throws TokenException {
        return this.slot_.getSlotInfo().isTokenPresent();
    }

    public boolean loginUser(Session session, char[] cArray) throws TokenException, IAIKPkcs11AuthenticationCanceledException, IAIKPkcs11AuthenticationException {
        boolean bl;
        Slot slot = this.slot_;
        synchronized (slot) {
            State state;
            LoginManager loginManager = this.getProvider().getLoginManager();
            bl = session != null ? !(state = session.getSessionInfo().getState()).equals(State.RO_USER_FUNCTIONS) && !state.equals(State.RW_USER_FUNCTIONS) : true;
            if (bl) {
                if (cArray == null) {
                    cArray = this.getProvider().getUserPIN();
                }
                loginManager.loginUser(this, session, cArray);
            }
        }
        return bl;
    }

    public void logout(Session session) throws TokenException {
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        Slot slot = this.slot_;
        synchronized (slot) {
            LoginManager loginManager = this.getProvider().getLoginManager();
            loginManager.logout(this, session);
        }
    }

    public boolean makeAuthorizedSession(Session session, char[] cArray) throws TokenException, IAIKPkcs11TokenUnavailableException, IAIKPkcs11AuthenticationException {
        boolean bl;
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        Token token = this.slot_.getToken();
        if (token != null) {
            TokenInfo tokenInfo = this.slot_.getToken().getTokenInfo();
            bl = tokenInfo.isLoginRequired() ? this.loginUser(session, cArray) : false;
        } else {
            throw new IAIKPkcs11TokenUnavailableException("Token unavailable.");
        }
        return bl;
    }

    public void releaseSessionCloseLock(Session session) {
        Map map = this.sessionCloseLockCounts_;
        synchronized (map) {
            Integer n2 = (Integer)this.sessionCloseLockCounts_.get(session);
            if (n2 != null) {
                int n3 = n2;
                if (n3 <= 1) {
                    this.sessionCloseLockCounts_.remove(session);
                    if (this.isToBeClosed(session)) {
                        this.closeSessionNow(session);
                    }
                } else {
                    n2 = new Integer(--n3);
                    this.sessionCloseLockCounts_.put(session, n2);
                }
            }
        }
    }

    protected void setToBeClosed(Session session) {
        if (session != null) {
            Set set = this.sessionsToBeClosed_;
            synchronized (set) {
                this.sessionsToBeClosed_.add(session);
            }
        }
    }

    public void setUserPIN(Session session, char[] cArray, char[] cArray2) throws TokenException, IAIKPkcs11AuthenticationCanceledException, IAIKPkcs11AuthenticationException {
        Slot slot = this.slot_;
        synchronized (slot) {
            if (cArray == null) {
                cArray = this.getProvider().getUserPIN();
            }
            this.getProvider().getLoginManager().setUserPIN(this, session, cArray, cArray2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(this.slot_);
        stringBuffer.append(Constants.LINE_SEPARATOR);
        stringBuffer.append("open sessions in session pool: ");
        stringBuffer.append(this.openSessions_);
        stringBuffer.append(Constants.LINE_SEPARATOR);
        stringBuffer.append("sessions opened in total: ");
        stringBuffer.append(this.openedSessionsTotal_);
        return stringBuffer.toString();
    }

    public void waitForSlotEvent() throws TokenException {
        try {
            while (true) {
                Slot slot = this.pkcs11module_.waitForSlotEvent(true, null);
            }
        }
        catch (TokenException tokenException) {
            Slot slot;
            while (!(slot = this.pkcs11module_.waitForSlotEvent(false, null)).equals(this.slot_)) {
            }
            return;
        }
    }
}

