/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider;

import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.Name;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Certificate;
import iaik.pkcs.pkcs11.objects.CharArrayAttribute;
import iaik.pkcs.pkcs11.objects.DHPrivateKey;
import iaik.pkcs.pkcs11.objects.DHPublicKey;
import iaik.pkcs.pkcs11.objects.DSAPrivateKey;
import iaik.pkcs.pkcs11.objects.ECDSAPrivateKey;
import iaik.pkcs.pkcs11.objects.ECDSAPublicKey;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.objects.KEAPrivateKey;
import iaik.pkcs.pkcs11.objects.KEAPublicKey;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.Storage;
import iaik.pkcs.pkcs11.objects.X509AttributeCertificate;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import iaik.pkcs.pkcs11.provider.ComparableByteArray;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import iaik.utils.RFC2253NameParserException;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.attr.AttributeCertificate;
import iaik.x509.extensions.AuthorityKeyIdentifier;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.KeyUsage;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;

public class TokenKeyStoreSpi
extends KeyStoreSpi
implements PKCS11EngineClass {
    private static final boolean DEBUG = false;
    public static final String KEY_STORE_TYPE = "TokenKeyStoreSpi";
    protected TokenManager tokenManager_;
    protected Session readSession_;
    protected Session writeSession_;
    protected HashSet aliases_;
    protected Hashtable keys_;
    protected Hashtable certificateChains_;
    protected Hashtable trustedCertificates_;
    protected Hashtable keyAliasToPkcs11ObjectTable_;
    protected Hashtable certificateChainAliasToPkcs11ObjectsTable_;
    protected Hashtable trustedCertificateAliasToPkcs11ObjectTable_;
    protected boolean isUpToDate_;
    protected boolean useUserSession_;
    protected TokenInfo infoOfRecentToken_;
    protected byte[] lastNewID_;
    protected String supportProviderName_;
    protected Mechanism[] usedMechanisms_;
    protected MechanismInfo[] usedMechanismInfos_;
    protected char[] userPIN_;
    static /* synthetic */ Class class$java$security$spec$RSAPrivateCrtKeySpec;
    static /* synthetic */ Class class$java$security$spec$RSAPrivateKeySpec;
    static /* synthetic */ Class class$java$security$spec$DSAPrivateKeySpec;
    static /* synthetic */ Class class$java$security$spec$PKCS8EncodedKeySpec;
    static /* synthetic */ Class class$javax$crypto$spec$DHPrivateKeySpec;
    static /* synthetic */ Class class$java$security$spec$RSAPublicKeySpec;
    static /* synthetic */ Class class$java$security$spec$DSAPublicKeySpec;
    static /* synthetic */ Class class$java$security$spec$X509EncodedKeySpec;
    static /* synthetic */ Class class$javax$crypto$spec$DHPublicKeySpec;
    static /* synthetic */ Class class$javax$crypto$spec$SecretKeySpec;

    public TokenKeyStoreSpi() {
    }

    public TokenKeyStoreSpi(TokenManager tokenManager) {
        if (tokenManager == null) {
            throw new NullPointerException("Argument \"tokenManager\" must not be null");
        }
        this.tokenManager_ = tokenManager;
        this.initialize();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected synchronized void clearTables() {
        this.aliases_.clear();
        this.keys_.clear();
        this.certificateChains_.clear();
        this.trustedCertificates_.clear();
        this.keyAliasToPkcs11ObjectTable_.clear();
        this.certificateChainAliasToPkcs11ObjectsTable_.clear();
        this.trustedCertificateAliasToPkcs11ObjectTable_.clear();
    }

    protected synchronized Object createCertificate(java.security.cert.Certificate certificate, byte[] byArray, char[] cArray) throws KeyStoreException {
        if (certificate == null) {
            throw new NullPointerException("Argument \"certificate\" must not be null.");
        }
        try {
            this.ensureWriteSession();
        }
        catch (TokenException tokenException) {
            throw new KeyStoreException(tokenException.toString());
        }
        Object object = null;
        try {
            java.lang.Object object2;
            if (certificate instanceof java.security.cert.X509Certificate) {
                java.lang.Object object3;
                java.lang.Object object4;
                java.lang.Object object5;
                java.lang.Object object6;
                java.lang.Object object7;
                X509Certificate x509Certificate = certificate instanceof X509Certificate ? (X509Certificate)certificate : new X509Certificate(certificate.getEncoded());
                byte[] byArray2 = null;
                if (byArray == null) {
                    object7 = null;
                    object6 = x509Certificate.getPublicKey();
                    if (object6 instanceof RSAPublicKey) {
                        object5 = ((RSAPublicKey)object6).getModulus().toByteArray();
                        if (object7 == null) {
                            object7 = this.supportProviderName_ != null ? MessageDigest.getInstance("SHA-1", this.supportProviderName_) : MessageDigest.getInstance("SHA-1");
                        }
                        byArray2 = ((MessageDigest)object7).digest((byte[])object5);
                    } else if (object6 instanceof DSAPublicKey) {
                        object5 = ((DSAPublicKey)object6).getY().toByteArray();
                        if (object7 == null) {
                            object7 = this.supportProviderName_ != null ? MessageDigest.getInstance("SHA-1", this.supportProviderName_) : MessageDigest.getInstance("SHA-1");
                        }
                        byArray2 = ((MessageDigest)object7).digest((byte[])object5);
                    } else {
                        byArray2 = x509Certificate.getFingerprint("SHA-1");
                    }
                    byArray2 = this.generateNewID(byArray2);
                } else {
                    byArray2 = byArray;
                }
                object7 = new X509PublicKeyCertificate();
                object6 = x509Certificate.getSerialNumber().toByteArray();
                object5 = (Name)x509Certificate.getSubjectDN();
                Name name = (Name)x509Certificate.getIssuerDN();
                if (cArray == null) {
                    object4 = ((Name)object5).getRDN(ObjectID.commonName);
                    object3 = name.getRDN(ObjectID.commonName);
                    cArray = (String.valueOf(object4) + "'s " + (object3 != null ? String.valueOf(object3) + " " : "") + "Certificate").toCharArray();
                }
                ((Storage)object7).getToken().setBooleanValue(Boolean.TRUE);
                ((Storage)object7).getPrivate().setBooleanValue(Boolean.FALSE);
                ((Storage)object7).getLabel().setCharArrayValue(cArray);
                ((X509PublicKeyCertificate)object7).getId().setByteArrayValue(byArray2);
                object4 = ((Name)object5).getEncoded();
                ((X509PublicKeyCertificate)object7).getSubject().setByteArrayValue((byte[])object4);
                object3 = name.getEncoded();
                ((X509PublicKeyCertificate)object7).getIssuer().setByteArrayValue((byte[])object3);
                ((X509PublicKeyCertificate)object7).getSerialNumber().setByteArrayValue((byte[])object6);
                ((X509PublicKeyCertificate)object7).getValue().setByteArrayValue(x509Certificate.getEncoded());
                object2 = object7;
            } else if (certificate instanceof AttributeCertificate) {
                java.lang.Object object8;
                AttributeCertificate attributeCertificate = (AttributeCertificate)certificate;
                X509AttributeCertificate x509AttributeCertificate = new X509AttributeCertificate();
                byte[] byArray3 = attributeCertificate.getSerialNumber().toByteArray();
                if (cArray == null) {
                    cArray = "Attribute Certificate".toCharArray();
                }
                byte[] byArray4 = DerCoder.encode(attributeCertificate.getHolder().toASN1Object());
                byte[] byArray5 = DerCoder.encode(attributeCertificate.getIssuer().toASN1Object());
                SEQUENCE sEQUENCE = new SEQUENCE();
                Enumeration enumeration = attributeCertificate.getAttributes();
                while (enumeration.hasMoreElements()) {
                    object8 = (Attribute)enumeration.nextElement();
                    sEQUENCE.addComponent(((Attribute)object8).getType());
                }
                object8 = DerCoder.encode(sEQUENCE);
                x509AttributeCertificate.getToken().setBooleanValue(Boolean.TRUE);
                x509AttributeCertificate.getPrivate().setBooleanValue(Boolean.FALSE);
                x509AttributeCertificate.getLabel().setCharArrayValue(cArray);
                x509AttributeCertificate.getOwner().setByteArrayValue(byArray4);
                x509AttributeCertificate.getAcIssuer().setByteArrayValue(byArray5);
                x509AttributeCertificate.getSerialNumber().setByteArrayValue(byArray3);
                x509AttributeCertificate.getAttrTypes().setByteArrayValue((byte[])object8);
                x509AttributeCertificate.getValue().setByteArrayValue(attributeCertificate.getEncoded());
                object2 = x509AttributeCertificate;
            } else {
                throw new KeyStoreException("Unsupported certificate type: " + certificate.getClass().getName());
            }
            object = this.writeSession_.createObject((Object)object2);
        }
        catch (Exception exception) {
            throw new KeyStoreException(exception.toString());
        }
        return object;
    }

    protected synchronized X509Certificate[] createCertificateChain(X509Certificate x509Certificate, Map map) {
        if (x509Certificate == null) {
            throw new NullPointerException("Argument \"userCertificate\" must not be null.");
        }
        if (map == null) {
            throw new NullPointerException("Argument \"subjectToCertificatesMap\" must not be null.");
        }
        Vector<X509Certificate> vector = new Vector<X509Certificate>(4);
        vector.add(x509Certificate);
        X509Certificate x509Certificate2 = x509Certificate;
        int n2 = 100;
        try {
            Name name = (Name)x509Certificate2.getIssuerDN();
            X509Certificate x509Certificate3 = (X509Certificate)map.get(name.getRFC2253String());
            while (x509Certificate3 != null && !x509Certificate2.equals(x509Certificate3) && n2-- > 0) {
                AuthorityKeyIdentifier authorityKeyIdentifier = (AuthorityKeyIdentifier)x509Certificate2.getExtension(AuthorityKeyIdentifier.oid);
                SubjectKeyIdentifier subjectKeyIdentifier = (SubjectKeyIdentifier)x509Certificate3.getExtension(SubjectKeyIdentifier.oid);
                if (authorityKeyIdentifier == null || subjectKeyIdentifier == null || Arrays.equals(authorityKeyIdentifier.getKeyIdentifier(), subjectKeyIdentifier.get())) {
                    vector.add(x509Certificate3);
                    x509Certificate2 = x509Certificate3;
                    name = (Name)x509Certificate2.getIssuerDN();
                    x509Certificate3 = (X509Certificate)map.get(name.getRFC2253String());
                    continue;
                }
                break;
            }
        }
        catch (RFC2253NameParserException rFC2253NameParserException) {
            rFC2253NameParserException.printStackTrace(IAIKPkcs11.errorStream_);
        }
        catch (X509ExtensionException x509ExtensionException) {
            x509ExtensionException.printStackTrace(IAIKPkcs11.errorStream_);
        }
        return vector.toArray(new X509Certificate[vector.size()]);
    }

    protected iaik.pkcs.pkcs11.objects.Key createKeyCreationTemplate(iaik.pkcs.pkcs11.objects.Key key) {
        if (key == null) {
            throw new NullPointerException("Argument \"baseKey\" must not be null.");
        }
        iaik.pkcs.pkcs11.objects.Key key2 = (iaik.pkcs.pkcs11.objects.Key)key.clone();
        key2.getKeyGenMechanism().setPresent(false);
        key2.getLocal().setPresent(false);
        if (key2 instanceof iaik.pkcs.pkcs11.objects.PrivateKey) {
            iaik.pkcs.pkcs11.objects.PrivateKey privateKey = (iaik.pkcs.pkcs11.objects.PrivateKey)key2;
            privateKey.getAuthPinFlags().setPresent(false);
            privateKey.getAlwaysSensitive().setPresent(false);
            privateKey.getNeverExtractable().setPresent(false);
            if (key2 instanceof DHPrivateKey) {
                DHPrivateKey dHPrivateKey = (DHPrivateKey)key2;
                dHPrivateKey.getValueBits().setPresent(false);
            }
        } else if (key2 instanceof iaik.pkcs.pkcs11.objects.PublicKey) {
            if (key2 instanceof iaik.pkcs.pkcs11.objects.RSAPublicKey) {
                iaik.pkcs.pkcs11.objects.RSAPublicKey rSAPublicKey = (iaik.pkcs.pkcs11.objects.RSAPublicKey)key2;
                rSAPublicKey.getModulusBits().setPresent(false);
            }
        } else if (key2 instanceof iaik.pkcs.pkcs11.objects.SecretKey) {
            iaik.pkcs.pkcs11.objects.SecretKey secretKey = (iaik.pkcs.pkcs11.objects.SecretKey)key2;
            secretKey.getAlwaysSensitive().setPresent(false);
            secretKey.getNeverExtractable().setPresent(false);
            iaik.pkcs.pkcs11.objects.Attribute attribute = (iaik.pkcs.pkcs11.objects.Attribute)secretKey.getAttributeTable().get(iaik.pkcs.pkcs11.objects.Attribute.VALUE_LEN);
            if (attribute != null) {
                attribute.setPresent(false);
            }
        }
        return key2;
    }

    protected KeySpec createKeySpec(Key key, Class clazz) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        KeyFactory keyFactory;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument \"keySpecClass\" must not be null.");
        }
        try {
            keyFactory = this.supportProviderName_ != null ? KeyFactory.getInstance(key.getAlgorithm(), this.supportProviderName_) : KeyFactory.getInstance(key.getAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            keyFactory = KeyFactory.getInstance(key.getAlgorithm());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            keyFactory = KeyFactory.getInstance(key.getAlgorithm());
        }
        java.lang.Object t2 = keyFactory.getKeySpec(key, clazz);
        return t2;
    }

    protected KeySpec createPrivateKeySpec(Key key) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        Class clazz;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        String string = key.getAlgorithm();
        if (string.equalsIgnoreCase("RSA")) {
            clazz = key instanceof RSAPrivateCrtKey ? (class$java$security$spec$RSAPrivateCrtKeySpec != null ? class$java$security$spec$RSAPrivateCrtKeySpec : (class$java$security$spec$RSAPrivateCrtKeySpec = TokenKeyStoreSpi.class$("java.security.spec.RSAPrivateCrtKeySpec"))) : (class$java$security$spec$RSAPrivateKeySpec != null ? class$java$security$spec$RSAPrivateKeySpec : (class$java$security$spec$RSAPrivateKeySpec = TokenKeyStoreSpi.class$("java.security.spec.RSAPrivateKeySpec")));
        } else if (string.equalsIgnoreCase("DSA")) {
            clazz = class$java$security$spec$DSAPrivateKeySpec != null ? class$java$security$spec$DSAPrivateKeySpec : (class$java$security$spec$DSAPrivateKeySpec = TokenKeyStoreSpi.class$("java.security.spec.DSAPrivateKeySpec"));
        } else if (string.equalsIgnoreCase("ECDSA")) {
            clazz = class$java$security$spec$PKCS8EncodedKeySpec != null ? class$java$security$spec$PKCS8EncodedKeySpec : (class$java$security$spec$PKCS8EncodedKeySpec = TokenKeyStoreSpi.class$("java.security.spec.PKCS8EncodedKeySpec"));
        } else if (string.equalsIgnoreCase("DH")) {
            clazz = class$javax$crypto$spec$DHPrivateKeySpec != null ? class$javax$crypto$spec$DHPrivateKeySpec : (class$javax$crypto$spec$DHPrivateKeySpec = TokenKeyStoreSpi.class$("javax.crypto.spec.DHPrivateKeySpec"));
        } else {
            throw new KeyStoreException("No means to convert key of algorithm: " + string);
        }
        return this.createKeySpec(key, clazz);
    }

    protected KeySpec createPublicKeySpec(Key key) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        Class clazz;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        String string = key.getAlgorithm();
        if (string.equalsIgnoreCase("RSA")) {
            clazz = class$java$security$spec$RSAPublicKeySpec != null ? class$java$security$spec$RSAPublicKeySpec : (class$java$security$spec$RSAPublicKeySpec = TokenKeyStoreSpi.class$("java.security.spec.RSAPublicKeySpec"));
        } else if (string.equalsIgnoreCase("DSA")) {
            clazz = class$java$security$spec$DSAPublicKeySpec != null ? class$java$security$spec$DSAPublicKeySpec : (class$java$security$spec$DSAPublicKeySpec = TokenKeyStoreSpi.class$("java.security.spec.DSAPublicKeySpec"));
        } else if (string.equalsIgnoreCase("ECDSA")) {
            clazz = class$java$security$spec$X509EncodedKeySpec != null ? class$java$security$spec$X509EncodedKeySpec : (class$java$security$spec$X509EncodedKeySpec = TokenKeyStoreSpi.class$("java.security.spec.X509EncodedKeySpec"));
        } else if (string.equalsIgnoreCase("DH")) {
            clazz = class$javax$crypto$spec$DHPublicKeySpec != null ? class$javax$crypto$spec$DHPublicKeySpec : (class$javax$crypto$spec$DHPublicKeySpec = TokenKeyStoreSpi.class$("javax.crypto.spec.DHPublicKeySpec"));
        } else {
            throw new KeyStoreException("No means to convert key of algorithm: " + string);
        }
        return this.createKeySpec(key, clazz);
    }

    protected KeySpec createSecretKeySpec(SecretKey secretKey) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        if (secretKey == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        String string = secretKey.getAlgorithm();
        Class clazz = class$javax$crypto$spec$SecretKeySpec != null ? class$javax$crypto$spec$SecretKeySpec : (class$javax$crypto$spec$SecretKeySpec = TokenKeyStoreSpi.class$("javax.crypto.spec.SecretKeySpec"));
        SecretKeyFactory secretKeyFactory = this.supportProviderName_ != null ? SecretKeyFactory.getInstance(string, this.supportProviderName_) : SecretKeyFactory.getInstance(string);
        KeySpec keySpec = secretKeyFactory.getKeySpec(secretKey, clazz);
        return keySpec;
    }

    protected synchronized String createUniqueAlias(Object object, Set set) {
        java.lang.Object object2;
        java.lang.Object object3;
        java.lang.Object object4;
        if (object == null) {
            throw new NullPointerException("Argument \"pkcs11Object\" must not be null.");
        }
        if (set == null) {
            throw new NullPointerException("Argument \"usedAliases\" must not be null.");
        }
        String string = object instanceof Storage ? ((object4 = ((Storage)(object3 = (Storage)object)).getLabel()) != null ? ((object2 = ((CharArrayAttribute)object4).getCharArrayValue()) != null ? new String((char[])object2) : String.valueOf(object.getObjectHandle())) : new String(Object.getObjectClassName(object.getObjectClass().getLongValue()))) : new String(Object.getObjectClassName(object.getObjectClass().getLongValue()));
        if (set.contains(string)) {
            object3 = new StringBuffer(string.length() + 16);
            ((StringBuffer)object3).append(string);
            ((StringBuffer)object3).append('(');
            ((StringBuffer)object3).append(object.getObjectHandle());
            ((StringBuffer)object3).append(')');
            string = ((StringBuffer)object3).toString();
        }
        int n2 = 2;
        object4 = string;
        while (set.contains(object4)) {
            object2 = new StringBuffer(string.length() + 4);
            ((StringBuffer)object2).append(string);
            ((StringBuffer)object2).append('[');
            ((StringBuffer)object2).append(n2);
            ((StringBuffer)object2).append(']');
            object4 = ((StringBuffer)object2).toString();
        }
        return string;
    }

    protected synchronized void deleteCertificate(String string) throws TokenException {
        if (string != null) {
            Object object = (Object)this.trustedCertificateAliasToPkcs11ObjectTable_.get(string);
            if (object != null) {
                this.writeSession_.destroyObject(object);
                this.trustedCertificateAliasToPkcs11ObjectTable_.remove(string);
            }
            this.trustedCertificates_.remove(string);
        }
    }

    protected synchronized void deleteChertificateChain(String string) throws TokenException {
        if (string != null) {
            Object[] objectArray = (Object[])this.certificateChainAliasToPkcs11ObjectsTable_.get(string);
            if (objectArray != null) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    char[] cArray;
                    if (objectArray[n2] != null && (cArray = ((Storage)objectArray[n2]).getLabel().getCharArrayValue()) != null && string.equals(new String(cArray))) {
                        this.writeSession_.destroyObject(objectArray[n2]);
                    }
                    ++n2;
                }
                this.certificateChainAliasToPkcs11ObjectsTable_.remove(string);
            }
            this.certificateChains_.remove(string);
        }
    }

    protected synchronized void deleteKey(String string) throws TokenException {
        if (string != null) {
            Object object = (Object)this.keyAliasToPkcs11ObjectTable_.get(string);
            if (object != null) {
                this.writeSession_.destroyObject(object);
                this.keyAliasToPkcs11ObjectTable_.remove(string);
            }
            this.keys_.remove(string);
        }
    }

    public synchronized Enumeration engineAliases() {
        Set set;
        this.ensureSupportProvider();
        try {
            try {
                this.ensureReadSession();
                this.ensureCurrentTables();
                set = (Set)this.aliases_.clone();
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception(tokenException.toString());
            }
            java.lang.Object var3_3 = null;
            this.releaseSessions();
        }
        catch (Throwable throwable) {
            java.lang.Object var3_4 = null;
            this.releaseSessions();
            throw throwable;
        }
        return Collections.enumeration(set);
    }

    public synchronized boolean engineContainsAlias(String string) {
        this.ensureSupportProvider();
        try {
            try {
                this.ensureReadSession();
                this.ensureCurrentTables();
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception(tokenException.toString());
            }
            java.lang.Object var3_3 = null;
            this.releaseSessions();
        }
        catch (Throwable throwable) {
            java.lang.Object var3_4 = null;
            this.releaseSessions();
            throw throwable;
        }
        return this.aliases_.contains(string);
    }

    public synchronized void engineDeleteEntry(String string) throws KeyStoreException {
        if (string == null) {
            throw new NullPointerException("Argument \"alias\" must not be null.");
        }
        this.ensureSupportProvider();
        if (this.aliases_.contains(string)) {
            try {
                try {
                    this.ensureWriteSession();
                    if (this.keyAliasToPkcs11ObjectTable_.containsKey(string)) {
                        this.deleteKey(string);
                    }
                    if (this.certificateChainAliasToPkcs11ObjectsTable_.containsKey(string)) {
                        this.deleteChertificateChain(string);
                    }
                    if (this.trustedCertificateAliasToPkcs11ObjectTable_.containsKey(string)) {
                        this.deleteCertificate(string);
                    }
                    this.aliases_.remove(string);
                }
                catch (TokenException tokenException) {
                    throw new KeyStoreException(tokenException.toString());
                }
                java.lang.Object var3_3 = null;
                this.releaseSessions();
            }
            catch (Throwable throwable) {
                java.lang.Object var3_4 = null;
                this.releaseSessions();
                throw throwable;
            }
        }
        throw new KeyStoreException("No entry with alias \"" + string + "\".");
    }

    public synchronized java.security.cert.Certificate engineGetCertificate(String string) {
        java.security.cert.Certificate certificate;
        if (string == null) {
            throw new NullPointerException("Argument \"alias\" must not be null.");
        }
        this.ensureSupportProvider();
        try {
            try {
                this.ensureReadSession();
                this.ensureCurrentTables();
                java.security.cert.Certificate[] certificateArray = (java.security.cert.Certificate[])this.certificateChains_.get(string);
                certificate = certificateArray != null && certificateArray.length > 0 ? certificateArray[0] : (java.security.cert.Certificate)this.trustedCertificates_.get(string);
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception(tokenException.toString());
            }
            java.lang.Object var4_5 = null;
            this.releaseSessions();
        }
        catch (Throwable throwable) {
            java.lang.Object var4_6 = null;
            this.releaseSessions();
            throw throwable;
        }
        return certificate;
    }

    public synchronized String engineGetCertificateAlias(java.security.cert.Certificate certificate) {
        if (certificate == null) {
            throw new NullPointerException("argument \"certificate\" must not be null");
        }
        this.ensureSupportProvider();
        String string = null;
        try {
            block7: {
                try {
                    java.lang.Object object;
                    String string2;
                    this.ensureReadSession();
                    this.ensureCurrentTables();
                    Enumeration enumeration = this.certificateChains_.keys();
                    while (enumeration.hasMoreElements()) {
                        string2 = enumeration.nextElement().toString();
                        object = (java.security.cert.Certificate[])this.certificateChains_.get(string2);
                        if (object == null || ((java.security.cert.Certificate[])object).length <= 0 || !certificate.equals(object[0])) continue;
                        string = string2;
                        break;
                    }
                    if (string != null) break block7;
                    enumeration = this.trustedCertificates_.keys();
                    while (enumeration.hasMoreElements()) {
                        string2 = enumeration.nextElement().toString();
                        object = (java.security.cert.Certificate)this.trustedCertificates_.get(string2);
                        if (!certificate.equals(object)) continue;
                        string = string2;
                        break;
                    }
                }
                catch (TokenException tokenException) {
                    throw new IAIKPkcs11Exception(tokenException.toString());
                }
            }
            java.lang.Object var4_7 = null;
            this.releaseSessions();
        }
        catch (Throwable throwable) {
            java.lang.Object var4_8 = null;
            this.releaseSessions();
            throw throwable;
        }
        return string;
    }

    public synchronized java.security.cert.Certificate[] engineGetCertificateChain(String string) {
        java.security.cert.Certificate[] certificateArray;
        if (string == null) {
            throw new NullPointerException("Argument \"alias\" must not be null.");
        }
        this.ensureSupportProvider();
        try {
            try {
                this.ensureReadSession();
                this.ensureCurrentTables();
                certificateArray = (java.security.cert.X509Certificate[])this.certificateChains_.get(string);
                if (certificateArray == null) {
                    certificateArray = new java.security.cert.X509Certificate[]{};
                }
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception(tokenException.toString());
            }
            java.lang.Object var4_4 = null;
            this.releaseSessions();
        }
        catch (Throwable throwable) {
            java.lang.Object var4_5 = null;
            this.releaseSessions();
            throw throwable;
        }
        return certificateArray;
    }

    public Date engineGetCreationDate(String string) {
        Date date = null;
        return date;
    }

    public synchronized Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Key key;
        this.ensureSupportProvider();
        try {
            block8: {
                try {
                    this.ensureReadSession();
                    this.ensureCurrentTables();
                    key = (Key)this.keys_.get(string);
                    if (key != null) break block8;
                    try {
                        if (this.tokenManager_.isTokenPresent()) {
                            if (this.loginSession()) {
                                this.setUpToDate(false);
                            }
                            this.ensureCurrentTables();
                            key = (Key)this.keys_.get(string);
                        }
                    }
                    catch (TokenException tokenException) {
                        throw new IAIKPkcs11Exception(tokenException.toString());
                    }
                }
                catch (TokenException tokenException) {
                    throw new IAIKPkcs11Exception(tokenException.toString());
                }
            }
            java.lang.Object var5_6 = null;
            this.releaseSessions();
        }
        catch (Throwable throwable) {
            java.lang.Object var5_7 = null;
            this.releaseSessions();
            throw throwable;
        }
        return key;
    }

    public synchronized boolean engineIsCertificateEntry(String string) {
        this.ensureSupportProvider();
        try {
            try {
                this.ensureReadSession();
                this.ensureCurrentTables();
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception(tokenException.toString());
            }
            java.lang.Object var3_3 = null;
            this.releaseSessions();
        }
        catch (Throwable throwable) {
            java.lang.Object var3_4 = null;
            this.releaseSessions();
            throw throwable;
        }
        return this.trustedCertificates_.containsKey(string);
    }

    public synchronized boolean engineIsKeyEntry(String string) {
        this.ensureSupportProvider();
        try {
            try {
                this.ensureReadSession();
                this.ensureCurrentTables();
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception(tokenException.toString());
            }
            java.lang.Object var3_3 = null;
            this.releaseSessions();
        }
        catch (Throwable throwable) {
            java.lang.Object var3_4 = null;
            this.releaseSessions();
            throw throwable;
        }
        return this.keys_.containsKey(string) || this.certificateChains_.containsKey(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void engineLoad(InputStream inputStream, char[] cArray) throws IOException, UnsupportedOperationException {
        java.lang.Object object;
        if (inputStream != null) {
            object = this.readProviderName(inputStream);
            int n2 = IAIKPkcs11.getProviderInstanceNumber((String)object);
            if (n2 <= 0) throw new IAIKPkcs11Exception("The IAIKPkcs11 provider with the given name does not exist.");
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getProviderInstance(n2);
            this.tokenManager_ = iAIKPkcs11.getTokenManager();
        } else if (this.tokenManager_ == null) {
            object = IAIKPkcs11.getProviderInstance(1);
            if (object == null) throw new UnsupportedOperationException("Cannot initialize key store. Could not find a IAIKPkcs11 provider.");
            this.tokenManager_ = ((IAIKPkcs11)object).getTokenManager();
        }
        if (cArray != null) {
            try {
                this.tokenManager_.loginUser(null, cArray);
                this.userPIN_ = cArray;
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception("Failed to login the user with the provided PIN: " + tokenException);
            }
        }
        this.initialize();
    }

    public synchronized void engineSetCertificateEntry(String string, java.security.cert.Certificate certificate) throws KeyStoreException {
        if (string == null) {
            throw new NullPointerException("Argument \"alias\" must not be null.");
        }
        if (certificate == null) {
            throw new NullPointerException("Argument \"certificate\" must not be null.");
        }
        this.ensureSupportProvider();
        try {
            try {
                Object object;
                this.ensureWriteSession();
                if (this.trustedCertificates_.containsKey(string)) {
                    object = (Object)this.trustedCertificateAliasToPkcs11ObjectTable_.get(string);
                    if (object != null) {
                        this.trustedCertificates_.remove(string);
                        this.aliases_.remove(string);
                        try {
                            this.writeSession_.destroyObject(object);
                        }
                        catch (TokenException tokenException) {
                            throw new KeyStoreException("Could not remove already existing certificate with this alias: " + tokenException.toString());
                        }
                    } else {
                        this.trustedCertificateAliasToPkcs11ObjectTable_.remove(string);
                    }
                }
                object = this.createCertificate(certificate, null, string.toCharArray());
                this.trustedCertificateAliasToPkcs11ObjectTable_.put(string, object);
                this.trustedCertificates_.put(string, certificate);
                this.aliases_.add(string);
            }
            catch (TokenException tokenException) {
                throw new KeyStoreException(tokenException.toString());
            }
            java.lang.Object var4_6 = null;
            this.releaseSessions();
        }
        catch (Throwable throwable) {
            java.lang.Object var4_7 = null;
            this.releaseSessions();
            throw throwable;
        }
    }

    public synchronized void engineSetKeyEntry(String string, Key key, char[] cArray, java.security.cert.Certificate[] certificateArray) throws KeyStoreException {
        if (string == null) {
            throw new NullPointerException("Argument \"alias\" must not be null.");
        }
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        this.ensureSupportProvider();
        try {
            try {
                IAIKPKCS11Key iAIKPKCS11Key;
                java.lang.Object object;
                java.lang.Object object2;
                java.lang.Object object3;
                java.lang.Object object4;
                java.lang.Object object5;
                java.lang.Object object6;
                java.lang.Object object7;
                java.lang.Object object8;
                X509Certificate x509Certificate;
                this.ensureWriteSession();
                this.ensureCurrentTables();
                X509Certificate[] x509CertificateArray = Util.convertCertificateChain(certificateArray);
                if (x509CertificateArray != null && x509CertificateArray.length > 0) {
                    x509CertificateArray = Util.arrangeCertificateChain(x509CertificateArray, false);
                    x509Certificate = x509CertificateArray[0];
                } else {
                    x509Certificate = null;
                }
                Object object9 = null;
                boolean bl = false;
                if (this.aliases_.contains(string)) {
                    if (this.keys_.containsKey(string)) {
                        object9 = (Object)this.keyAliasToPkcs11ObjectTable_.get(string);
                        bl = true;
                    }
                    if (this.certificateChains_.containsKey(string)) {
                        this.deleteChertificateChain(string);
                    }
                    if (this.trustedCertificates_.containsKey(string)) {
                        this.deleteCertificate(string);
                    }
                }
                if (key instanceof IAIKPKCS11Key) {
                    object8 = (IAIKPKCS11Key)key;
                    object7 = object8.getTokenManager().getToken();
                    if (((Token)object7).equals(object6 = this.tokenManager_.getToken())) {
                        byte[] byArray;
                        Cloneable cloneable;
                        java.lang.Object object10;
                        object5 = object8.getKeyObject();
                        object4 = new GenericTemplate();
                        object3 = ((Storage)object5).getLabel().getCharArrayValue();
                        object2 = string.toCharArray();
                        if (object3 == null && !Arrays.equals((char[])object3, (char[])object2)) {
                            object10 = new CharArrayAttribute(iaik.pkcs.pkcs11.objects.Attribute.LABEL);
                            ((CharArrayAttribute)object10).setCharArrayValue((char[])object2);
                            ((GenericTemplate)object4).addAttribute((iaik.pkcs.pkcs11.objects.Attribute)object10);
                        }
                        if ((object10 = ((iaik.pkcs.pkcs11.objects.Key)object5).getId().getByteArrayValue()) == null) {
                            cloneable = new ByteArrayAttribute(iaik.pkcs.pkcs11.objects.Attribute.ID);
                            byArray = this.generateNewID(null);
                            ((ByteArrayAttribute)cloneable).setByteArrayValue(byArray);
                            ((GenericTemplate)object4).addAttribute((iaik.pkcs.pkcs11.objects.Attribute)cloneable);
                        } else {
                            byArray = null;
                        }
                        if (bl && object9 != null) {
                            if (object9.equals(object5)) {
                                if (((Storage)object5).getToken().getBooleanValue().booleanValue()) {
                                    if (((Object)object4).getSetAttributes().size() > 0) {
                                        this.writeSession_.setAttributeValues((Object)object5, (Object)object4);
                                        if (byArray != null) {
                                            ((iaik.pkcs.pkcs11.objects.Key)object5).getId().setByteArrayValue(byArray);
                                        }
                                    }
                                    object = object5;
                                } else {
                                    cloneable = new BooleanAttribute(iaik.pkcs.pkcs11.objects.Attribute.TOKEN);
                                    ((BooleanAttribute)cloneable).setBooleanValue(Boolean.TRUE);
                                    ((GenericTemplate)object4).addAttribute((iaik.pkcs.pkcs11.objects.Attribute)cloneable);
                                    object = (iaik.pkcs.pkcs11.objects.Key)this.writeSession_.copyObject((Object)object5, (Object)object4);
                                    this.writeSession_.destroyObject(object9);
                                }
                                if (object instanceof iaik.pkcs.pkcs11.objects.PrivateKey && byArray != null && (cloneable = (iaik.pkcs.pkcs11.objects.PublicKey)this.findCoreespondingKey((iaik.pkcs.pkcs11.objects.Key)object)) != null && ((iaik.pkcs.pkcs11.objects.Key)cloneable).getId().getByteArrayValue() == null) {
                                    GenericTemplate genericTemplate = new GenericTemplate();
                                    ByteArrayAttribute byteArrayAttribute = new ByteArrayAttribute(iaik.pkcs.pkcs11.objects.Attribute.ID);
                                    byteArrayAttribute.setByteArrayValue(byArray);
                                    genericTemplate.addAttribute(byteArrayAttribute);
                                    this.writeSession_.setAttributeValues((Object)cloneable, genericTemplate);
                                }
                            } else {
                                this.writeSession_.destroyObject(object9);
                                cloneable = new BooleanAttribute(iaik.pkcs.pkcs11.objects.Attribute.TOKEN);
                                ((BooleanAttribute)cloneable).setBooleanValue(Boolean.TRUE);
                                ((GenericTemplate)object4).addAttribute((iaik.pkcs.pkcs11.objects.Attribute)cloneable);
                                object = (iaik.pkcs.pkcs11.objects.Key)this.writeSession_.copyObject((Object)object5, (Object)object4);
                            }
                        } else {
                            cloneable = new BooleanAttribute(iaik.pkcs.pkcs11.objects.Attribute.TOKEN);
                            ((BooleanAttribute)cloneable).setBooleanValue(Boolean.TRUE);
                            ((GenericTemplate)object4).addAttribute((iaik.pkcs.pkcs11.objects.Attribute)cloneable);
                            object = (iaik.pkcs.pkcs11.objects.Key)this.writeSession_.copyObject((Object)object5, (Object)object4);
                        }
                    } else {
                        if (bl && object9 != null) {
                            this.writeSession_.destroyObject(object9);
                        }
                        object5 = object8.getKeyObject();
                        object4 = this.createKeyCreationTemplate((iaik.pkcs.pkcs11.objects.Key)object5);
                        object3 = this.generateNewID(null);
                        ((iaik.pkcs.pkcs11.objects.Key)object4).getId().setByteArrayValue((byte[])object3);
                        ((Storage)object4).getLabel().setCharArrayValue(string.toCharArray());
                        object = (iaik.pkcs.pkcs11.objects.Key)this.writeSession_.createObject((Object)object4);
                    }
                    if (object instanceof iaik.pkcs.pkcs11.objects.PrivateKey) {
                        iAIKPKCS11Key = IAIKPKCS11PrivateKey.create(this.tokenManager_, (iaik.pkcs.pkcs11.objects.PrivateKey)object);
                    } else if (object instanceof iaik.pkcs.pkcs11.objects.PublicKey) {
                        iAIKPKCS11Key = IAIKPKCS11PublicKey.create(this.tokenManager_, (iaik.pkcs.pkcs11.objects.PublicKey)object);
                    } else if (object instanceof iaik.pkcs.pkcs11.objects.SecretKey) {
                        iAIKPKCS11Key = IAIKPKCS11SecretKey.create(this.tokenManager_, (iaik.pkcs.pkcs11.objects.SecretKey)object);
                    } else {
                        throw new KeyStoreException("Unknown key type: " + object.getClass().getName());
                    }
                    this.keyAliasToPkcs11ObjectTable_.put(string, object);
                    this.keys_.put(string, iAIKPKCS11Key);
                    this.aliases_.add(string);
                } else {
                    if (bl && object9 != null) {
                        this.writeSession_.destroyObject(object9);
                    }
                    object8 = this.generateNewID(null);
                    object7 = key.getAlgorithm();
                    if (key instanceof PrivateKey) {
                        object6 = new iaik.pkcs.pkcs11.objects.PrivateKey();
                        ((Storage)object6).getToken().setBooleanValue(Boolean.TRUE);
                        ((iaik.pkcs.pkcs11.objects.Key)object6).getId().setByteArrayValue((byte[])object8);
                        ((Storage)object6).getLabel().setCharArrayValue(string.toCharArray());
                        ((Storage)object6).getPrivate().setBooleanValue(Boolean.TRUE);
                        ((iaik.pkcs.pkcs11.objects.PrivateKey)object6).getSensitive().setBooleanValue(Boolean.TRUE);
                        object5 = this.createPrivateKeySpec(key);
                        object4 = this.getMechanismFeaturesSupport((String)object7);
                        this.setKeyAttributes((iaik.pkcs.pkcs11.objects.PrivateKey)object6, (java.security.cert.X509Certificate)x509Certificate, (MechanismInfo)object4);
                        object3 = new PKCS11KeySpec((KeySpec)object5, this.tokenManager_, (Object)object6, false, true);
                        object2 = KeyFactory.getInstance((String)object7, this.tokenManager_.getProvider().getName());
                        iAIKPKCS11Key = (IAIKPKCS11Key)((java.lang.Object)((KeyFactory)object2).generatePrivate((KeySpec)object3));
                    } else if (key instanceof PublicKey) {
                        object6 = new iaik.pkcs.pkcs11.objects.PublicKey();
                        ((Storage)object6).getToken().setBooleanValue(Boolean.TRUE);
                        ((iaik.pkcs.pkcs11.objects.Key)object6).getId().setByteArrayValue((byte[])object8);
                        ((Storage)object6).getLabel().setCharArrayValue(string.toCharArray());
                        object5 = this.createPublicKeySpec(key);
                        object4 = this.getMechanismFeaturesSupport((String)object7);
                        this.setKeyAttributes((iaik.pkcs.pkcs11.objects.PublicKey)object6, (java.security.cert.X509Certificate)x509Certificate, (MechanismInfo)object4);
                        object3 = new PKCS11KeySpec((KeySpec)object5, this.tokenManager_, (Object)object6, false, true);
                        object2 = KeyFactory.getInstance((String)object7, this.tokenManager_.getProvider().getName());
                        iAIKPKCS11Key = (IAIKPKCS11Key)((java.lang.Object)((KeyFactory)object2).generatePublic((KeySpec)object3));
                    } else if (key instanceof SecretKey) {
                        object6 = new iaik.pkcs.pkcs11.objects.SecretKey();
                        ((Storage)object6).getToken().setBooleanValue(Boolean.TRUE);
                        ((iaik.pkcs.pkcs11.objects.Key)object6).getId().setByteArrayValue((byte[])object8);
                        ((Storage)object6).getLabel().setCharArrayValue(string.toCharArray());
                        ((Storage)object6).getPrivate().setBooleanValue(Boolean.TRUE);
                        ((iaik.pkcs.pkcs11.objects.SecretKey)object6).getSensitive().setBooleanValue(Boolean.TRUE);
                        object5 = this.createSecretKeySpec((SecretKey)key);
                        object4 = new PKCS11KeySpec((KeySpec)object5, this.tokenManager_, (Object)object6, false, true);
                        object3 = SecretKeyFactory.getInstance((String)object7, this.tokenManager_.getProvider().getName());
                        iAIKPKCS11Key = (IAIKPKCS11Key)((java.lang.Object)((SecretKeyFactory)object3).generateSecret((KeySpec)object4));
                    } else {
                        throw new KeyStoreException("Unknown key type: " + key.getClass().getName());
                    }
                    object = iAIKPKCS11Key.getKeyObject();
                    this.keyAliasToPkcs11ObjectTable_.put(string, object);
                    this.keys_.put(string, iAIKPKCS11Key);
                    this.aliases_.add(string);
                }
                if (x509CertificateArray != null && x509CertificateArray.length > 0) {
                    object8 = new Object[x509CertificateArray.length];
                    object8[0] = this.createCertificate(x509Certificate, ((iaik.pkcs.pkcs11.objects.Key)object).getId().getByteArrayValue(), string.toCharArray());
                    int n2 = 1;
                    while (n2 < x509CertificateArray.length) {
                        object8[n2] = this.createCertificate(x509CertificateArray[n2], null, string.toCharArray());
                        ++n2;
                    }
                    this.certificateChainAliasToPkcs11ObjectsTable_.put(string, object8);
                    this.certificateChains_.put(string, x509CertificateArray);
                }
            }
            catch (TokenException tokenException) {
                throw new KeyStoreException(tokenException.toString());
            }
            catch (Exception exception) {
                throw new KeyStoreException(exception.toString());
            }
            java.lang.Object var6_26 = null;
            this.releaseSessions();
        }
        catch (Throwable throwable) {
            java.lang.Object var6_27 = null;
            this.releaseSessions();
            throw throwable;
        }
    }

    public void engineSetKeyEntry(String string, byte[] byArray, java.security.cert.Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("TokenKeyStoreSpi does not support storing encrypted keys");
    }

    public synchronized int engineSize() {
        this.ensureSupportProvider();
        try {
            try {
                this.ensureReadSession();
                this.ensureCurrentTables();
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception(tokenException.toString());
            }
            java.lang.Object var2_2 = null;
            this.releaseSessions();
        }
        catch (Throwable throwable) {
            java.lang.Object var2_3 = null;
            this.releaseSessions();
            throw throwable;
        }
        return this.aliases_.size();
    }

    public synchronized void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            try {
                this.ensureWriteSession();
                this.tokenManager_.setUserPIN(this.writeSession_, this.userPIN_, cArray);
                if (outputStream != null) {
                    IAIKPkcs11 iAIKPkcs11 = this.tokenManager_.getProvider();
                    this.writeProviderName(iAIKPkcs11.getName(), outputStream);
                }
            }
            catch (TokenException tokenException) {
                throw new IOException("Error setting new user PIN: " + tokenException.toString());
            }
            java.lang.Object var4_5 = null;
            this.releaseSessions();
        }
        catch (Throwable throwable) {
            java.lang.Object var4_6 = null;
            this.releaseSessions();
            throw throwable;
        }
    }

    protected synchronized void ensureCurrentTables() throws IAIKPkcs11Exception {
        try {
            if (this.tokenManager_.isTokenPresent()) {
                if (!this.isUpToDate()) {
                    this.clearTables();
                    this.updateTables();
                }
            } else {
                this.clearTables();
                this.infoOfRecentToken_ = null;
            }
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected synchronized void ensureReadSession() throws TokenException, IAIKPkcs11Exception {
        if (this.readSession_ == null) {
            this.openReadSession();
        }
        if (this.useUserSession_) {
            this.loginSession();
        }
    }

    protected void ensureSupportProvider() {
        this.supportProviderName_ = this.tokenManager_.getProvider().getKeystoreSupportProvider();
    }

    protected synchronized void ensureWriteSession() throws TokenException, IAIKPkcs11Exception {
        if (this.writeSession_ == null) {
            this.openWriteSession();
        }
        this.loginSession();
    }

    protected void finalize() throws Throwable {
        if (this.tokenManager_ != null) {
            this.tokenManager_.disposeSession(this.readSession_);
            if (this.readSession_ != this.writeSession_) {
                this.tokenManager_.disposeSession(this.writeSession_);
            }
        }
        super.finalize();
    }

    protected synchronized iaik.pkcs.pkcs11.objects.Key findCoreespondingKey(iaik.pkcs.pkcs11.objects.Key key) throws TokenException {
        iaik.pkcs.pkcs11.objects.Key key2;
        iaik.pkcs.pkcs11.objects.Key key3;
        if (key instanceof iaik.pkcs.pkcs11.objects.PrivateKey) {
            if (key instanceof RSAPrivateKey) {
                key3 = new iaik.pkcs.pkcs11.objects.RSAPublicKey();
                ((iaik.pkcs.pkcs11.objects.RSAPublicKey)key3).getModulus().setByteArrayValue(((RSAPrivateKey)key).getModulus().getByteArrayValue());
                key2 = key3;
            } else if (key instanceof DSAPrivateKey) {
                key3 = new iaik.pkcs.pkcs11.objects.DSAPublicKey();
                ((iaik.pkcs.pkcs11.objects.DSAPublicKey)key3).getBase().setByteArrayValue(((DSAPrivateKey)key).getBase().getByteArrayValue());
                ((iaik.pkcs.pkcs11.objects.DSAPublicKey)key3).getPrime().setByteArrayValue(((DSAPrivateKey)key).getPrime().getByteArrayValue());
                ((iaik.pkcs.pkcs11.objects.DSAPublicKey)key3).getSubprime().setByteArrayValue(((DSAPrivateKey)key).getSubprime().getByteArrayValue());
                key2 = key3;
            } else if (key instanceof ECDSAPrivateKey) {
                key3 = new ECDSAPublicKey();
                ((ECDSAPublicKey)key3).getEcdsaParams().setByteArrayValue(((ECDSAPrivateKey)key).getEcdsaParams().getByteArrayValue());
                key2 = key3;
            } else if (key instanceof DHPrivateKey) {
                key3 = new DHPublicKey();
                ((DHPublicKey)key3).getBase().setByteArrayValue(((DSAPrivateKey)key).getBase().getByteArrayValue());
                ((DHPublicKey)key3).getPrime().setByteArrayValue(((DSAPrivateKey)key).getPrime().getByteArrayValue());
                key2 = key3;
            } else {
                key2 = null;
            }
        } else if (key instanceof iaik.pkcs.pkcs11.objects.PublicKey) {
            if (key instanceof iaik.pkcs.pkcs11.objects.RSAPublicKey) {
                key3 = new RSAPrivateKey();
                ((RSAPrivateKey)key3).getModulus().setByteArrayValue(((iaik.pkcs.pkcs11.objects.RSAPublicKey)key).getModulus().getByteArrayValue());
                key2 = key3;
            } else if (key instanceof iaik.pkcs.pkcs11.objects.DSAPublicKey) {
                key3 = new DSAPrivateKey();
                ((DSAPrivateKey)key3).getBase().setByteArrayValue(((iaik.pkcs.pkcs11.objects.DSAPublicKey)key).getBase().getByteArrayValue());
                ((DSAPrivateKey)key3).getPrime().setByteArrayValue(((iaik.pkcs.pkcs11.objects.DSAPublicKey)key).getPrime().getByteArrayValue());
                ((DSAPrivateKey)key3).getSubprime().setByteArrayValue(((iaik.pkcs.pkcs11.objects.DSAPublicKey)key).getSubprime().getByteArrayValue());
                key2 = key3;
            } else if (key instanceof ECDSAPublicKey) {
                key3 = new ECDSAPrivateKey();
                ((ECDSAPrivateKey)key3).getEcdsaParams().setByteArrayValue(((ECDSAPublicKey)key).getEcdsaParams().getByteArrayValue());
                key2 = key3;
            } else if (key instanceof DHPublicKey) {
                key3 = new DHPrivateKey();
                ((DHPrivateKey)key3).getBase().setByteArrayValue(((iaik.pkcs.pkcs11.objects.DSAPublicKey)key).getBase().getByteArrayValue());
                ((DHPrivateKey)key3).getPrime().setByteArrayValue(((iaik.pkcs.pkcs11.objects.DSAPublicKey)key).getPrime().getByteArrayValue());
                key2 = key3;
            } else if (key instanceof KEAPublicKey) {
                key3 = new KEAPrivateKey();
                ((KEAPrivateKey)key3).getBase().setByteArrayValue(((KEAPublicKey)key).getBase().getByteArrayValue());
                ((KEAPrivateKey)key3).getPrime().setByteArrayValue(((KEAPublicKey)key).getPrime().getByteArrayValue());
                ((KEAPrivateKey)key3).getSubprime().setByteArrayValue(((KEAPublicKey)key).getSubprime().getByteArrayValue());
                key2 = key3;
            } else {
                key2 = null;
            }
        } else {
            key2 = null;
        }
        if (key2 != null) {
            this.ensureReadSession();
            this.readSession_.findObjectsInit(key2);
            Object[] objectArray = this.readSession_.findObjects(1);
            key3 = objectArray.length > 0 ? (iaik.pkcs.pkcs11.objects.Key)objectArray[0] : null;
        } else {
            key3 = null;
        }
        return key3;
    }

    protected synchronized void findKeysAndCertificateTables() throws TokenException, KeyStoreException {
        java.lang.Object object;
        java.lang.Object object2;
        java.lang.Object object3;
        java.lang.Object object4;
        java.lang.Object object5;
        Cloneable cloneable;
        Serializable serializable;
        Object[] objectArray;
        java.lang.Object object6;
        Serializable serializable2;
        java.lang.Object object7;
        Cloneable cloneable2;
        Object[] objectArray2;
        Hashtable<java.lang.Object, Integer> hashtable = new Hashtable<java.lang.Object, Integer>();
        Certificate certificate = new Certificate();
        this.readSession_.findObjectsInit(certificate);
        HashMap<Serializable, Cloneable> hashMap = new HashMap<Serializable, Cloneable>(8);
        HashMap<String, Serializable> hashMap2 = new HashMap<String, Serializable>(8);
        while ((objectArray2 = this.readSession_.findObjects(1)).length > 0) {
            if (!(objectArray2[0] instanceof Certificate)) continue;
            if (objectArray2[0] instanceof X509PublicKeyCertificate) {
                cloneable2 = (X509PublicKeyCertificate)objectArray2[0];
                object7 = ((X509PublicKeyCertificate)cloneable2).getValue().getByteArrayValue();
                if (object7 == null) continue;
                try {
                    serializable2 = new X509Certificate(new ByteArrayInputStream((byte[])object7));
                    hashMap.put(serializable2, cloneable2);
                    hashMap2.put(((Name)((X509Certificate)serializable2).getSubjectDN()).getRFC2253String(), serializable2);
                }
                catch (Exception exception) {
                    IAIKPkcs11.errorStream_.println("Could not create Certificate object: " + exception);
                    exception.printStackTrace(IAIKPkcs11.errorStream_);
                }
                continue;
            }
            if (!(objectArray2[0] instanceof X509AttributeCertificate)) continue;
            cloneable2 = (X509AttributeCertificate)objectArray2[0];
            object7 = ((X509AttributeCertificate)cloneable2).getValue().getByteArrayValue();
            try {
                serializable2 = new AttributeCertificate((byte[])object7);
                hashMap.put(serializable2, cloneable2);
            }
            catch (CertificateException certificateException) {
                IAIKPkcs11.errorStream_.println("Could not create AttributeCertificate object: " + certificateException);
                certificateException.printStackTrace(IAIKPkcs11.errorStream_);
            }
        }
        this.readSession_.findObjectsFinal();
        cloneable2 = new Hashtable(hashMap.size());
        object7 = new Hashtable(hashMap.size());
        serializable2 = new HashSet(hashMap.size());
        serializable2.addAll(hashMap.keySet());
        Iterator iterator = serializable2.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            object6 = (java.security.cert.Certificate)iterator.next();
            if (object6 == null || (objectArray = (Object[])hashMap.get(object6)) == null || !(object6 instanceof X509Certificate)) continue;
            serializable = (X509Certificate)object6;
            cloneable = (X509PublicKeyCertificate)objectArray;
            object5 = ((X509PublicKeyCertificate)cloneable).getId().getByteArrayValue();
            if (object5 == null) continue;
            object4 = new ComparableByteArray((byte[])object5);
            object3 = new Integer(n2++);
            hashtable.put(object4, (Integer)object3);
            object2 = this.createCertificateChain((X509Certificate)serializable, hashMap2);
            object = new Object[((X509Certificate[])object2).length];
            int n3 = 0;
            while (n3 < ((java.lang.Object)object2).length) {
                object[n3] = (Object)hashMap.get(object2[n3]);
                ++n3;
            }
            ((Hashtable)cloneable2).put(object3, object);
            ((Hashtable)object7).put(object3, object2);
        }
        object6 = new iaik.pkcs.pkcs11.objects.Key();
        this.readSession_.findObjectsInit((Object)object6);
        serializable = new LinkedList();
        cloneable = new LinkedList();
        while ((objectArray = this.readSession_.findObjects(1)).length > 0) {
            if (!(objectArray[0] instanceof iaik.pkcs.pkcs11.objects.Key)) continue;
            object5 = (iaik.pkcs.pkcs11.objects.Key)objectArray[0];
            object4 = null;
            object3 = null;
            if (object5 instanceof iaik.pkcs.pkcs11.objects.PrivateKey) {
                object2 = (X509Certificate[])object5;
                object3 = IAIKPKCS11PrivateKey.create(this.tokenManager_, (iaik.pkcs.pkcs11.objects.PrivateKey)object2);
                object = ((iaik.pkcs.pkcs11.objects.Key)object2).getId().getByteArrayValue();
                if (object != null) {
                    ComparableByteArray comparableByteArray = new ComparableByteArray((byte[])object);
                    Integer n4 = (Integer)hashtable.get(comparableByteArray);
                    if (n4 != null) {
                        X509Certificate[] x509CertificateArray = (X509Certificate[])((Hashtable)object7).remove(n4);
                        if (x509CertificateArray != null && x509CertificateArray.length > 0) {
                            Object[] objectArray3 = (Object[])((Hashtable)cloneable2).remove(n4);
                            object4 = this.createUniqueAlias(objectArray3[0], this.aliases_);
                            this.certificateChains_.put(object4, x509CertificateArray);
                            if (objectArray3 != null) {
                                this.certificateChainAliasToPkcs11ObjectsTable_.put(object4, objectArray3);
                            }
                            if (x509CertificateArray.length > 0) {
                                hashMap.remove(x509CertificateArray[0]);
                            }
                        }
                    } else {
                        object4 = this.createUniqueAlias((Object)object5, this.aliases_);
                    }
                } else {
                    object4 = this.createUniqueAlias((Object)object5, this.aliases_);
                }
                if (object3 == null) continue;
                this.keyAliasToPkcs11ObjectTable_.put(object4, object5);
                this.keys_.put(object4, object3);
                this.aliases_.add(object4);
                continue;
            }
            if (object5 instanceof iaik.pkcs.pkcs11.objects.PublicKey) {
                serializable.add(object5);
                continue;
            }
            if (object5 instanceof iaik.pkcs.pkcs11.objects.SecretKey) {
                cloneable.add(object5);
                continue;
            }
            throw new KeyStoreException("Unknown key type: " + object5.getClass().getName());
        }
        this.readSession_.findObjectsFinal();
        object5 = serializable.iterator();
        while (object5.hasNext()) {
            object4 = (iaik.pkcs.pkcs11.objects.PublicKey)object5.next();
            object3 = IAIKPKCS11PublicKey.create(this.tokenManager_, (iaik.pkcs.pkcs11.objects.PublicKey)object4);
            object2 = this.createUniqueAlias((Object)object4, this.aliases_);
            this.keyAliasToPkcs11ObjectTable_.put(object2, object4);
            this.keys_.put(object2, object3);
            this.aliases_.add(object2);
        }
        object4 = cloneable.iterator();
        while (object4.hasNext()) {
            object3 = (iaik.pkcs.pkcs11.objects.SecretKey)object4.next();
            object2 = IAIKPKCS11SecretKey.create(this.tokenManager_, (iaik.pkcs.pkcs11.objects.SecretKey)object3);
            object = this.createUniqueAlias((Object)object3, this.aliases_);
            this.keyAliasToPkcs11ObjectTable_.put(object, object3);
            this.keys_.put(object, object2);
            this.aliases_.add(object);
        }
        serializable2 = new HashSet(hashMap.size());
        serializable2.addAll(hashMap.keySet());
        iterator = serializable2.iterator();
        while (iterator.hasNext()) {
            object3 = (java.security.cert.Certificate)iterator.next();
            if (object3 == null) continue;
            object2 = (Object)hashMap.get(object3);
            if (object2 != null) {
                object = this.createUniqueAlias((Object)object2, this.aliases_);
                this.trustedCertificateAliasToPkcs11ObjectTable_.put(object, object2);
                this.trustedCertificates_.put(object, object3);
                this.aliases_.add(object);
            }
            hashMap.remove(object3);
        }
    }

    protected synchronized byte[] generateNewID(byte[] byArray) throws TokenException {
        byte[] byArray2 = byArray != null && byArray.length > 0 ? byArray : (this.lastNewID_ == null ? new byte[20] : this.lastNewID_);
        GenericTemplate genericTemplate = new GenericTemplate();
        ByteArrayAttribute byteArrayAttribute = new ByteArrayAttribute(iaik.pkcs.pkcs11.objects.Attribute.ID);
        byteArrayAttribute.setByteArrayValue(byArray2);
        genericTemplate.addAttribute(byteArrayAttribute);
        boolean bl = false;
        while (!bl) {
            byte by;
            boolean bl2 = false;
            int n2 = byArray2.length - 1;
            do {
                by = byArray2[n2];
                int n3 = n2;
                byArray2[n3] = (byte)(byArray2[n3] + 1);
            } while ((bl2 = (by & 0xFF) > (byArray2[n2] & 0xFF)) && --n2 >= 0);
            this.writeSession_.findObjectsInit(genericTemplate);
            Object[] objectArray = this.writeSession_.findObjects(1);
            this.writeSession_.findObjectsFinal();
            boolean bl3 = bl = objectArray.length == 0;
        }
        this.lastNewID_ = byArray2;
        return this.lastNewID_;
    }

    protected MechanismInfo getMechanismFeaturesSupport(String string) throws TokenException {
        MechanismInfo mechanismInfo;
        Token token = this.tokenManager_.getToken();
        if (token != null) {
            HashSet<Mechanism> hashSet = new HashSet<Mechanism>(Arrays.asList(token.getMechanismList()));
            if (string.equalsIgnoreCase("RSA")) {
                mechanismInfo = new MechanismInfo();
                if (hashSet.contains(Mechanism.RSA_PKCS)) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.RSA_PKCS));
                }
                if (hashSet.contains(Mechanism.MD2_RSA_PKCS)) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.MD2_RSA_PKCS));
                }
                if (hashSet.contains(Mechanism.MD5_RSA_PKCS)) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.MD5_RSA_PKCS));
                }
                if (hashSet.contains(Mechanism.SHA1_RSA_PKCS)) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.SHA1_RSA_PKCS));
                }
                if (hashSet.contains(Mechanism.RIPEMD128_RSA_PKCS)) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.RIPEMD128_RSA_PKCS));
                }
                if (hashSet.contains(Mechanism.RIPEMD160_RSA_PKCS)) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.RIPEMD160_RSA_PKCS));
                }
                if (hashSet.contains(Mechanism.RSA_X_509)) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.RSA_X_509));
                }
                if (hashSet.contains(Mechanism.RSA_9796)) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.RSA_9796));
                }
                if (hashSet.contains(Mechanism.RSA_PKCS_OAEP)) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.RSA_PKCS_OAEP));
                }
            } else if (string.equalsIgnoreCase("DSA")) {
                mechanismInfo = new MechanismInfo();
                if (hashSet.contains(Mechanism.DSA)) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.DSA));
                }
                if (hashSet.contains(Mechanism.DSA_SHA1)) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.DSA_SHA1));
                }
            } else if (string.equalsIgnoreCase("DH")) {
                mechanismInfo = new MechanismInfo();
                if (hashSet.contains(Mechanism.DH_PKCS_DERIVE)) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.DH_PKCS_DERIVE));
                }
            } else if (string.equalsIgnoreCase("ECDSA")) {
                mechanismInfo = new MechanismInfo();
                if (hashSet.contains(Mechanism.ECDSA)) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.ECDSA));
                }
                if (hashSet.contains(Mechanism.ECDSA_SHA1)) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.ECDSA_SHA1));
                }
                if (hashSet.contains(Mechanism.ECDH1_COFACTOR_DERIVE)) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.ECDH1_COFACTOR_DERIVE));
                }
                if (hashSet.contains(Mechanism.ECDH1_DERIVE)) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.ECDH1_DERIVE));
                }
                if (hashSet.contains(Mechanism.ECMQV_DERIVE)) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.ECMQV_DERIVE));
                }
            } else if (string.equalsIgnoreCase("KEA")) {
                mechanismInfo = new MechanismInfo();
                if (hashSet.contains(Mechanism.KEA_KEY_DERIVE)) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.KEA_KEY_DERIVE));
                }
            } else {
                mechanismInfo = null;
            }
        } else {
            mechanismInfo = null;
        }
        return mechanismInfo;
    }

    protected boolean getReadProtectedKeyOnDemand() {
        return this.useUserSession_ ^ true;
    }

    public TokenManager getTokenManager() {
        return this.tokenManager_;
    }

    protected synchronized void initialize() throws IAIKPkcs11Exception {
        this.aliases_ = new HashSet();
        this.keys_ = new Hashtable();
        this.certificateChains_ = new Hashtable();
        this.trustedCertificates_ = new Hashtable();
        this.keyAliasToPkcs11ObjectTable_ = new Hashtable();
        this.certificateChainAliasToPkcs11ObjectsTable_ = new Hashtable();
        this.trustedCertificateAliasToPkcs11ObjectTable_ = new Hashtable();
        this.useUserSession_ = this.tokenManager_.getProvider().isLoginKeystoreOnDemand() ^ true;
        this.setUpToDate(false);
    }

    protected boolean isEndUserCertificate(X509Certificate x509Certificate) throws CertificateException {
        BasicConstraints basicConstraints;
        try {
            basicConstraints = (BasicConstraints)x509Certificate.getExtension(BasicConstraints.oid);
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            throw new CertificateException(x509ExtensionInitException.toString());
        }
        return basicConstraints != null ? basicConstraints.ca() ^ true : true;
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        return true;
    }

    protected synchronized boolean isUpToDate() throws TokenException {
        if (this.tokenManager_.isTokenPresent()) {
            TokenInfo tokenInfo = this.tokenManager_.getToken().getTokenInfo();
            if (!(this.infoOfRecentToken_ != null && this.infoOfRecentToken_.getLabel().equals(tokenInfo.getLabel()) && this.infoOfRecentToken_.getManufacturerID().equals(tokenInfo.getManufacturerID()) && this.infoOfRecentToken_.getModel().equals(tokenInfo.getModel()) && this.infoOfRecentToken_.getSerialNumber().equals(tokenInfo.getSerialNumber()) && this.infoOfRecentToken_.getFreePrivateMemory() == tokenInfo.getFreePrivateMemory() && this.infoOfRecentToken_.getFreePublicMemory() == tokenInfo.getFreePublicMemory())) {
                this.isUpToDate_ = false;
            }
        } else if (this.infoOfRecentToken_ != null) {
            this.isUpToDate_ = false;
        }
        return this.isUpToDate_;
    }

    protected synchronized boolean loginSession() {
        boolean bl;
        try {
            if (this.readSession_ == null) {
                this.openReadSession();
            }
            bl = this.tokenManager_.makeAuthorizedSession(this.readSession_, null);
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
        return bl;
    }

    protected synchronized void logoutSession() {
        try {
            if (this.readSession_ != null) {
                this.tokenManager_.logout(this.readSession_);
            } else if (this.writeSession_ != null) {
                this.tokenManager_.logout(this.writeSession_);
            }
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected synchronized void openReadSession() {
        try {
            this.readSession_ = this.writeSession_ != null ? this.writeSession_ : this.tokenManager_.getSession(false);
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected synchronized void openWriteSession() {
        try {
            this.writeSession_ = this.tokenManager_.getSession(true);
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected String readProviderName(InputStream inputStream) throws IOException {
        char[] cArray = new char[64];
        int n2 = 0;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        CharArrayWriter charArrayWriter = new CharArrayWriter(64);
        while ((n2 = inputStreamReader.read(cArray, 0, cArray.length)) >= 0) {
            charArrayWriter.write(cArray, 0, n2);
        }
        charArrayWriter.flush();
        return new String(charArrayWriter.toCharArray());
    }

    protected synchronized void releaseSessions() {
        if (this.readSession_ != null) {
            if (this.readSession_ != this.writeSession_) {
                this.tokenManager_.disposeSession(this.readSession_);
            }
            this.readSession_ = null;
        }
        if (this.writeSession_ != null) {
            this.tokenManager_.disposeSession(this.writeSession_);
            this.writeSession_ = null;
        }
    }

    protected void setKeyAttributes(iaik.pkcs.pkcs11.objects.PrivateKey privateKey, java.security.cert.X509Certificate x509Certificate, MechanismInfo mechanismInfo) throws X509ExtensionException, CertificateException {
        KeyUsage keyUsage;
        if (privateKey == null) {
            throw new NullPointerException("Argument \"keyTemplate\" must not be null.");
        }
        if (x509Certificate != null) {
            X509Certificate x509Certificate2 = x509Certificate instanceof X509Certificate ? (X509Certificate)x509Certificate : new X509Certificate(x509Certificate.getEncoded());
            keyUsage = (KeyUsage)x509Certificate2.getExtension(KeyUsage.oid);
        } else {
            keyUsage = null;
        }
        if (keyUsage != null) {
            int n2 = keyUsage.get();
            if (mechanismInfo != null) {
                privateKey.getDecrypt().setBooleanValue(new Boolean(((n2 & 8) != 0 || (n2 & 4) != 0) && mechanismInfo.isDecrypt()));
                privateKey.getSign().setBooleanValue(new Boolean(((n2 & 1) != 0 || (n2 & 0x20) != 0 || (n2 & 0x40) != 0 || (n2 & 2) != 0) && mechanismInfo.isSign()));
                privateKey.getSignRecover().setBooleanValue(new Boolean(((n2 & 1) != 0 || (n2 & 0x20) != 0 || (n2 & 0x40) != 0 || (n2 & 2) != 0) && mechanismInfo.isSignRecover()));
                privateKey.getDerive().setBooleanValue(new Boolean((n2 & 0x10) != 0 && mechanismInfo.isDerive()));
                privateKey.getUnwrap().setBooleanValue(new Boolean((n2 & 4) != 0 && mechanismInfo.isUnwrap()));
            } else {
                privateKey.getDecrypt().setBooleanValue(new Boolean((n2 & 8) != 0 || (n2 & 4) != 0));
                privateKey.getSign().setBooleanValue(new Boolean((n2 & 1) != 0 || (n2 & 0x20) != 0 || (n2 & 0x40) != 0 || (n2 & 2) != 0));
                privateKey.getSignRecover().setBooleanValue(new Boolean((n2 & 1) != 0 || (n2 & 0x20) != 0 || (n2 & 0x40) != 0 || (n2 & 2) != 0));
                privateKey.getDerive().setBooleanValue(new Boolean((n2 & 0x10) != 0));
                privateKey.getUnwrap().setBooleanValue(new Boolean((n2 & 4) != 0));
            }
        } else if (mechanismInfo != null) {
            privateKey.getSign().setBooleanValue(new Boolean(mechanismInfo.isSign()));
            privateKey.getSignRecover().setBooleanValue(new Boolean(mechanismInfo.isSignRecover()));
            privateKey.getDecrypt().setBooleanValue(new Boolean(mechanismInfo.isDecrypt()));
            privateKey.getDerive().setBooleanValue(new Boolean(mechanismInfo.isDerive()));
            privateKey.getUnwrap().setBooleanValue(new Boolean(mechanismInfo.isUnwrap()));
        } else {
            privateKey.getSign().setBooleanValue(Boolean.TRUE);
            privateKey.getSignRecover().setBooleanValue(Boolean.TRUE);
            privateKey.getDecrypt().setBooleanValue(Boolean.TRUE);
            privateKey.getDerive().setBooleanValue(Boolean.TRUE);
            privateKey.getUnwrap().setBooleanValue(Boolean.TRUE);
        }
    }

    protected void setKeyAttributes(iaik.pkcs.pkcs11.objects.PublicKey publicKey, java.security.cert.X509Certificate x509Certificate, MechanismInfo mechanismInfo) throws X509ExtensionException, CertificateException {
        KeyUsage keyUsage;
        if (publicKey == null) {
            throw new NullPointerException("Argument \"keyTemplate\" must not be null.");
        }
        if (x509Certificate != null) {
            X509Certificate x509Certificate2 = x509Certificate instanceof X509Certificate ? (X509Certificate)x509Certificate : new X509Certificate(x509Certificate.getEncoded());
            keyUsage = (KeyUsage)x509Certificate2.getExtension(KeyUsage.oid);
        } else {
            keyUsage = null;
        }
        if (keyUsage != null) {
            int n2 = keyUsage.get();
            if (mechanismInfo != null) {
                publicKey.getEncrypt().setBooleanValue(new Boolean((n2 & 8) != 0 && mechanismInfo.isEncrypt()));
                publicKey.getVerify().setBooleanValue(new Boolean(((n2 & 1) != 0 || (n2 & 0x20) != 0 || (n2 & 0x40) != 0 || (n2 & 2) != 0) && mechanismInfo.isVerify()));
                publicKey.getVerifyRecover().setBooleanValue(new Boolean(((n2 & 1) != 0 || (n2 & 0x20) != 0 || (n2 & 0x40) != 0 || (n2 & 2) != 0) && mechanismInfo.isVerifyRecover()));
                publicKey.getDerive().setBooleanValue(new Boolean((n2 & 0x10) != 0 && mechanismInfo.isDerive()));
                publicKey.getWrap().setBooleanValue(new Boolean((n2 & 4) != 0 && mechanismInfo.isWrap()));
            } else {
                publicKey.getEncrypt().setBooleanValue(new Boolean((n2 & 8) != 0));
                publicKey.getVerify().setBooleanValue(new Boolean((n2 & 1) != 0 || (n2 & 0x20) != 0 || (n2 & 0x40) != 0 || (n2 & 2) != 0));
                publicKey.getVerifyRecover().setBooleanValue(new Boolean((n2 & 1) != 0 || (n2 & 0x20) != 0 || (n2 & 0x40) != 0 || (n2 & 2) != 0));
                publicKey.getDerive().setBooleanValue(new Boolean((n2 & 0x10) != 0));
                publicKey.getWrap().setBooleanValue(new Boolean((n2 & 4) != 0));
            }
        } else if (mechanismInfo != null) {
            publicKey.getVerify().setBooleanValue(new Boolean(mechanismInfo.isVerify()));
            publicKey.getVerifyRecover().setBooleanValue(new Boolean(mechanismInfo.isVerifyRecover()));
            publicKey.getEncrypt().setBooleanValue(new Boolean(mechanismInfo.isEncrypt()));
            publicKey.getDerive().setBooleanValue(new Boolean(mechanismInfo.isDerive()));
            publicKey.getWrap().setBooleanValue(new Boolean(mechanismInfo.isWrap()));
        } else {
            publicKey.getVerify().setBooleanValue(Boolean.TRUE);
            publicKey.getVerifyRecover().setBooleanValue(Boolean.TRUE);
            publicKey.getEncrypt().setBooleanValue(Boolean.TRUE);
            publicKey.getDerive().setBooleanValue(Boolean.TRUE);
            publicKey.getWrap().setBooleanValue(Boolean.TRUE);
        }
    }

    protected synchronized void setReadProtectedKeyOnDemand(boolean bl) {
        if (bl == this.useUserSession_) {
            this.useUserSession_ = bl ^ true;
            this.setUpToDate(false);
        }
    }

    protected void setUpToDate(boolean bl) {
        this.isUpToDate_ = bl;
    }

    protected synchronized boolean tokenChanged() throws TokenException {
        boolean bl;
        if (this.tokenManager_.isTokenPresent()) {
            TokenInfo tokenInfo = this.tokenManager_.getToken().getTokenInfo();
            bl = !(this.infoOfRecentToken_ != null && this.infoOfRecentToken_.getLabel().equals(tokenInfo.getLabel()) && this.infoOfRecentToken_.getManufacturerID().equals(tokenInfo.getManufacturerID()) && this.infoOfRecentToken_.getModel().equals(tokenInfo.getModel()) && this.infoOfRecentToken_.getSerialNumber().equals(tokenInfo.getSerialNumber()));
        } else {
            bl = this.infoOfRecentToken_ != null;
        }
        return bl;
    }

    protected synchronized void updateTables() {
        try {
            this.infoOfRecentToken_ = this.tokenManager_.getToken().getTokenInfo();
            this.findKeysAndCertificateTables();
            this.setUpToDate(true);
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace(IAIKPkcs11.errorStream_);
        }
        catch (TokenException tokenException) {
            tokenException.printStackTrace(IAIKPkcs11.errorStream_);
        }
    }

    protected void writeProviderName(String string, OutputStream outputStream) throws IOException {
        outputStream.write(string.getBytes("UTF-8"));
    }
}

