/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider;

import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public class NullCipher
extends CipherSpi
implements PKCS11EngineClass {
    private static final boolean DEBUG = false;

    protected byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws BadPaddingException, IllegalBlockSizeException {
        if (byArray == null) {
            throw new NullPointerException("Argument \"input\" must not be null.");
        }
        if (n2 + n3 > byArray.length) {
            throw new NullPointerException("Arguments must satisfy ((inputOffset + inputLength) <= input.length).");
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return byArray2;
    }

    protected int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        if (byArray == null) {
            throw new NullPointerException("Argument \"input\" must not be null.");
        }
        if (byArray2 == null) {
            throw new NullPointerException("Argument \"output\" must not be null.");
        }
        if (n2 + n3 > byArray.length) {
            throw new NullPointerException("Arguments must satisfy ((inputOffset + inputLength) <= input.length).");
        }
        if (byArray2.length - n4 < n3) {
            throw new ShortBufferException("Output is " + n3 + "bytes long." + "The given buffer has only place for " + (byArray2.length - n4) + "bytes.");
        }
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        return n3;
    }

    protected int engineGetBlockSize() {
        return 1;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected int engineGetKeySize(Key key) {
        return -1;
    }

    protected int engineGetOutputSize(int n2) {
        return -1;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) {
    }

    protected void engineInit(int n2, Key key, SecureRandom secureRandom) {
    }

    protected void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
    }

    protected void engineSetMode(String string) {
    }

    protected void engineSetPadding(String string) {
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n2) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"wrappedKey\" must not be null.");
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "RAW");
        return secretKeySpec;
    }

    protected byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"data\" must not be null.");
        }
        if (n2 + n3 > byArray.length) {
            throw new NullPointerException("Arguments must satisfy ((offset + length) <= data.length).");
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return byArray2;
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        if (byArray == null) {
            throw new NullPointerException("Argument \"input\" must not be null.");
        }
        if (byArray2 == null) {
            throw new NullPointerException("Argument \"output\" must not be null.");
        }
        if (n2 + n3 > byArray.length) {
            throw new NullPointerException("Arguments must satisfy ((inputOffset + inputLength) <= input.length).");
        }
        if (byArray2.length - n4 < n3) {
            throw new ShortBufferException("Output is " + n3 + "bytes long." + "The given buffer has only place for " + (byArray2.length - n4) + "bytes.");
        }
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        return n3;
    }

    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        byte[] byArray = key.getEncoded();
        return byArray;
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        return true;
    }
}

