/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider;

import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.provider.DefaultDelegateProvider;
import iaik.pkcs.pkcs11.provider.DefaultLoginManager;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.LoginManager;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.Reminder;
import iaik.pkcs.pkcs11.provider.TokenManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Cipher;

public class IAIKPkcs11
extends Provider {
    private static final boolean DEBUG = false;
    public static final String PROVIDER_BASE_NAME = "IAIK PKCS#11";
    public static final double PROVIDER_VERSION = 1.107;
    public static final String PROVIDER_INFO_BASE = "IAIK JCE Provider for PKCS#11 operating with ";
    public static PrintStream debugStream_;
    public static PrintStream errorStream_;
    protected static Properties globalProperties_;
    protected static Properties defaultInstanceProperties_;
    protected static int instanceCounter_;
    protected static List providerInstances_;
    protected static DelegateProvider globalDelegateProvider_;
    protected Properties defaultProperties_;
    protected Properties properties_;
    protected String initializationParameters_;
    protected TokenManager tokenManager_;
    protected LoginManager loginManager_;
    protected double version_;
    protected String info_;
    protected Hashtable engineObjectsCache_;
    protected DelegateProvider delegateProvider_;
    protected char[] userPIN_;
    static /* synthetic */ Class class$iaik$pkcs$pkcs11$provider$IAIKPkcs11;

    static {
        Properties properties;
        InputStream inputStream;
        URL uRL;
        Properties properties2;
        InputStream inputStream2;
        URL uRL2;
        debugStream_ = System.out;
        errorStream_ = System.err;
        providerInstances_ = new LinkedList();
        try {
            uRL2 = (class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 != null ? class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 : (class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 = IAIKPkcs11.class$("iaik.pkcs.pkcs11.provider.IAIKPkcs11"))).getClassLoader().getResource("iaik/pkcs/pkcs11/provider/default/IAIKPkcs11Global.properties");
            inputStream2 = uRL2.openStream();
            properties2 = new Properties();
            properties2.load(inputStream2);
            inputStream2.close();
            uRL = (class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 != null ? class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 : (class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 = IAIKPkcs11.class$("iaik.pkcs.pkcs11.provider.IAIKPkcs11"))).getClassLoader().getResource("iaik/pkcs/pkcs11/provider/IAIKPkcs11Global.properties");
            if (uRL != null) {
                inputStream = uRL.openStream();
                properties = new Properties(properties2);
                properties.load(inputStream);
                inputStream.close();
                globalProperties_ = properties;
            } else {
                globalProperties_ = properties2;
            }
        }
        catch (IOException iOException) {
            errorStream_.println("Could not load IAIK PKCS#11 multiple instance configuration properties.");
            iOException.printStackTrace(errorStream_);
            globalProperties_ = null;
        }
        try {
            uRL2 = (class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 != null ? class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 : (class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 = IAIKPkcs11.class$("iaik.pkcs.pkcs11.provider.IAIKPkcs11"))).getClassLoader().getResource("iaik/pkcs/pkcs11/provider/default/IAIKPkcs11.properties");
            inputStream2 = uRL2.openStream();
            properties2 = new Properties();
            properties2.load(inputStream2);
            uRL = (class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 != null ? class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 : (class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 = IAIKPkcs11.class$("iaik.pkcs.pkcs11.provider.IAIKPkcs11"))).getClassLoader().getResource("iaik/pkcs/pkcs11/provider/IAIKPkcs11.properties");
            if (uRL != null) {
                inputStream = uRL.openStream();
                properties = new Properties(properties2);
                properties.load(inputStream);
                inputStream.close();
                defaultInstanceProperties_ = properties;
            } else {
                defaultInstanceProperties_ = properties2;
            }
        }
        catch (IOException iOException) {
            errorStream_.println("Could not load IAIK PKCS#11 default configuration properties.");
            iOException.printStackTrace(errorStream_);
            defaultInstanceProperties_ = null;
        }
        try {
            new Reminder();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(errorStream_);
            errorStream_.println("Class iaik.pkcs.pkcs11.provider.Reminder not found! going to exit.");
            System.exit(1);
        }
        try {
            Security.getProviders();
        }
        catch (Throwable throwable) {
            errorStream_.println("Could not list all providers to ensure that all statically configured providers aer set up.");
            throwable.printStackTrace(errorStream_);
        }
    }

    public IAIKPkcs11() throws IAIKPkcs11Exception {
        super("IAIK PKCS#11:" + (instanceCounter_ + 1), 1.107, PROVIDER_INFO_BASE);
        Class clazz = class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 != null ? class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 : (class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 = IAIKPkcs11.class$("iaik.pkcs.pkcs11.provider.IAIKPkcs11"));
        synchronized (clazz) {
            this.properties_ = IAIKPkcs11.getDefaultInstanceProperties();
            this.initialize();
            providerInstances_.add(this);
            ++instanceCounter_;
        }
    }

    public IAIKPkcs11(Properties properties) throws IAIKPkcs11Exception {
        super("IAIK PKCS#11:" + (instanceCounter_ + 1), 1.107, PROVIDER_INFO_BASE);
        Class clazz = class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 != null ? class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 : (class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 = IAIKPkcs11.class$("iaik.pkcs.pkcs11.provider.IAIKPkcs11"));
        synchronized (clazz) {
            this.properties_ = new Properties(IAIKPkcs11.getDefaultInstanceProperties());
            ((Hashtable)this.properties_).putAll(properties);
            this.initialize();
            providerInstances_.add(this);
            ++instanceCounter_;
        }
    }

    protected synchronized void addAlgorithms() {
        Properties properties = null;
        try {
            Object object;
            InputStream inputStream;
            String string = this.properties_.getProperty("ALGORITHM_PROPERTIES", "iaik/pkcs/pkcs11/provider/IAIKPkcs11Algorithm.properties");
            URL uRL = (class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 != null ? class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 : (class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 = IAIKPkcs11.class$("iaik.pkcs.pkcs11.provider.IAIKPkcs11"))).getClassLoader().getResource(string);
            if (uRL != null) {
                inputStream = uRL.openStream();
            } else {
                object = (class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 != null ? class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 : (class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 = IAIKPkcs11.class$("iaik.pkcs.pkcs11.provider.IAIKPkcs11"))).getClassLoader().getResource("iaik/pkcs/pkcs11/provider/default/IAIKPkcs11Algorithm.properties");
                inputStream = ((URL)object).openStream();
            }
            properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
            object = ((Hashtable)properties).keys();
            while (object.hasMoreElements()) {
                String string2 = (String)object.nextElement();
                this.put(string2, ((Hashtable)properties).get(string2));
            }
        }
        catch (IOException iOException) {
            throw new IAIKPkcs11Exception(iOException.toString());
        }
    }

    protected static void checkAccessPermission(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess(string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public synchronized void clear() {
        IAIKPkcs11.checkAccessPermission("clearProviderProperties." + this.getName());
        super.clear();
    }

    public synchronized boolean equals(Object object) {
        return this == object;
    }

    protected static Properties getDefaultInstanceProperties() {
        Properties properties;
        block7: {
            properties = null;
            if (globalProperties_ != null) {
                StringBuffer stringBuffer = new StringBuffer("providerInstance.".length() + 2);
                stringBuffer.append("providerInstance.");
                stringBuffer.append(instanceCounter_ + 1);
                String string = globalProperties_.getProperty(stringBuffer.toString());
                if (string != null) {
                    try {
                        URL uRL = (class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 != null ? class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 : (class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 = IAIKPkcs11.class$("iaik.pkcs.pkcs11.provider.IAIKPkcs11"))).getClassLoader().getResource(string);
                        if (uRL != null) {
                            InputStream inputStream = uRL.openStream();
                            properties = new Properties(defaultInstanceProperties_);
                            properties.load(inputStream);
                            break block7;
                        }
                        errorStream_.print("Could not load IAIK PKCS#11 provider properties from \"");
                        errorStream_.print(string);
                        errorStream_.println("\". Using defaults.");
                        properties = defaultInstanceProperties_;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(errorStream_);
                        errorStream_.print("Could not load IAIK PKCS#11 provider properties from \"");
                        errorStream_.print(string);
                        errorStream_.println("\". Using defaults.");
                        properties = defaultInstanceProperties_;
                    }
                } else {
                    properties = defaultInstanceProperties_;
                }
            } else {
                properties = defaultInstanceProperties_;
            }
        }
        return properties;
    }

    public DelegateProvider getDelegateProvider() {
        if (this.delegateProvider_ == null) {
            IAIKPkcs11 iAIKPkcs11 = this;
            synchronized (iAIKPkcs11) {
                if (this.delegateProvider_ == null) {
                    String string = globalProperties_.getProperty("DELEGATE_PROVIDER", "iaik.pkcs.pkcs11.provider.DefaultDelegateProvider");
                    try {
                        Class<?> clazz = Class.forName(string);
                        this.delegateProvider_ = (DelegateProvider)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(errorStream_);
                        this.delegateProvider_ = new DefaultDelegateProvider();
                    }
                }
            }
        }
        return this.delegateProvider_;
    }

    public static DelegateProvider getGlobalDelegateProvider() {
        if (globalDelegateProvider_ == null) {
            Class clazz = class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 != null ? class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 : (class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 = IAIKPkcs11.class$("iaik.pkcs.pkcs11.provider.IAIKPkcs11"));
            synchronized (clazz) {
                if (globalDelegateProvider_ == null) {
                    String string = globalProperties_.getProperty("globalDelegateProvider", "iaik.pkcs.pkcs11.provider.DefaultDelegateProvider");
                    try {
                        Class<?> clazz2 = Class.forName(string);
                        globalDelegateProvider_ = (DelegateProvider)clazz2.newInstance();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(errorStream_);
                        globalDelegateProvider_ = new DefaultDelegateProvider();
                    }
                }
            }
        }
        return globalDelegateProvider_;
    }

    public static Properties getGlobalProperties() {
        return globalProperties_;
    }

    public String getInfo() {
        return this.info_;
    }

    public String getKeystoreSupportProvider() {
        return this.properties_.getProperty("KEY_STORE_SUPPORT_PROVIDER");
    }

    public LoginManager getLoginManager() {
        if (this.loginManager_ == null) {
            IAIKPkcs11 iAIKPkcs11 = this;
            synchronized (iAIKPkcs11) {
                if (this.loginManager_ == null) {
                    String string = this.properties_.getProperty("LOGIN_MANAGER", "iaik.pkcs.pkcs11.provider.DefaultLoginManager");
                    try {
                        Class<?> clazz = Class.forName(string);
                        this.loginManager_ = (LoginManager)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(errorStream_);
                        this.loginManager_ = new DefaultLoginManager();
                    }
                }
            }
        }
        return this.loginManager_;
    }

    public String getModuleInitializationParameters() {
        if (this.initializationParameters_ == null) {
            IAIKPkcs11 iAIKPkcs11 = this;
            synchronized (iAIKPkcs11) {
                if (this.initializationParameters_ == null) {
                    this.initializationParameters_ = this.properties_.getProperty("MODULE_INITIALIZATION_PARAMETERS", null);
                }
            }
        }
        return this.initializationParameters_;
    }

    public Properties getProperties() {
        return this.properties_;
    }

    public synchronized String getProperty(String string) {
        String string2 = super.getProperty(string.toLowerCase());
        if (this.isCheckMechanismSupported() && this.isEngineClassKey(string) && string2 != null) {
            PKCS11EngineClass pKCS11EngineClass = (PKCS11EngineClass)this.engineObjectsCache_.get(string2);
            if (pKCS11EngineClass == null) {
                try {
                    pKCS11EngineClass = (PKCS11EngineClass)Class.forName(string2).newInstance();
                    this.engineObjectsCache_.put(string2, pKCS11EngineClass);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IAIKPkcs11Exception("Error instanciating engine class: " + classNotFoundException.toString());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IAIKPkcs11Exception("Error instanciating engine class: " + illegalAccessException.toString());
                }
                catch (InstantiationException instantiationException) {
                    throw new IAIKPkcs11Exception("Error instanciating engine class: " + instantiationException.toString());
                }
            }
            if (!pKCS11EngineClass.isSupportedBy(this.tokenManager_)) {
                string2 = null;
            }
        }
        return string2;
    }

    public synchronized String getProperty(String string, String string2) {
        return super.getProperty(string, string2);
    }

    public static synchronized IAIKPkcs11 getProviderInstance(int n2) {
        IAIKPkcs11 iAIKPkcs11 = null;
        int n3 = providerInstances_.size();
        if (n3 > 0 && n2 > 0 && n2 <= n3) {
            iAIKPkcs11 = (IAIKPkcs11)providerInstances_.get(n2 - 1);
        }
        return iAIKPkcs11;
    }

    public static synchronized int getProviderInstanceCount() {
        return providerInstances_.size();
    }

    public static synchronized int getProviderInstanceNumber(String string) {
        int n2;
        String string2 = string.startsWith(PROVIDER_BASE_NAME) ? string.substring(PROVIDER_BASE_NAME.length() + 1) : string;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = -1;
        }
        return n2;
    }

    public synchronized int getSessionPoolMaxSize() {
        String string = this.properties_.getProperty("SESSION_POOL_MAX_SIZE", "100");
        int n2 = Integer.parseInt(string);
        n2 = Math.max(n2, 1);
        return n2;
    }

    public TokenManager getTokenManager() {
        return this.tokenManager_;
    }

    public char[] getUserPIN() {
        if (this.userPIN_ == null) {
            IAIKPkcs11 iAIKPkcs11 = this;
            synchronized (iAIKPkcs11) {
                String string;
                if (this.userPIN_ == null && (string = this.properties_.getProperty("USER_PIN", null)) != null) {
                    this.userPIN_ = string.toCharArray();
                }
            }
        }
        return this.userPIN_;
    }

    public double getVersion() {
        return this.version_;
    }

    public synchronized int hashCode() {
        return System.identityHashCode(this);
    }

    public synchronized void initialize() throws IAIKPkcs11Exception {
        if (this.tokenManager_ != null) {
            this.tokenManager_.clearSessionPool(false);
        }
        this.addAlgorithms();
        try {
            this.tokenManager_ = new TokenManager(this);
        }
        catch (IOException iOException) {
            throw new IAIKPkcs11Exception(iOException.toString());
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
        this.setVersion();
        this.setInfo();
        this.engineObjectsCache_ = new Hashtable();
    }

    public static void insertProviderAtForJDK14(Provider provider, int n2) {
        if (provider == null) {
            throw new NullPointerException("Argument \"provider\" must not be null.");
        }
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(((Hashtable)provider).size());
        hashtable.putAll(provider);
        provider.clear();
        provider.put("cipher.null", "iaik.pkcs.pkcs11.provider.NullCipher");
        Security.insertProviderAt(provider, n2);
        try {
            Cipher.getInstance("null", provider.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        provider.remove("cipher.null");
        provider.putAll((Map<?, ?>)hashtable);
    }

    public boolean isCheckMechanismSupported() {
        String string = this.properties_.getProperty("CHECK_MECHANISM_SUPPORTED", "false");
        return Boolean.valueOf(string);
    }

    public static boolean isEnableSoftwareDelegation() {
        String string = globalProperties_.getProperty("enableSoftwareDelegation", "true");
        return Boolean.valueOf(string);
    }

    protected boolean isEngineClassKey(String string) {
        boolean bl = string != null ? (string = string.toLowerCase()).startsWith("signature.") || string.startsWith("cipher.") || string.startsWith("keygenerator.") || string.startsWith("keypairgenerator.") || string.startsWith("messagedigest.") || string.startsWith("mac.") || string.startsWith("keyagreement.") || string.startsWith("keystore.") || string.startsWith("keyfactory.") || string.startsWith("secretkeyfactory.") || string.startsWith("securerandom.") : false;
        return bl;
    }

    public static boolean isIAIKPkcs11Provider(Provider provider) {
        return provider instanceof IAIKPkcs11;
    }

    public boolean isLoginKeystoreOnDemand() {
        String string = this.properties_.getProperty("LOGIN_KEYSTORE_SESSION_ON_DEMAND", "false");
        return Boolean.valueOf(string);
    }

    public boolean isMultiThreadInit() {
        String string = this.properties_.getProperty("MULTI_THREAD_INIT", "true");
        return Boolean.valueOf(string);
    }

    public synchronized void load(InputStream inputStream) throws IOException {
        IAIKPkcs11.checkAccessPermission("loadProviderProperties." + this.getName());
        super.load(inputStream);
    }

    public synchronized Object put(Object object, Object object2) {
        IAIKPkcs11.checkAccessPermission("putProviderProperty." + this.getName());
        if (object != null) {
            object = object.toString().toLowerCase();
        }
        return super.put(object, object2);
    }

    public synchronized void putAll(Map map) {
        IAIKPkcs11.checkAccessPermission("putAllProviderProperties." + this.getName());
        super.putAll((Map<?, ?>)map);
    }

    public synchronized Object remove(Object object) {
        IAIKPkcs11.checkAccessPermission("removeProviderProperty." + this.getName());
        if (object != null) {
            object = object.toString().toLowerCase();
        }
        return super.remove(object);
    }

    public void setCheckMechanismSupported(boolean bl) {
        this.properties_.setProperty("CHECK_MECHANISM_SUPPORTED", String.valueOf(bl));
    }

    public void setDelegateProvider(DelegateProvider delegateProvider) {
        this.delegateProvider_ = delegateProvider;
    }

    public static void setEnableSoftwareDelegation(boolean bl) {
        globalProperties_.setProperty("enableSoftwareDelegation", String.valueOf(bl));
    }

    public static void setGlobalDelegateProvider(DelegateProvider delegateProvider) {
        globalDelegateProvider_ = delegateProvider;
    }

    protected synchronized void setInfo() {
        String string;
        String string2;
        try {
            string2 = this.tokenManager_.getModule().getInfo().getLibraryDescription();
        }
        catch (TokenException tokenException) {
            string2 = this.tokenManager_.getModulePath();
        }
        try {
            string = this.tokenManager_.getSlot().getSlotInfo().getSlotDescription();
        }
        catch (TokenException tokenException) {
            string = Long.toString(this.tokenManager_.getSlot().getSlotID());
        }
        StringBuffer stringBuffer = new StringBuffer(PROVIDER_INFO_BASE.length() + string2.length() + string.length() + 20);
        stringBuffer.append(PROVIDER_INFO_BASE);
        stringBuffer.append("slot \"");
        stringBuffer.append(string.trim());
        stringBuffer.append("\" of module \"");
        stringBuffer.append(string2.trim());
        stringBuffer.append('\"');
        stringBuffer.append(" from PKCS#11 library \"");
        stringBuffer.append(this.tokenManager_.getModulePath());
        stringBuffer.append('\"');
        this.info_ = stringBuffer.toString();
    }

    public void setKeystoreSupportProvider(String string) {
        this.properties_.setProperty("KEY_STORE_SUPPORT_PROVIDER", string);
    }

    public void setLoginKeystoreOnDemand(boolean bl) {
        this.properties_.setProperty("LOGIN_KEYSTORE_SESSION_ON_DEMAND", String.valueOf(bl));
    }

    public void setLoginManager(LoginManager loginManager) {
        this.loginManager_ = loginManager;
    }

    public void setModuleInitializationParameters(String string) {
        this.initializationParameters_ = string;
    }

    public void setMultiThreadInit(boolean bl) {
        this.properties_.setProperty("MULTI_THREAD_INIT", String.valueOf(bl));
    }

    public synchronized void setSessionPoolMaxSize(int n2) {
        n2 = Math.max(n2, 1);
        this.properties_.setProperty("SESSION_POOL_MAX_SIZE", String.valueOf(n2));
    }

    public void setUserPIN(char[] cArray) {
        this.userPIN_ = cArray;
    }

    protected void setVersion() {
        this.version_ = 1.107;
    }

    public String toString() {
        String string = this.getName();
        StringBuffer stringBuffer = new StringBuffer(string.length() + 16);
        stringBuffer.append(string);
        stringBuffer.append(", version: ");
        stringBuffer.append(this.version_);
        stringBuffer.append(", info: ");
        stringBuffer.append(this.info_);
        return stringBuffer.toString();
    }
}

