/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider;

import iaik.apps.util.passphrase.NewPassphrasePrompt;
import iaik.apps.util.passphrase.PassphrasePrompt;
import iaik.apps.util.passphrase.Util;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.SessionInfo;
import iaik.pkcs.pkcs11.State;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.provider.Constants;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11AuthenticationCanceledException;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11AuthenticationException;
import iaik.pkcs.pkcs11.provider.LoginManager;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;

public class DefaultLoginManager
implements LoginManager {
    private static final boolean DEBUG = false;
    protected static final String DEFAULT_CONFIGURATION_PROPERTIES = "iaik/pkcs/pkcs11/provider/default/DefaultLoginManager.properties";
    protected static final String CONFIGURATION_PROPERTIES = "iaik/pkcs/pkcs11/provider/DefaultLoginManager.properties";
    protected static final String DEFAULT_PROMPT_DIALOG = "DEFAULT_PROMPT_DIALOG";
    protected static final String DEFAULT_CHANGE_DIALOG = "DEFAULT_CHANGE_DIALOG";
    protected static final String DEFAULT_NEW_PROMPT_MESSAGE_PREFIX = "DEFAULT_NEW_PROMPT_MESSAGE_PREFIX";
    protected static final String DEFAULT_PROMPT_MESSAGE_PREFIX = "DEFAULT_PROMPT_MESSAGE_PREFIX";
    protected static final String WRONG_PIN_WARNING = "WRONG_PIN_WARNING";
    protected static final String PIN_FINAL_TRY_WARNING = "PIN_FINAL_TRY_WARNING";
    protected static final String KEY_WORD_TRIALS_LEFT = "$(TRIALS_LEFT)";
    protected static final String KEY_WORD_TOKEN_LABEL = "$(TOKEN_LABEL)";
    protected static final String NUMBER_OF_USER_LOGIN_RETRIES = "NUMBER_OF_USER_LOGIN_RETRIES";
    protected static final String INVALID_NEW_PIN_WARNING = "INVALID_NEW_PIN_WARNING";
    protected static final String NEW_PIN_LENGTH_WARNING = "NEW_PIN_LENGTH_WARNING";
    protected static final String USE_PROTECTED_AUTHENTICATION_PATH = "USE_PROTECTED_AUTHENTICATION_PATH";
    protected static final String FORCE_PROTECTED_AUTHENTICATION_PATH = "FORCE_PROTECTED_AUTHENTICATION_PATH";
    protected static String LINE_SEPARATOR = Constants.LINE_SEPARATOR;
    protected static Properties defaultConfiguration_;
    protected Properties properties_ = new Properties(defaultConfiguration_);
    protected PassphrasePrompt passphrasePrompt_;
    protected NewPassphrasePrompt passphraseChangePrompt_;
    static /* synthetic */ Class class$iaik$pkcs$pkcs11$provider$DefaultLoginManager;
    static /* synthetic */ Class class$iaik$pkcs$pkcs11$provider$IAIKPkcs11;

    static {
        try {
            URL uRL = (class$iaik$pkcs$pkcs11$provider$DefaultLoginManager != null ? class$iaik$pkcs$pkcs11$provider$DefaultLoginManager : (class$iaik$pkcs$pkcs11$provider$DefaultLoginManager = DefaultLoginManager.class$("iaik.pkcs.pkcs11.provider.DefaultLoginManager"))).getClassLoader().getResource(DEFAULT_CONFIGURATION_PROPERTIES);
            InputStream inputStream = uRL.openStream();
            Properties properties = new Properties();
            properties.load(inputStream);
            URL uRL2 = (class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 != null ? class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 : (class$iaik$pkcs$pkcs11$provider$IAIKPkcs11 = DefaultLoginManager.class$("iaik.pkcs.pkcs11.provider.IAIKPkcs11"))).getClassLoader().getResource(CONFIGURATION_PROPERTIES);
            if (uRL2 != null) {
                InputStream inputStream2 = uRL2.openStream();
                Properties properties2 = new Properties(properties);
                properties2.load(inputStream2);
                inputStream2.close();
                defaultConfiguration_ = properties2;
            } else {
                defaultConfiguration_ = properties;
            }
        }
        catch (IOException iOException) {
            IAIKPkcs11.errorStream_.println("Could not load DefaultLoginManager configuration properties.");
            iOException.printStackTrace(IAIKPkcs11.errorStream_);
            defaultConfiguration_ = null;
        }
    }

    public DefaultLoginManager() {
        this(null);
    }

    public DefaultLoginManager(Properties properties) {
        if (properties != null) {
            ((Hashtable)this.properties_).putAll(properties);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int getNumberOfLoginRetries() {
        String string = this.properties_.getProperty(NUMBER_OF_USER_LOGIN_RETRIES, "3");
        int n2 = Integer.parseInt(string);
        n2 = Math.max(n2, 1);
        return n2;
    }

    public NewPassphrasePrompt getPassphraseChangePrompt() {
        block2: {
            if (this.passphraseChangePrompt_ != null) break block2;
            String string = this.properties_.getProperty(DEFAULT_CHANGE_DIALOG, "iaik.apps.util.passphrase.NewPassphraseDialog");
            try {
                Class<?> clazz = Class.forName(string);
                this.passphraseChangePrompt_ = (NewPassphrasePrompt)clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace(IAIKPkcs11.errorStream_);
            }
        }
        return this.passphraseChangePrompt_;
    }

    public PassphrasePrompt getPassphrasePrompt() {
        block2: {
            if (this.passphrasePrompt_ != null) break block2;
            String string = this.properties_.getProperty(DEFAULT_PROMPT_DIALOG, "iaik.apps.util.passphrase.PassphraseDialog");
            try {
                Class<?> clazz = Class.forName(string);
                this.passphrasePrompt_ = (PassphrasePrompt)clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace(IAIKPkcs11.errorStream_);
            }
        }
        return this.passphrasePrompt_;
    }

    public Properties getProperties() {
        return this.properties_;
    }

    public boolean isForceProtectedAuthenticationPath() {
        String string = this.properties_.getProperty(FORCE_PROTECTED_AUTHENTICATION_PATH, "false");
        return Boolean.valueOf(string);
    }

    public boolean isUseProtectedAuthenticationPath() {
        String string = this.properties_.getProperty(USE_PROTECTED_AUTHENTICATION_PATH, "true");
        return Boolean.valueOf(string);
    }

    public void loginUser(TokenManager tokenManager, Session session, char[] cArray) throws TokenException, IAIKPkcs11AuthenticationCanceledException, IAIKPkcs11AuthenticationException {
        boolean bl;
        if (tokenManager == null) {
            throw new NullPointerException("Argument \"tokenManager\" must not be null");
        }
        if (session == null) {
            session = tokenManager.getSession(false);
            bl = true;
        } else {
            bl = false;
        }
        try {
            SessionInfo sessionInfo = session.getSessionInfo();
            State state = sessionInfo.getState();
            if (state.equals(State.RW_SO_FUNCTIONS)) {
                session.logout();
            }
            TokenException tokenException = null;
            if (!state.equals(State.RO_USER_FUNCTIONS) && !state.equals(State.RW_USER_FUNCTIONS)) {
                int n2 = this.getNumberOfLoginRetries();
                TokenInfo tokenInfo = session.getToken().getTokenInfo();
                if (this.useNullPINs(tokenManager, session)) {
                    while (n2-- > 0) {
                        try {
                            session.login(true, null);
                            break;
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            if (pKCS11Exception.getErrorCode() == 160L) continue;
                            throw new IAIKPkcs11AuthenticationException("Failed to login the user: " + pKCS11Exception.toString());
                        }
                    }
                } else {
                    if (cArray != null) {
                        try {
                            session.login(true, cArray);
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            if (pKCS11Exception.getErrorCode() == 160L) {
                                throw new IAIKPkcs11AuthenticationException("PIN Incorrect. Failed to login the user: " + pKCS11Exception.toString());
                            }
                            throw pKCS11Exception;
                        }
                    }
                    PassphrasePrompt passphrasePrompt = this.getPassphrasePrompt();
                    String string = String.valueOf(this.properties_.getProperty(DEFAULT_PROMPT_MESSAGE_PREFIX, "Plaese enter User-PIN for this token")) + LINE_SEPARATOR + LINE_SEPARATOR;
                    String string2 = Util.fixString(tokenInfo.getLabel());
                    string = this.replaceKeyWord(string, KEY_WORD_TOKEN_LABEL, string2);
                    passphrasePrompt.setMessage(string);
                    passphrasePrompt.setProtectedResourceInfo(tokenInfo);
                    while (n2-- > 0) {
                        Object object;
                        tokenInfo = session.getToken().getTokenInfo();
                        if (tokenInfo.isUserPinLocked()) {
                            throw new IAIKPkcs11AuthenticationException("Cannot login user, the user PIN is locked.");
                        }
                        if (tokenInfo.isUserPinFinalTry()) {
                            object = String.valueOf(this.properties_.getProperty(PIN_FINAL_TRY_WARNING, "Warning! The token reported that this will be the final try before the PIN gets blocked.")) + LINE_SEPARATOR + string;
                            string2 = Util.fixString(tokenInfo.getLabel());
                            object = this.replaceKeyWord((String)object, KEY_WORD_TOKEN_LABEL, string2);
                            passphrasePrompt.setMessage(object);
                        }
                        if ((object = passphrasePrompt.promptPassphrase()) == null) {
                            throw new IAIKPkcs11AuthenticationCanceledException("User canceled PIN entry.");
                        }
                        try {
                            session.login(true, (char[])object);
                            break;
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            tokenException = pKCS11Exception;
                            if (pKCS11Exception.getErrorCode() == 160L) {
                                String string3 = this.properties_.getProperty(WRONG_PIN_WARNING, "Wrong PIN! You have $(TRIALS_LEFT) trials left.");
                                string3 = this.replaceKeyWord(string3, KEY_WORD_TRIALS_LEFT, String.valueOf(n2));
                                String string4 = String.valueOf(string3) + LINE_SEPARATOR + string;
                                string2 = Util.fixString(tokenInfo.getLabel());
                                string4 = this.replaceKeyWord(string4, KEY_WORD_TOKEN_LABEL, string2);
                                passphrasePrompt.setMessage(string4);
                                continue;
                            }
                            throw pKCS11Exception;
                        }
                    }
                }
            }
            if (!(state = (sessionInfo = session.getSessionInfo()).getState()).equals(State.RO_USER_FUNCTIONS) && !state.equals(State.RW_USER_FUNCTIONS)) {
                String string = tokenException != null ? "Failed to login the user: " + tokenException.toString() : "Failed to login the user.";
                throw new IAIKPkcs11AuthenticationException(string);
            }
            Object var6_20 = null;
            if (bl) {
                tokenManager.disposeSession(session);
            }
        }
        catch (Throwable throwable) {
            Object var6_21 = null;
            if (bl) {
                tokenManager.disposeSession(session);
            }
            throw throwable;
        }
    }

    public void logout(TokenManager tokenManager, Session session) throws TokenException {
        boolean bl;
        if (session == null) {
            session = tokenManager.getSession(true);
            bl = true;
        } else {
            bl = false;
        }
        try {
            session.logout();
        }
        finally {
            Object var5_4 = null;
            if (bl) {
                tokenManager.disposeSession(session);
            }
        }
    }

    protected String replaceKeyWord(String string, String string2, String string3) {
        String string4 = string;
        int n2 = 0;
        while ((n2 = string4.indexOf(string2, n2)) >= 0) {
            string4 = String.valueOf(string4.substring(0, n2)) + string3 + string4.substring(n2 + string2.length());
        }
        return string4;
    }

    public void setForceProtectedAuthenticationPath(boolean bl) {
        this.properties_.setProperty(FORCE_PROTECTED_AUTHENTICATION_PATH, String.valueOf(bl));
    }

    public void setNumberOfLoginRetries(int n2) {
        n2 = Math.max(n2, 1);
        this.properties_.setProperty(NUMBER_OF_USER_LOGIN_RETRIES, String.valueOf(n2));
    }

    public void setPassphraseChangePrompt(NewPassphrasePrompt newPassphrasePrompt) {
        this.passphraseChangePrompt_ = newPassphrasePrompt;
    }

    public void setPassphrasePrompt(PassphrasePrompt passphrasePrompt) {
        this.passphrasePrompt_ = passphrasePrompt;
    }

    public void setProperties(Properties properties) {
        this.properties_ = properties != null ? properties : (Properties)((Hashtable)defaultConfiguration_).clone();
    }

    public void setUseProtectedAuthenticationPath(boolean bl) {
        this.properties_.setProperty(USE_PROTECTED_AUTHENTICATION_PATH, String.valueOf(bl));
    }

    public void setUserPIN(TokenManager tokenManager, Session session, char[] cArray, char[] cArray2) throws TokenException, IAIKPkcs11AuthenticationCanceledException, IAIKPkcs11AuthenticationException {
        boolean bl;
        if (session == null) {
            session = tokenManager.getSession(true);
            bl = true;
        } else {
            bl = false;
        }
        try {
            SessionInfo sessionInfo = session.getSessionInfo();
            State state = sessionInfo.getState();
            if (state.equals(State.RW_SO_FUNCTIONS)) {
                session.logout();
            }
            int n2 = this.getNumberOfLoginRetries();
            TokenInfo tokenInfo = session.getToken().getTokenInfo();
            if (this.useNullPINs(tokenManager, session)) {
                while (n2-- > 0) {
                    try {
                        sessionInfo = session.getSessionInfo();
                        state = sessionInfo.getState();
                        if (!state.equals(State.RO_USER_FUNCTIONS) && !state.equals(State.RW_USER_FUNCTIONS)) {
                            session.login(true, null);
                        }
                        session.setPIN(null, null);
                        break;
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        long l2 = pKCS11Exception.getErrorCode();
                        if (l2 == 160L || l2 == 161L || l2 == 162L) continue;
                        throw new IAIKPkcs11AuthenticationException(pKCS11Exception.toString());
                    }
                }
            } else {
                if (cArray != null && cArray2 != null) {
                    try {
                        sessionInfo = session.getSessionInfo();
                        state = sessionInfo.getState();
                        if (!state.equals(State.RO_USER_FUNCTIONS) && !state.equals(State.RW_USER_FUNCTIONS)) {
                            session.login(true, cArray);
                        }
                        session.setPIN(cArray, cArray2);
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        if (pKCS11Exception.getErrorCode() == 160L) {
                            throw new IAIKPkcs11AuthenticationException("Old PIN Incorrect. Failed to login the user: " + pKCS11Exception.toString());
                        }
                        throw pKCS11Exception;
                    }
                }
                if (cArray != null) {
                    NewPassphrasePrompt newPassphrasePrompt = this.getPassphraseChangePrompt();
                    newPassphrasePrompt.setOldPassphraseRequired(false);
                    try {
                        sessionInfo = session.getSessionInfo();
                        state = sessionInfo.getState();
                        if (!state.equals(State.RO_USER_FUNCTIONS) && !state.equals(State.RW_USER_FUNCTIONS)) {
                            session.login(true, cArray);
                        }
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        long l3 = pKCS11Exception.getErrorCode();
                        if (l3 == 160L) {
                            throw new IAIKPkcs11AuthenticationException("The provided user PIN is invalid.");
                        }
                        throw pKCS11Exception;
                    }
                    String string = String.valueOf(this.properties_.getProperty(DEFAULT_NEW_PROMPT_MESSAGE_PREFIX, "Please enter new User-PIN for this token")) + LINE_SEPARATOR + LINE_SEPARATOR;
                    String string2 = Util.fixString(tokenInfo.getLabel());
                    string = this.replaceKeyWord(string, KEY_WORD_TOKEN_LABEL, string2);
                    newPassphrasePrompt.setMessage(string);
                    newPassphrasePrompt.setProtectedResourceInfo(tokenInfo);
                    while (n2-- > 0) {
                        Object object;
                        tokenInfo = session.getToken().getTokenInfo();
                        if (tokenInfo.isUserPinLocked()) {
                            throw new IAIKPkcs11AuthenticationException("Cannot set user PIN, the user PIN is locked.");
                        }
                        if (tokenInfo.isUserPinFinalTry()) {
                            object = String.valueOf(this.properties_.getProperty(PIN_FINAL_TRY_WARNING, "Warning! The token reported that this will be the final try before the PIN gets blocked.")) + LINE_SEPARATOR + string;
                            string2 = Util.fixString(tokenInfo.getLabel());
                            object = this.replaceKeyWord((String)object, KEY_WORD_TOKEN_LABEL, string2);
                            newPassphrasePrompt.setMessage(object);
                        }
                        if ((object = newPassphrasePrompt.promptNewPassphrase()) == null) {
                            throw new IAIKPkcs11AuthenticationCanceledException("User canceled new PIN entry.");
                        }
                        try {
                            session.setPIN(cArray, object[1]);
                            break;
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            String string3;
                            String string4;
                            long l4 = pKCS11Exception.getErrorCode();
                            if (l4 == 161L) {
                                string4 = this.properties_.getProperty(INVALID_NEW_PIN_WARNING, "The entered new PIN is invalid.");
                                string3 = String.valueOf(string4) + LINE_SEPARATOR + string;
                                string2 = Util.fixString(tokenInfo.getLabel());
                                string3 = this.replaceKeyWord(string3, KEY_WORD_TOKEN_LABEL, string2);
                                newPassphrasePrompt.setMessage(string3);
                                continue;
                            }
                            if (l4 == 162L) {
                                string4 = this.properties_.getProperty(NEW_PIN_LENGTH_WARNING, "The length of the new PIN is invalid.");
                                string3 = String.valueOf(string4) + LINE_SEPARATOR + string;
                                string2 = Util.fixString(tokenInfo.getLabel());
                                string3 = this.replaceKeyWord(string3, KEY_WORD_TOKEN_LABEL, string2);
                                newPassphrasePrompt.setMessage(string3);
                                continue;
                            }
                            throw pKCS11Exception;
                        }
                    }
                } else if (cArray2 != null) {
                    PassphrasePrompt passphrasePrompt = this.getPassphrasePrompt();
                    String string = String.valueOf(this.properties_.getProperty(DEFAULT_PROMPT_MESSAGE_PREFIX, "Plaese enter User-PIN for this token")) + LINE_SEPARATOR + LINE_SEPARATOR;
                    String string5 = Util.fixString(tokenInfo.getLabel());
                    string = this.replaceKeyWord(string, KEY_WORD_TOKEN_LABEL, string5);
                    passphrasePrompt.setMessage(string);
                    passphrasePrompt.setProtectedResourceInfo(tokenInfo);
                    while (n2-- > 0) {
                        Object object;
                        tokenInfo = session.getToken().getTokenInfo();
                        if (tokenInfo.isUserPinLocked()) {
                            throw new IAIKPkcs11AuthenticationException("Cannot login user, the user PIN is locked.");
                        }
                        if (tokenInfo.isUserPinFinalTry()) {
                            object = String.valueOf(this.properties_.getProperty(PIN_FINAL_TRY_WARNING, "Warning! The token reported that this will be the final try before the PIN gets blocked.")) + LINE_SEPARATOR + string;
                            string5 = Util.fixString(tokenInfo.getLabel());
                            object = this.replaceKeyWord((String)object, KEY_WORD_TOKEN_LABEL, string5);
                            passphrasePrompt.setMessage(object);
                        }
                        if ((object = passphrasePrompt.promptPassphrase()) == null) {
                            throw new IAIKPkcs11AuthenticationCanceledException("User canceled PIN entry.");
                        }
                        try {
                            sessionInfo = session.getSessionInfo();
                            state = sessionInfo.getState();
                            if (!state.equals(State.RO_USER_FUNCTIONS) && !state.equals(State.RW_USER_FUNCTIONS)) {
                                session.login(true, (char[])object);
                            }
                            session.setPIN((char[])object, cArray2);
                            break;
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            long l5 = pKCS11Exception.getErrorCode();
                            if (l5 == 160L) {
                                String string6 = this.properties_.getProperty(WRONG_PIN_WARNING, "Wrong PIN! You have $(TRIALS_LEFT) trials left.");
                                string6 = this.replaceKeyWord(string6, KEY_WORD_TRIALS_LEFT, String.valueOf(n2));
                                String string7 = String.valueOf(string6) + LINE_SEPARATOR + string;
                                string5 = Util.fixString(tokenInfo.getLabel());
                                string7 = this.replaceKeyWord(string7, KEY_WORD_TOKEN_LABEL, string5);
                                passphrasePrompt.setMessage(string7);
                                continue;
                            }
                            throw pKCS11Exception;
                        }
                    }
                } else {
                    NewPassphrasePrompt newPassphrasePrompt = this.getPassphraseChangePrompt();
                    newPassphrasePrompt.setOldPassphraseRequired(true);
                    String string = String.valueOf(this.properties_.getProperty(DEFAULT_NEW_PROMPT_MESSAGE_PREFIX, "Please enter new User-PIN for this token")) + LINE_SEPARATOR + LINE_SEPARATOR;
                    String string8 = Util.fixString(tokenInfo.getLabel());
                    string = this.replaceKeyWord(string, KEY_WORD_TOKEN_LABEL, string8);
                    newPassphrasePrompt.setMessage(string);
                    newPassphrasePrompt.setProtectedResourceInfo(tokenInfo);
                    PKCS11Exception pKCS11Exception = null;
                    while (n2-- > 0) {
                        Object object;
                        tokenInfo = session.getToken().getTokenInfo();
                        if (tokenInfo.isUserPinLocked()) {
                            throw new IAIKPkcs11AuthenticationException("Cannot set user PIN, the user PIN is locked.");
                        }
                        if (tokenInfo.isUserPinFinalTry()) {
                            object = String.valueOf(this.properties_.getProperty(PIN_FINAL_TRY_WARNING, "Warning! The token reported that this will be the final try before the PIN gets blocked.")) + LINE_SEPARATOR + string;
                            string8 = Util.fixString(tokenInfo.getLabel());
                            object = this.replaceKeyWord((String)object, KEY_WORD_TOKEN_LABEL, string8);
                            newPassphrasePrompt.setMessage(object);
                        }
                        if ((object = newPassphrasePrompt.promptNewPassphrase()) == null) {
                            throw new IAIKPkcs11AuthenticationCanceledException("User canceled new PIN entry.");
                        }
                        try {
                            sessionInfo = session.getSessionInfo();
                            state = sessionInfo.getState();
                            if (!state.equals(State.RO_USER_FUNCTIONS) && !state.equals(State.RW_USER_FUNCTIONS)) {
                                session.login(true, object[0]);
                                pKCS11Exception = null;
                            }
                            session.setPIN(object[0], object[1]);
                            break;
                        }
                        catch (PKCS11Exception pKCS11Exception2) {
                            String string9;
                            String string10;
                            long l6 = pKCS11Exception2.getErrorCode();
                            if (l6 == 160L) {
                                pKCS11Exception = pKCS11Exception2;
                                if (cArray != null) break;
                                string10 = this.properties_.getProperty(WRONG_PIN_WARNING, "Wrong PIN! You have $(TRIALS_LEFT) trials left.");
                                string10 = this.replaceKeyWord(string10, KEY_WORD_TRIALS_LEFT, String.valueOf(n2));
                                string9 = String.valueOf(string10) + LINE_SEPARATOR + string;
                                string8 = Util.fixString(tokenInfo.getLabel());
                                string9 = this.replaceKeyWord(string9, KEY_WORD_TOKEN_LABEL, string8);
                                newPassphrasePrompt.setMessage(string9);
                                continue;
                            }
                            if (l6 == 161L) {
                                string10 = this.properties_.getProperty(INVALID_NEW_PIN_WARNING, "The entered new PIN is invalid.");
                                string9 = String.valueOf(string10) + LINE_SEPARATOR + string;
                                string8 = Util.fixString(tokenInfo.getLabel());
                                string9 = this.replaceKeyWord(string9, KEY_WORD_TOKEN_LABEL, string8);
                                newPassphrasePrompt.setMessage(string9);
                                continue;
                            }
                            if (l6 == 162L) {
                                string10 = this.properties_.getProperty(NEW_PIN_LENGTH_WARNING, "The length of the new PIN is invalid.");
                                string9 = String.valueOf(string10) + LINE_SEPARATOR + string;
                                string8 = Util.fixString(tokenInfo.getLabel());
                                string9 = this.replaceKeyWord(string9, KEY_WORD_TOKEN_LABEL, string8);
                                newPassphrasePrompt.setMessage(string9);
                                continue;
                            }
                            throw pKCS11Exception2;
                        }
                    }
                    if (pKCS11Exception != null) {
                        throw new IAIKPkcs11AuthenticationException("The provided user PIN is invalid.");
                    }
                }
            }
            Object var7_40 = null;
            if (bl) {
                tokenManager.disposeSession(session);
            }
        }
        catch (Throwable throwable) {
            Object var7_41 = null;
            if (bl) {
                tokenManager.disposeSession(session);
            }
            throw throwable;
        }
    }

    protected boolean useNullPINs(TokenManager tokenManager, Session session) throws TokenException {
        if (tokenManager == null) {
            throw new NullPointerException("Argument \"tokenManager\" must not be null");
        }
        return this.isForceProtectedAuthenticationPath() || this.isUseProtectedAuthenticationPath() && tokenManager.getToken().getTokenInfo().isProtectedAuthenticationPath();
    }
}

