/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.parameters.Parameters;

public class RC2Parameters
implements Parameters {
    protected long effectiveBits_;

    public RC2Parameters(long l2) {
        if (l2 < 1L || l2 > 1024L) {
            throw new IllegalArgumentException("Argument \"effectiveBits\" must be in the range [1, 1024].");
        }
        this.effectiveBits_ = l2;
    }

    public Object clone() {
        RC2Parameters rC2Parameters;
        try {
            rC2Parameters = (RC2Parameters)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", cloneNotSupportedException);
        }
        return rC2Parameters;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof RC2Parameters) {
            RC2Parameters rC2Parameters = (RC2Parameters)object;
            bl = this == rC2Parameters || this.effectiveBits_ == rC2Parameters.effectiveBits_;
        }
        return bl;
    }

    public long getEffectiveBits() {
        return this.effectiveBits_;
    }

    public Object getPKCS11ParamsObject() {
        return new Long(this.effectiveBits_);
    }

    public int hashCode() {
        return (int)this.effectiveBits_;
    }

    public void setEffectiveBits(long l2) {
        if (l2 < 1L || l2 > 1024L) {
            throw new IllegalArgumentException("Argument \"effectiveBits\" must be in the range [1, 1024].");
        }
        this.effectiveBits_ = l2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  ");
        stringBuffer.append("Effective Bits (dec): ");
        stringBuffer.append(this.effectiveBits_);
        return stringBuffer.toString();
    }
}

