/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class X942DHPublicKey
extends PublicKey {
    protected ByteArrayAttribute prime_;
    protected ByteArrayAttribute base_;
    protected ByteArrayAttribute subprime_;
    protected ByteArrayAttribute value_;

    public X942DHPublicKey() {
        this.keyType_.setLongValue(Key.KeyType.X9_42_DH);
    }

    protected X942DHPublicKey(Session session, long l2) throws TokenException {
        super(session, l2);
        this.keyType_.setLongValue(Key.KeyType.X9_42_DH);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.prime_ = new ByteArrayAttribute(Attribute.PRIME);
        this.base_ = new ByteArrayAttribute(Attribute.BASE);
        this.subprime_ = new ByteArrayAttribute(Attribute.SUBPRIME);
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        X942DHPublicKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        X942DHPublicKey x942DHPublicKey = (X942DHPublicKey)super.clone();
        x942DHPublicKey.prime_ = (ByteArrayAttribute)this.prime_.clone();
        x942DHPublicKey.base_ = (ByteArrayAttribute)this.base_.clone();
        x942DHPublicKey.subprime_ = (ByteArrayAttribute)this.subprime_.clone();
        x942DHPublicKey.value_ = (ByteArrayAttribute)this.value_.clone();
        X942DHPublicKey.putAttributesInTable(x942DHPublicKey);
        return x942DHPublicKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof X942DHPublicKey) {
            X942DHPublicKey x942DHPublicKey = (X942DHPublicKey)object;
            bl = this == x942DHPublicKey || super.equals(x942DHPublicKey) && this.prime_.equals(x942DHPublicKey.prime_) && this.base_.equals(x942DHPublicKey.base_) && this.subprime_.equals(x942DHPublicKey.subprime_) && this.value_.equals(x942DHPublicKey.value_);
        }
        return bl;
    }

    public ByteArrayAttribute getBase() {
        return this.base_;
    }

    public static Object getInstance(Session session, long l2) throws TokenException {
        return new X942DHPublicKey(session, l2);
    }

    public ByteArrayAttribute getPrime() {
        return this.prime_;
    }

    public ByteArrayAttribute getSubprime() {
        return this.subprime_;
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    protected static void putAttributesInTable(X942DHPublicKey x942DHPublicKey) {
        if (x942DHPublicKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        x942DHPublicKey.attributeTable_.put(Attribute.PRIME, x942DHPublicKey.prime_);
        x942DHPublicKey.attributeTable_.put(Attribute.BASE, x942DHPublicKey.base_);
        x942DHPublicKey.attributeTable_.put(Attribute.SUBPRIME, x942DHPublicKey.subprime_);
        x942DHPublicKey.attributeTable_.put(Attribute.VALUE, x942DHPublicKey.value_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.prime_);
        Object.getAttributeValue(session, this.objectHandle_, this.base_);
        Object.getAttributeValue(session, this.objectHandle_, this.subprime_);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Prime (hex): ");
        stringBuffer.append(this.prime_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Base (hex): ");
        stringBuffer.append(this.base_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Subprime (hex): ");
        stringBuffer.append(this.subprime_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        return stringBuffer.toString();
    }
}

