/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.CharArrayAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class Storage
extends Object {
    protected BooleanAttribute token_;
    protected BooleanAttribute private_;
    protected BooleanAttribute modifiable_;
    protected CharArrayAttribute label_;

    public Storage() {
    }

    protected Storage(Session session, long l2) throws TokenException {
        super(session, l2);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.token_ = new BooleanAttribute(Attribute.TOKEN);
        this.private_ = new BooleanAttribute(Attribute.PRIVATE);
        this.modifiable_ = new BooleanAttribute(Attribute.MODIFIABLE);
        this.label_ = new CharArrayAttribute(Attribute.LABEL);
        Storage.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        Storage storage = (Storage)super.clone();
        storage.token_ = (BooleanAttribute)this.token_.clone();
        storage.private_ = (BooleanAttribute)this.private_.clone();
        storage.modifiable_ = (BooleanAttribute)this.modifiable_.clone();
        storage.label_ = (CharArrayAttribute)this.label_.clone();
        Storage.putAttributesInTable(storage);
        return storage;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof Storage) {
            Storage storage = (Storage)object;
            bl = this == storage || super.equals(storage) && this.token_.equals(storage.token_) && this.private_.equals(storage.private_) && this.modifiable_.equals(storage.modifiable_) && this.label_.equals(storage.label_);
        }
        return bl;
    }

    public CharArrayAttribute getLabel() {
        return this.label_;
    }

    public BooleanAttribute getModifiable() {
        return this.modifiable_;
    }

    public BooleanAttribute getPrivate() {
        return this.private_;
    }

    public BooleanAttribute getToken() {
        return this.token_;
    }

    public int hashCode() {
        return this.token_.hashCode() ^ this.private_.hashCode() ^ this.modifiable_.hashCode() ^ this.label_.hashCode();
    }

    protected static void putAttributesInTable(Storage storage) {
        if (storage == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        storage.attributeTable_.put(Attribute.TOKEN, storage.token_);
        storage.attributeTable_.put(Attribute.PRIVATE, storage.private_);
        storage.attributeTable_.put(Attribute.MODIFIABLE, storage.modifiable_);
        storage.attributeTable_.put(Attribute.LABEL, storage.label_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.token_);
        Object.getAttributeValue(session, this.objectHandle_, this.private_);
        Object.getAttributeValue(session, this.objectHandle_, this.modifiable_);
        Object.getAttributeValue(session, this.objectHandle_, this.label_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Token: ");
        stringBuffer.append(this.token_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Private: ");
        stringBuffer.append(this.private_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Modifiable: ");
        stringBuffer.append(this.modifiable_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Label: ");
        stringBuffer.append(this.label_.toString());
        return stringBuffer.toString();
    }
}

