/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.Certificate;
import iaik.pkcs.pkcs11.objects.Data;
import iaik.pkcs.pkcs11.objects.DomainParameters;
import iaik.pkcs.pkcs11.objects.HardwareFeature;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.ObjectClassAttribute;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Object
implements Cloneable {
    protected static VendorDefinedObjectBuilder vendorObjectBuilder_;
    protected static Hashtable objectClassNames_;
    protected Hashtable attributeTable_ = new Hashtable(32);
    protected ObjectClassAttribute objectClass_;
    protected long objectHandle_ = -1L;

    public Object() {
        this.allocateAttributes();
    }

    protected Object(Session session, long l2) throws TokenException {
        this.allocateAttributes();
        this.objectHandle_ = l2;
        this.readAttributes(session);
    }

    protected void allocateAttributes() {
        this.objectClass_ = new ObjectClassAttribute();
        Object.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        Object object;
        try {
            object = (Object)super.clone();
            object.objectClass_ = (ObjectClassAttribute)this.objectClass_.clone();
            object.attributeTable_ = new Hashtable(32);
            Object.putAttributesInTable(object);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", cloneNotSupportedException);
        }
        return object;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof Object) {
            Object object2 = (Object)object;
            bl = this == object2 || this.objectHandle_ == object2.objectHandle_ && this.objectClass_.equals(object2.objectClass_);
        }
        return bl;
    }

    public Hashtable getAttributeTable() {
        return (Hashtable)this.attributeTable_.clone();
    }

    protected static void getAttributeValue(Session session, long l2, Attribute attribute) throws PKCS11Exception {
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        PKCS11 pKCS11 = session.getModule().getPKCS11Module();
        long l3 = session.getSessionHandle();
        long l4 = attribute.getCkAttribute().type;
        try {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
            cK_ATTRIBUTEArray[0].type = l4;
            pKCS11.C_GetAttributeValue(l3, l2, cK_ATTRIBUTEArray);
            attribute.setCkAttribute(cK_ATTRIBUTEArray[0]);
            attribute.setPresent(true);
            attribute.setSensitive(false);
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (pKCS11Exception.getErrorCode() == 18L) {
                attribute.setPresent(false);
            }
            if (pKCS11Exception.getErrorCode() == 17L) {
                attribute.setPresent(true);
                attribute.setSensitive(true);
            }
            throw pKCS11Exception;
        }
    }

    public static Object getInstance(Session session, long l2) throws TokenException {
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        PKCS11 pKCS11 = session.getModule().getPKCS11Module();
        ObjectClassAttribute objectClassAttribute = new ObjectClassAttribute();
        Object.getAttributeValue(session, l2, objectClassAttribute);
        Long l3 = objectClassAttribute.getLongValue();
        Object object = objectClassAttribute.isPresent() && l3 != null ? (l3.equals(ObjectClass.PRIVATE_KEY) ? PrivateKey.getInstance(session, l2) : (l3.equals(ObjectClass.PUBLIC_KEY) ? PublicKey.getInstance(session, l2) : (l3.equals(ObjectClass.CERTIFICATE) ? Certificate.getInstance(session, l2) : (l3.equals(ObjectClass.SECRET_KEY) ? SecretKey.getInstance(session, l2) : (l3.equals(ObjectClass.DATA) ? Data.getInstance(session, l2) : (l3.equals(ObjectClass.DOMAIN_PARAMETERS) ? DomainParameters.getInstance(session, l2) : (l3.equals(ObjectClass.HW_FEATURE) ? HardwareFeature.getInstance(session, l2) : ((l3 & ObjectClass.VENDOR_DEFINED) != 0L ? Object.getUnknownObject(session, l2) : Object.getUnknownObject(session, l2))))))))) : Object.getUnknownObject(session, l2);
        return object;
    }

    public LongAttribute getObjectClass() {
        return this.objectClass_;
    }

    public static String getObjectClassName(Long l2) {
        String string;
        if (l2 == null) {
            throw new NullPointerException("Argument \"objectClass\" must not be null.");
        }
        if ((l2 & 0x80000000L) != 0L) {
            string = "Vendor Defined";
        } else {
            if (objectClassNames_ == null) {
                Hashtable<Long, String> hashtable = new Hashtable<Long, String>(7);
                hashtable.put(ObjectClass.DATA, "Data");
                hashtable.put(ObjectClass.CERTIFICATE, "Certificate");
                hashtable.put(ObjectClass.PUBLIC_KEY, "Public Key");
                hashtable.put(ObjectClass.PRIVATE_KEY, "Private Key");
                hashtable.put(ObjectClass.SECRET_KEY, "Secret Key");
                hashtable.put(ObjectClass.HW_FEATURE, "Hardware Feature");
                hashtable.put(ObjectClass.DOMAIN_PARAMETERS, "Domain Parameters");
                objectClassNames_ = hashtable;
            }
            if ((string = (String)objectClassNames_.get(l2)) == null) {
                string = "<unknown>";
            }
        }
        return string;
    }

    public long getObjectHandle() {
        return this.objectHandle_;
    }

    public Vector getSetAttributes() {
        Vector<CK_ATTRIBUTE> vector = new Vector<CK_ATTRIBUTE>(this.attributeTable_.size());
        Enumeration enumeration = this.attributeTable_.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (!attribute.isPresent()) continue;
            CK_ATTRIBUTE cK_ATTRIBUTE = attribute.getCkAttribute();
            vector.addElement(cK_ATTRIBUTE);
        }
        return vector;
    }

    public static CK_ATTRIBUTE[] getSetAttributes(Object object) throws PKCS11Exception {
        Vector vector = object != null ? object.getSetAttributes() : null;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = vector != null ? Util.convertAttributesVectorToArray(vector) : null;
        return cK_ATTRIBUTEArray;
    }

    protected static Object getUnknownObject(Session session, long l2) throws TokenException {
        Object object;
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        if (vendorObjectBuilder_ != null) {
            try {
                object = vendorObjectBuilder_.build(session, l2);
            }
            catch (PKCS11Exception pKCS11Exception) {
                object = new Object(session, l2);
            }
        } else {
            object = new Object(session, l2);
        }
        return object;
    }

    public static VendorDefinedObjectBuilder getVendorDefinedObjectBuilder() {
        return vendorObjectBuilder_;
    }

    public int hashCode() {
        return this.objectClass_.hashCode() ^ (int)this.objectHandle_;
    }

    protected static void putAttributesInTable(Object object) {
        if (object == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        object.attributeTable_.put(Attribute.CLASS, object.objectClass_);
    }

    public void readAttributes(Session session) throws TokenException {
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
    }

    public void setObjectHandle(long l2) {
        this.objectHandle_ = l2;
    }

    public static void setVendorDefinedObjectBuilder(VendorDefinedObjectBuilder vendorDefinedObjectBuilder) {
        vendorObjectBuilder_ = vendorDefinedObjectBuilder;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("  ");
        stringBuffer.append("Object Class: ");
        if (this.objectClass_ != null) {
            stringBuffer.append(this.objectClass_.toString());
        } else {
            stringBuffer.append("<unavailable>");
        }
        return stringBuffer.toString();
    }

    public static interface ObjectClass {
        public static final Long DATA = new Long(0L);
        public static final Long CERTIFICATE = new Long(1L);
        public static final Long PUBLIC_KEY = new Long(2L);
        public static final Long PRIVATE_KEY = new Long(3L);
        public static final Long SECRET_KEY = new Long(4L);
        public static final Long HW_FEATURE = new Long(5L);
        public static final Long DOMAIN_PARAMETERS = new Long(6L);
        public static final Long VENDOR_DEFINED = new Long(0x80000000L);
    }

    public static interface VendorDefinedObjectBuilder {
        public Object build(Session var1, long var2) throws PKCS11Exception;
    }
}

